/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSigningJobResponse extends SignerResponse implements
        ToCopyableBuilder<DescribeSigningJobResponse.Builder, DescribeSigningJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(DescribeSigningJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(DescribeSigningJobResponse::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField
            .<SigningMaterial> builder(MarshallingType.SDK_POJO).memberName("signingMaterial")
            .getter(getter(DescribeSigningJobResponse::signingMaterial)).setter(setter(Builder::signingMaterial))
            .constructor(SigningMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()).build();

    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformId").getter(getter(DescribeSigningJobResponse::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(DescribeSigningJobResponse::profileName))
            .setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()).build();

    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField
            .<SigningPlatformOverrides> builder(MarshallingType.SDK_POJO).memberName("overrides")
            .getter(getter(DescribeSigningJobResponse::overrides)).setter(setter(Builder::overrides))
            .constructor(SigningPlatformOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()).build();

    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("signingParameters")
            .getter(getter(DescribeSigningJobResponse::signingParameters))
            .setter(setter(Builder::signingParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeSigningJobResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt").getter(getter(DescribeSigningJobResponse::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()).build();

    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestedBy").getter(getter(DescribeSigningJobResponse::requestedBy))
            .setter(setter(Builder::requestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeSigningJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(DescribeSigningJobResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.<SignedObject> builder(MarshallingType.SDK_POJO)
            .memberName("signedObject").getter(getter(DescribeSigningJobResponse::signedObject))
            .setter(setter(Builder::signedObject)).constructor(SignedObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD,
            SIGNING_MATERIAL_FIELD, PLATFORM_ID_FIELD, PROFILE_NAME_FIELD, OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD,
            CREATED_AT_FIELD, COMPLETED_AT_FIELD, REQUESTED_BY_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, SIGNED_OBJECT_FIELD));

    private final String jobId;

    private final Source source;

    private final SigningMaterial signingMaterial;

    private final String platformId;

    private final String profileName;

    private final SigningPlatformOverrides overrides;

    private final Map<String, String> signingParameters;

    private final Instant createdAt;

    private final Instant completedAt;

    private final String requestedBy;

    private final String status;

    private final String statusReason;

    private final SignedObject signedObject;

    private DescribeSigningJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signingMaterial = builder.signingMaterial;
        this.platformId = builder.platformId;
        this.profileName = builder.profileName;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.requestedBy = builder.requestedBy;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.signedObject = builder.signedObject;
    }

    /**
     * <p>
     * The ID of the signing job on output.
     * </p>
     * 
     * @return The ID of the signing job on output.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The object that contains the name of your S3 bucket or your raw code.
     * </p>
     * 
     * @return The object that contains the name of your S3 bucket or your raw code.
     */
    public Source source() {
        return source;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your code signing certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your code signing certificate.
     */
    public SigningMaterial signingMaterial() {
        return signingMaterial;
    }

    /**
     * <p>
     * The microcontroller platform to which your signed code image will be distributed.
     * </p>
     * 
     * @return The microcontroller platform to which your signed code image will be distributed.
     */
    public String platformId() {
        return platformId;
    }

    /**
     * <p>
     * The name of the profile that initiated the signing operation.
     * </p>
     * 
     * @return The name of the profile that initiated the signing operation.
     */
    public String profileName() {
        return profileName;
    }

    /**
     * <p>
     * A list of any overrides that were applied to the signing operation.
     * </p>
     * 
     * @return A list of any overrides that were applied to the signing operation.
     */
    public SigningPlatformOverrides overrides() {
        return overrides;
    }

    /**
     * Returns true if the SigningParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSigningParameters() {
        return signingParameters != null && !(signingParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of user-assigned key-value pairs used during signing. These values contain any information that you specified
     * for use in your signing job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSigningParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Map of user-assigned key-value pairs used during signing. These values contain any information that you
     *         specified for use in your signing job.
     */
    public Map<String, String> signingParameters() {
        return signingParameters;
    }

    /**
     * <p>
     * Date and time that the signing job was created.
     * </p>
     * 
     * @return Date and time that the signing job was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date and time that the signing job was completed.
     * </p>
     * 
     * @return Date and time that the signing job was completed.
     */
    public Instant completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The IAM principal that requested the signing job.
     * </p>
     * 
     * @return The IAM principal that requested the signing job.
     */
    public String requestedBy() {
        return requestedBy;
    }

    /**
     * <p>
     * Status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the signing job.
     * @see SigningStatus
     */
    public SigningStatus status() {
        return SigningStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the signing job.
     * @see SigningStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * String value that contains the status reason.
     * </p>
     * 
     * @return String value that contains the status reason.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Name of the S3 bucket where the signed code image is saved by code signing.
     * </p>
     * 
     * @return Name of the S3 bucket where the signed code image is saved by code signing.
     */
    public SignedObject signedObject() {
        return signedObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(overrides());
        hashCode = 31 * hashCode + Objects.hashCode(signingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(signedObject());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSigningJobResponse)) {
            return false;
        }
        DescribeSigningJobResponse other = (DescribeSigningJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(source(), other.source())
                && Objects.equals(signingMaterial(), other.signingMaterial()) && Objects.equals(platformId(), other.platformId())
                && Objects.equals(profileName(), other.profileName()) && Objects.equals(overrides(), other.overrides())
                && Objects.equals(signingParameters(), other.signingParameters())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(requestedBy(), other.requestedBy()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(signedObject(), other.signedObject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSigningJobResponse").add("JobId", jobId()).add("Source", source())
                .add("SigningMaterial", signingMaterial()).add("PlatformId", platformId()).add("ProfileName", profileName())
                .add("Overrides", overrides()).add("SigningParameters", signingParameters()).add("CreatedAt", createdAt())
                .add("CompletedAt", completedAt()).add("RequestedBy", requestedBy()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("SignedObject", signedObject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "signingMaterial":
            return Optional.ofNullable(clazz.cast(signingMaterial()));
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "signingParameters":
            return Optional.ofNullable(clazz.cast(signingParameters()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "requestedBy":
            return Optional.ofNullable(clazz.cast(requestedBy()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "signedObject":
            return Optional.ofNullable(clazz.cast(signedObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSigningJobResponse, T> g) {
        return obj -> g.apply((DescribeSigningJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSigningJobResponse> {
        /**
         * <p>
         * The ID of the signing job on output.
         * </p>
         * 
         * @param jobId
         *        The ID of the signing job on output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The object that contains the name of your S3 bucket or your raw code.
         * </p>
         * 
         * @param source
         *        The object that contains the name of your S3 bucket or your raw code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The object that contains the name of your S3 bucket or your raw code.
         * </p>
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of your code signing certificate.
         * </p>
         * 
         * @param signingMaterial
         *        The Amazon Resource Name (ARN) of your code signing certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingMaterial(SigningMaterial signingMaterial);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of your code signing certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningMaterial.Builder} avoiding the need to
         * create one manually via {@link SigningMaterial#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningMaterial.Builder#build()} is called immediately and its
         * result is passed to {@link #signingMaterial(SigningMaterial)}.
         * 
         * @param signingMaterial
         *        a consumer that will call methods on {@link SigningMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingMaterial(SigningMaterial)
         */
        default Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return signingMaterial(SigningMaterial.builder().applyMutation(signingMaterial).build());
        }

        /**
         * <p>
         * The microcontroller platform to which your signed code image will be distributed.
         * </p>
         * 
         * @param platformId
         *        The microcontroller platform to which your signed code image will be distributed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * The name of the profile that initiated the signing operation.
         * </p>
         * 
         * @param profileName
         *        The name of the profile that initiated the signing operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * A list of any overrides that were applied to the signing operation.
         * </p>
         * 
         * @param overrides
         *        A list of any overrides that were applied to the signing operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(SigningPlatformOverrides overrides);

        /**
         * <p>
         * A list of any overrides that were applied to the signing operation.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningPlatformOverrides.Builder} avoiding the
         * need to create one manually via {@link SigningPlatformOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningPlatformOverrides.Builder#build()} is called immediately
         * and its result is passed to {@link #overrides(SigningPlatformOverrides)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link SigningPlatformOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(SigningPlatformOverrides)
         */
        default Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return overrides(SigningPlatformOverrides.builder().applyMutation(overrides).build());
        }

        /**
         * <p>
         * Map of user-assigned key-value pairs used during signing. These values contain any information that you
         * specified for use in your signing job.
         * </p>
         * 
         * @param signingParameters
         *        Map of user-assigned key-value pairs used during signing. These values contain any information that
         *        you specified for use in your signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingParameters(Map<String, String> signingParameters);

        /**
         * <p>
         * Date and time that the signing job was created.
         * </p>
         * 
         * @param createdAt
         *        Date and time that the signing job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Date and time that the signing job was completed.
         * </p>
         * 
         * @param completedAt
         *        Date and time that the signing job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * The IAM principal that requested the signing job.
         * </p>
         * 
         * @param requestedBy
         *        The IAM principal that requested the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedBy(String requestedBy);

        /**
         * <p>
         * Status of the signing job.
         * </p>
         * 
         * @param status
         *        Status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the signing job.
         * </p>
         * 
         * @param status
         *        Status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(SigningStatus status);

        /**
         * <p>
         * String value that contains the status reason.
         * </p>
         * 
         * @param statusReason
         *        String value that contains the status reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Name of the S3 bucket where the signed code image is saved by code signing.
         * </p>
         * 
         * @param signedObject
         *        Name of the S3 bucket where the signed code image is saved by code signing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedObject(SignedObject signedObject);

        /**
         * <p>
         * Name of the S3 bucket where the signed code image is saved by code signing.
         * </p>
         * This is a convenience that creates an instance of the {@link SignedObject.Builder} avoiding the need to
         * create one manually via {@link SignedObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link SignedObject.Builder#build()} is called immediately and its
         * result is passed to {@link #signedObject(SignedObject)}.
         * 
         * @param signedObject
         *        a consumer that will call methods on {@link SignedObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signedObject(SignedObject)
         */
        default Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return signedObject(SignedObject.builder().applyMutation(signedObject).build());
        }
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private String jobId;

        private Source source;

        private SigningMaterial signingMaterial;

        private String platformId;

        private String profileName;

        private SigningPlatformOverrides overrides;

        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private Instant completedAt;

        private String requestedBy;

        private String status;

        private String statusReason;

        private SignedObject signedObject;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSigningJobResponse model) {
            super(model);
            jobId(model.jobId);
            source(model.source);
            signingMaterial(model.signingMaterial);
            platformId(model.platformId);
            profileName(model.profileName);
            overrides(model.overrides);
            signingParameters(model.signingParameters);
            createdAt(model.createdAt);
            completedAt(model.completedAt);
            requestedBy(model.requestedBy);
            status(model.status);
            statusReason(model.statusReason);
            signedObject(model.signedObject);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return signingMaterial != null ? signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final String getPlatformId() {
            return platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return overrides != null ? overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final Map<String, String> getSigningParameters() {
            return signingParameters;
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        public final String getRequestedBy() {
            return requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final SignedObject.Builder getSignedObject() {
            return signedObject != null ? signedObject.toBuilder() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        @Override
        public DescribeSigningJobResponse build() {
            return new DescribeSigningJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
