/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Any overrides that are applied to the signing configuration of a code signing platform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningPlatformOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningPlatformOverrides.Builder, SigningPlatformOverrides> {
    private static final SdkField<SigningConfigurationOverrides> SIGNING_CONFIGURATION_FIELD = SdkField
            .<SigningConfigurationOverrides> builder(MarshallingType.SDK_POJO).memberName("signingConfiguration")
            .getter(getter(SigningPlatformOverrides::signingConfiguration)).setter(setter(Builder::signingConfiguration))
            .constructor(SigningConfigurationOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingConfiguration").build())
            .build();

    private static final SdkField<String> SIGNING_IMAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signingImageFormat").getter(getter(SigningPlatformOverrides::signingImageFormatAsString))
            .setter(setter(Builder::signingImageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingImageFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_CONFIGURATION_FIELD,
            SIGNING_IMAGE_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SigningConfigurationOverrides signingConfiguration;

    private final String signingImageFormat;

    private SigningPlatformOverrides(BuilderImpl builder) {
        this.signingConfiguration = builder.signingConfiguration;
        this.signingImageFormat = builder.signingImageFormat;
    }

    /**
     * <p>
     * A signing configuration that overrides the default encryption or hash algorithm of a signing job.
     * </p>
     * 
     * @return A signing configuration that overrides the default encryption or hash algorithm of a signing job.
     */
    public final SigningConfigurationOverrides signingConfiguration() {
        return signingConfiguration;
    }

    /**
     * <p>
     * A signed image is a JSON object. When overriding the default signing platform configuration, a customer can
     * select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format
     * value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has the
     * payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingImageFormat} will return {@link ImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingImageFormatAsString}.
     * </p>
     * 
     * @return A signed image is a JSON object. When overriding the default signing platform configuration, a customer
     *         can select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A
     *         third format value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the
     *         signing image has the payload embedded in it. With <code>JSONDetached</code>, the payload is not be
     *         embedded in the signing image.
     * @see ImageFormat
     */
    public final ImageFormat signingImageFormat() {
        return ImageFormat.fromValue(signingImageFormat);
    }

    /**
     * <p>
     * A signed image is a JSON object. When overriding the default signing platform configuration, a customer can
     * select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format
     * value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has the
     * payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #signingImageFormat} will return {@link ImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingImageFormatAsString}.
     * </p>
     * 
     * @return A signed image is a JSON object. When overriding the default signing platform configuration, a customer
     *         can select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A
     *         third format value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the
     *         signing image has the payload embedded in it. With <code>JSONDetached</code>, the payload is not be
     *         embedded in the signing image.
     * @see ImageFormat
     */
    public final String signingImageFormatAsString() {
        return signingImageFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(signingImageFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningPlatformOverrides)) {
            return false;
        }
        SigningPlatformOverrides other = (SigningPlatformOverrides) obj;
        return Objects.equals(signingConfiguration(), other.signingConfiguration())
                && Objects.equals(signingImageFormatAsString(), other.signingImageFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningPlatformOverrides").add("SigningConfiguration", signingConfiguration())
                .add("SigningImageFormat", signingImageFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signingConfiguration":
            return Optional.ofNullable(clazz.cast(signingConfiguration()));
        case "signingImageFormat":
            return Optional.ofNullable(clazz.cast(signingImageFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningPlatformOverrides, T> g) {
        return obj -> g.apply((SigningPlatformOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningPlatformOverrides> {
        /**
         * <p>
         * A signing configuration that overrides the default encryption or hash algorithm of a signing job.
         * </p>
         * 
         * @param signingConfiguration
         *        A signing configuration that overrides the default encryption or hash algorithm of a signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingConfiguration(SigningConfigurationOverrides signingConfiguration);

        /**
         * <p>
         * A signing configuration that overrides the default encryption or hash algorithm of a signing job.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningConfigurationOverrides.Builder} avoiding
         * the need to create one manually via {@link SigningConfigurationOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningConfigurationOverrides.Builder#build()} is called
         * immediately and its result is passed to {@link #signingConfiguration(SigningConfigurationOverrides)}.
         * 
         * @param signingConfiguration
         *        a consumer that will call methods on {@link SigningConfigurationOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingConfiguration(SigningConfigurationOverrides)
         */
        default Builder signingConfiguration(Consumer<SigningConfigurationOverrides.Builder> signingConfiguration) {
            return signingConfiguration(SigningConfigurationOverrides.builder().applyMutation(signingConfiguration).build());
        }

        /**
         * <p>
         * A signed image is a JSON object. When overriding the default signing platform configuration, a customer can
         * select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format
         * value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has
         * the payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing
         * image.
         * </p>
         * 
         * @param signingImageFormat
         *        A signed image is a JSON object. When overriding the default signing platform configuration, a
         *        customer can select either of two signing formats, <code>JSONEmbedded</code> or
         *        <code>JSONDetached</code>. (A third format value, <code>JSON</code>, is reserved for future use.) With
         *        <code>JSONEmbedded</code>, the signing image has the payload embedded in it. With
         *        <code>JSONDetached</code>, the payload is not be embedded in the signing image.
         * @see ImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageFormat
         */
        Builder signingImageFormat(String signingImageFormat);

        /**
         * <p>
         * A signed image is a JSON object. When overriding the default signing platform configuration, a customer can
         * select either of two signing formats, <code>JSONEmbedded</code> or <code>JSONDetached</code>. (A third format
         * value, <code>JSON</code>, is reserved for future use.) With <code>JSONEmbedded</code>, the signing image has
         * the payload embedded in it. With <code>JSONDetached</code>, the payload is not be embedded in the signing
         * image.
         * </p>
         * 
         * @param signingImageFormat
         *        A signed image is a JSON object. When overriding the default signing platform configuration, a
         *        customer can select either of two signing formats, <code>JSONEmbedded</code> or
         *        <code>JSONDetached</code>. (A third format value, <code>JSON</code>, is reserved for future use.) With
         *        <code>JSONEmbedded</code>, the signing image has the payload embedded in it. With
         *        <code>JSONDetached</code>, the payload is not be embedded in the signing image.
         * @see ImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageFormat
         */
        Builder signingImageFormat(ImageFormat signingImageFormat);
    }

    static final class BuilderImpl implements Builder {
        private SigningConfigurationOverrides signingConfiguration;

        private String signingImageFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningPlatformOverrides model) {
            signingConfiguration(model.signingConfiguration);
            signingImageFormat(model.signingImageFormat);
        }

        public final SigningConfigurationOverrides.Builder getSigningConfiguration() {
            return signingConfiguration != null ? signingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder signingConfiguration(SigningConfigurationOverrides signingConfiguration) {
            this.signingConfiguration = signingConfiguration;
            return this;
        }

        public final void setSigningConfiguration(SigningConfigurationOverrides.BuilderImpl signingConfiguration) {
            this.signingConfiguration = signingConfiguration != null ? signingConfiguration.build() : null;
        }

        public final String getSigningImageFormat() {
            return signingImageFormat;
        }

        @Override
        public final Builder signingImageFormat(String signingImageFormat) {
            this.signingImageFormat = signingImageFormat;
            return this;
        }

        @Override
        public final Builder signingImageFormat(ImageFormat signingImageFormat) {
            this.signingImageFormat(signingImageFormat == null ? null : signingImageFormat.toString());
            return this;
        }

        public final void setSigningImageFormat(String signingImageFormat) {
            this.signingImageFormat = signingImageFormat;
        }

        @Override
        public SigningPlatformOverrides build() {
            return new SigningPlatformOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
