/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignedObject;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningStatus;
import software.amazon.awssdk.services.signer.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(SigningJob.getter(SigningJob::jobId)).setter(SigningJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(SigningJob.getter(SigningJob::source)).setter(SigningJob.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signedObject").getter(SigningJob.getter(SigningJob::signedObject)).setter(SigningJob.setter(Builder::signedObject)).constructor(SignedObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingMaterial").getter(SigningJob.getter(SigningJob::signingMaterial)).setter(SigningJob.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SigningJob.getter(SigningJob::createdAt)).setter(SigningJob.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SigningJob.getter(SigningJob::statusAsString)).setter(SigningJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> IS_REVOKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRevoked").getter(SigningJob.getter(SigningJob::isRevoked)).setter(SigningJob.setter(Builder::isRevoked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRevoked").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(SigningJob.getter(SigningJob::profileName)).setter(SigningJob.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersion").getter(SigningJob.getter(SigningJob::profileVersion)).setter(SigningJob.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(SigningJob.getter(SigningJob::platformId)).setter(SigningJob.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<String> PLATFORM_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformDisplayName").getter(SigningJob.getter(SigningJob::platformDisplayName)).setter(SigningJob.setter(Builder::platformDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDisplayName").build()}).build();
    private static final SdkField<Instant> SIGNATURE_EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("signatureExpiresAt").getter(SigningJob.getter(SigningJob::signatureExpiresAt)).setter(SigningJob.setter(Builder::signatureExpiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureExpiresAt").build()}).build();
    private static final SdkField<String> JOB_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobOwner").getter(SigningJob.getter(SigningJob::jobOwner)).setter(SigningJob.setter(Builder::jobOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOwner").build()}).build();
    private static final SdkField<String> JOB_INVOKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobInvoker").getter(SigningJob.getter(SigningJob::jobInvoker)).setter(SigningJob.setter(Builder::jobInvoker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInvoker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD, SIGNED_OBJECT_FIELD, SIGNING_MATERIAL_FIELD, CREATED_AT_FIELD, STATUS_FIELD, IS_REVOKED_FIELD, PROFILE_NAME_FIELD, PROFILE_VERSION_FIELD, PLATFORM_ID_FIELD, PLATFORM_DISPLAY_NAME_FIELD, SIGNATURE_EXPIRES_AT_FIELD, JOB_OWNER_FIELD, JOB_INVOKER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final Source source;
    private final SignedObject signedObject;
    private final SigningMaterial signingMaterial;
    private final Instant createdAt;
    private final String status;
    private final Boolean isRevoked;
    private final String profileName;
    private final String profileVersion;
    private final String platformId;
    private final String platformDisplayName;
    private final Instant signatureExpiresAt;
    private final String jobOwner;
    private final String jobInvoker;

    private SigningJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signedObject = builder.signedObject;
        this.signingMaterial = builder.signingMaterial;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.isRevoked = builder.isRevoked;
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.platformId = builder.platformId;
        this.platformDisplayName = builder.platformDisplayName;
        this.signatureExpiresAt = builder.signatureExpiresAt;
        this.jobOwner = builder.jobOwner;
        this.jobInvoker = builder.jobInvoker;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Source source() {
        return this.source;
    }

    public final SignedObject signedObject() {
        return this.signedObject;
    }

    public final SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final SigningStatus status() {
        return SigningStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean isRevoked() {
        return this.isRevoked;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileVersion() {
        return this.profileVersion;
    }

    public final String platformId() {
        return this.platformId;
    }

    public final String platformDisplayName() {
        return this.platformDisplayName;
    }

    public final Instant signatureExpiresAt() {
        return this.signatureExpiresAt;
    }

    public final String jobOwner() {
        return this.jobOwner;
    }

    public final String jobInvoker() {
        return this.jobInvoker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRevoked());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobInvoker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningJob)) {
            return false;
        }
        SigningJob other = (SigningJob)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.signedObject(), other.signedObject()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.isRevoked(), other.isRevoked()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileVersion(), other.profileVersion()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.platformDisplayName(), other.platformDisplayName()) && Objects.equals(this.signatureExpiresAt(), other.signatureExpiresAt()) && Objects.equals(this.jobOwner(), other.jobOwner()) && Objects.equals(this.jobInvoker(), other.jobInvoker());
    }

    public final String toString() {
        return ToString.builder((String)"SigningJob").add("JobId", (Object)this.jobId()).add("Source", (Object)this.source()).add("SignedObject", (Object)this.signedObject()).add("SigningMaterial", (Object)this.signingMaterial()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("IsRevoked", (Object)this.isRevoked()).add("ProfileName", (Object)this.profileName()).add("ProfileVersion", (Object)this.profileVersion()).add("PlatformId", (Object)this.platformId()).add("PlatformDisplayName", (Object)this.platformDisplayName()).add("SignatureExpiresAt", (Object)this.signatureExpiresAt()).add("JobOwner", (Object)this.jobOwner()).add("JobInvoker", (Object)this.jobInvoker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "signedObject": {
                return Optional.ofNullable(clazz.cast(this.signedObject()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "isRevoked": {
                return Optional.ofNullable(clazz.cast(this.isRevoked()));
            }
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "platformDisplayName": {
                return Optional.ofNullable(clazz.cast(this.platformDisplayName()));
            }
            case "signatureExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.signatureExpiresAt()));
            }
            case "jobOwner": {
                return Optional.ofNullable(clazz.cast(this.jobOwner()));
            }
            case "jobInvoker": {
                return Optional.ofNullable(clazz.cast(this.jobInvoker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningJob, T> g) {
        return obj -> g.apply((SigningJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private Source source;
        private SignedObject signedObject;
        private SigningMaterial signingMaterial;
        private Instant createdAt;
        private String status;
        private Boolean isRevoked;
        private String profileName;
        private String profileVersion;
        private String platformId;
        private String platformDisplayName;
        private Instant signatureExpiresAt;
        private String jobOwner;
        private String jobInvoker;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningJob model) {
            this.jobId(model.jobId);
            this.source(model.source);
            this.signedObject(model.signedObject);
            this.signingMaterial(model.signingMaterial);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.isRevoked(model.isRevoked);
            this.profileName(model.profileName);
            this.profileVersion(model.profileVersion);
            this.platformId(model.platformId);
            this.platformDisplayName(model.platformDisplayName);
            this.signatureExpiresAt(model.signatureExpiresAt);
            this.jobOwner(model.jobOwner);
            this.jobInvoker(model.jobInvoker);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final SignedObject.Builder getSignedObject() {
            return this.signedObject != null ? this.signedObject.toBuilder() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getIsRevoked() {
            return this.isRevoked;
        }

        @Override
        public final Builder isRevoked(Boolean isRevoked) {
            this.isRevoked = isRevoked;
            return this;
        }

        public final void setIsRevoked(Boolean isRevoked) {
            this.isRevoked = isRevoked;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final String getPlatformDisplayName() {
            return this.platformDisplayName;
        }

        @Override
        public final Builder platformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
            return this;
        }

        public final void setPlatformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
        }

        public final Instant getSignatureExpiresAt() {
            return this.signatureExpiresAt;
        }

        @Override
        public final Builder signatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
            return this;
        }

        public final void setSignatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
        }

        public final String getJobOwner() {
            return this.jobOwner;
        }

        @Override
        public final Builder jobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
            return this;
        }

        public final void setJobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
        }

        public final String getJobInvoker() {
            return this.jobInvoker;
        }

        @Override
        public final Builder jobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
            return this;
        }

        public final void setJobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
        }

        public SigningJob build() {
            return new SigningJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningJob> {
        public Builder jobId(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder signedObject(SignedObject var1);

        default public Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return this.signedObject((SignedObject)((SignedObject.Builder)SignedObject.builder().applyMutation(signedObject)).build());
        }

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(SigningStatus var1);

        public Builder isRevoked(Boolean var1);

        public Builder profileName(String var1);

        public Builder profileVersion(String var1);

        public Builder platformId(String var1);

        public Builder platformDisplayName(String var1);

        public Builder signatureExpiresAt(Instant var1);

        public Builder jobOwner(String var1);

        public Builder jobInvoker(String var1);
    }
}

