/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.signer.model.SignatureValidityPeriod;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningParametersCopier;
import software.amazon.awssdk.services.signer.model.SigningPlatformOverrides;
import software.amazon.awssdk.services.signer.model.SigningProfileRevocationRecord;
import software.amazon.awssdk.services.signer.model.SigningProfileStatus;
import software.amazon.awssdk.services.signer.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSigningProfileResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, GetSigningProfileResponse> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::profileName)).setter(GetSigningProfileResponse.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersion").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::profileVersion)).setter(GetSigningProfileResponse.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersionArn").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::profileVersionArn)).setter(GetSigningProfileResponse.setter(Builder::profileVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersionArn").build()}).build();
    private static final SdkField<SigningProfileRevocationRecord> REVOCATION_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("revocationRecord").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::revocationRecord)).setter(GetSigningProfileResponse.setter(Builder::revocationRecord)).constructor(SigningProfileRevocationRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationRecord").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingMaterial").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::signingMaterial)).setter(GetSigningProfileResponse.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::platformId)).setter(GetSigningProfileResponse.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<String> PLATFORM_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformDisplayName").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::platformDisplayName)).setter(GetSigningProfileResponse.setter(Builder::platformDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDisplayName").build()}).build();
    private static final SdkField<SignatureValidityPeriod> SIGNATURE_VALIDITY_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signatureValidityPeriod").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::signatureValidityPeriod)).setter(GetSigningProfileResponse.setter(Builder::signatureValidityPeriod)).constructor(SignatureValidityPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureValidityPeriod").build()}).build();
    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::overrides)).setter(GetSigningProfileResponse.setter(Builder::overrides)).constructor(SigningPlatformOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("signingParameters").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::signingParameters)).setter(GetSigningProfileResponse.setter(Builder::signingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::statusAsString)).setter(GetSigningProfileResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::statusReason)).setter(GetSigningProfileResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::arn)).setter(GetSigningProfileResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::tags)).setter(GetSigningProfileResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, PROFILE_VERSION_FIELD, PROFILE_VERSION_ARN_FIELD, REVOCATION_RECORD_FIELD, SIGNING_MATERIAL_FIELD, PLATFORM_ID_FIELD, PLATFORM_DISPLAY_NAME_FIELD, SIGNATURE_VALIDITY_PERIOD_FIELD, OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ARN_FIELD, TAGS_FIELD));
    private final String profileName;
    private final String profileVersion;
    private final String profileVersionArn;
    private final SigningProfileRevocationRecord revocationRecord;
    private final SigningMaterial signingMaterial;
    private final String platformId;
    private final String platformDisplayName;
    private final SignatureValidityPeriod signatureValidityPeriod;
    private final SigningPlatformOverrides overrides;
    private final Map<String, String> signingParameters;
    private final String status;
    private final String statusReason;
    private final String arn;
    private final Map<String, String> tags;

    private GetSigningProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.profileVersionArn = builder.profileVersionArn;
        this.revocationRecord = builder.revocationRecord;
        this.signingMaterial = builder.signingMaterial;
        this.platformId = builder.platformId;
        this.platformDisplayName = builder.platformDisplayName;
        this.signatureValidityPeriod = builder.signatureValidityPeriod;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileVersion() {
        return this.profileVersion;
    }

    public final String profileVersionArn() {
        return this.profileVersionArn;
    }

    public final SigningProfileRevocationRecord revocationRecord() {
        return this.revocationRecord;
    }

    public final SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public final String platformId() {
        return this.platformId;
    }

    public final String platformDisplayName() {
        return this.platformDisplayName;
    }

    public final SignatureValidityPeriod signatureValidityPeriod() {
        return this.signatureValidityPeriod;
    }

    public final SigningPlatformOverrides overrides() {
        return this.overrides;
    }

    public final boolean hasSigningParameters() {
        return this.signingParameters != null && !(this.signingParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> signingParameters() {
        return this.signingParameters;
    }

    public final SigningProfileStatus status() {
        return SigningProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureValidityPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigningParameters() ? this.signingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSigningProfileResponse)) {
            return false;
        }
        GetSigningProfileResponse other = (GetSigningProfileResponse)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileVersion(), other.profileVersion()) && Objects.equals(this.profileVersionArn(), other.profileVersionArn()) && Objects.equals(this.revocationRecord(), other.revocationRecord()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.platformDisplayName(), other.platformDisplayName()) && Objects.equals(this.signatureValidityPeriod(), other.signatureValidityPeriod()) && Objects.equals(this.overrides(), other.overrides()) && this.hasSigningParameters() == other.hasSigningParameters() && Objects.equals(this.signingParameters(), other.signingParameters()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.arn(), other.arn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetSigningProfileResponse").add("ProfileName", (Object)this.profileName()).add("ProfileVersion", (Object)this.profileVersion()).add("ProfileVersionArn", (Object)this.profileVersionArn()).add("RevocationRecord", (Object)this.revocationRecord()).add("SigningMaterial", (Object)this.signingMaterial()).add("PlatformId", (Object)this.platformId()).add("PlatformDisplayName", (Object)this.platformDisplayName()).add("SignatureValidityPeriod", (Object)this.signatureValidityPeriod()).add("Overrides", (Object)this.overrides()).add("SigningParameters", this.hasSigningParameters() ? this.signingParameters() : null).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Arn", (Object)this.arn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
            case "profileVersionArn": {
                return Optional.ofNullable(clazz.cast(this.profileVersionArn()));
            }
            case "revocationRecord": {
                return Optional.ofNullable(clazz.cast(this.revocationRecord()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "platformDisplayName": {
                return Optional.ofNullable(clazz.cast(this.platformDisplayName()));
            }
            case "signatureValidityPeriod": {
                return Optional.ofNullable(clazz.cast(this.signatureValidityPeriod()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "signingParameters": {
                return Optional.ofNullable(clazz.cast(this.signingParameters()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSigningProfileResponse, T> g) {
        return obj -> g.apply((GetSigningProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private String profileName;
        private String profileVersion;
        private String profileVersionArn;
        private SigningProfileRevocationRecord revocationRecord;
        private SigningMaterial signingMaterial;
        private String platformId;
        private String platformDisplayName;
        private SignatureValidityPeriod signatureValidityPeriod;
        private SigningPlatformOverrides overrides;
        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String statusReason;
        private String arn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSigningProfileResponse model) {
            super(model);
            this.profileName(model.profileName);
            this.profileVersion(model.profileVersion);
            this.profileVersionArn(model.profileVersionArn);
            this.revocationRecord(model.revocationRecord);
            this.signingMaterial(model.signingMaterial);
            this.platformId(model.platformId);
            this.platformDisplayName(model.platformDisplayName);
            this.signatureValidityPeriod(model.signatureValidityPeriod);
            this.overrides(model.overrides);
            this.signingParameters(model.signingParameters);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.arn(model.arn);
            this.tags(model.tags);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        public final String getProfileVersionArn() {
            return this.profileVersionArn;
        }

        @Override
        public final Builder profileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
            return this;
        }

        public final void setProfileVersionArn(String profileVersionArn) {
            this.profileVersionArn = profileVersionArn;
        }

        public final SigningProfileRevocationRecord.Builder getRevocationRecord() {
            return this.revocationRecord != null ? this.revocationRecord.toBuilder() : null;
        }

        @Override
        public final Builder revocationRecord(SigningProfileRevocationRecord revocationRecord) {
            this.revocationRecord = revocationRecord;
            return this;
        }

        public final void setRevocationRecord(SigningProfileRevocationRecord.BuilderImpl revocationRecord) {
            this.revocationRecord = revocationRecord != null ? revocationRecord.build() : null;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final String getPlatformDisplayName() {
            return this.platformDisplayName;
        }

        @Override
        public final Builder platformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
            return this;
        }

        public final void setPlatformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
        }

        public final SignatureValidityPeriod.Builder getSignatureValidityPeriod() {
            return this.signatureValidityPeriod != null ? this.signatureValidityPeriod.toBuilder() : null;
        }

        @Override
        public final Builder signatureValidityPeriod(SignatureValidityPeriod signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod;
            return this;
        }

        public final void setSignatureValidityPeriod(SignatureValidityPeriod.BuilderImpl signatureValidityPeriod) {
            this.signatureValidityPeriod = signatureValidityPeriod != null ? signatureValidityPeriod.build() : null;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final Map<String, String> getSigningParameters() {
            if (this.signingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.signingParameters;
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetSigningProfileResponse build() {
            return new GetSigningProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSigningProfileResponse> {
        public Builder profileName(String var1);

        public Builder profileVersion(String var1);

        public Builder profileVersionArn(String var1);

        public Builder revocationRecord(SigningProfileRevocationRecord var1);

        default public Builder revocationRecord(Consumer<SigningProfileRevocationRecord.Builder> revocationRecord) {
            return this.revocationRecord((SigningProfileRevocationRecord)((SigningProfileRevocationRecord.Builder)SigningProfileRevocationRecord.builder().applyMutation(revocationRecord)).build());
        }

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder platformId(String var1);

        public Builder platformDisplayName(String var1);

        public Builder signatureValidityPeriod(SignatureValidityPeriod var1);

        default public Builder signatureValidityPeriod(Consumer<SignatureValidityPeriod.Builder> signatureValidityPeriod) {
            return this.signatureValidityPeriod((SignatureValidityPeriod)((SignatureValidityPeriod.Builder)SignatureValidityPeriod.builder().applyMutation(signatureValidityPeriod)).build());
        }

        public Builder overrides(SigningPlatformOverrides var1);

        default public Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return this.overrides((SigningPlatformOverrides)((SigningPlatformOverrides.Builder)SigningPlatformOverrides.builder().applyMutation(overrides)).build());
        }

        public Builder signingParameters(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(SigningProfileStatus var1);

        public Builder statusReason(String var1);

        public Builder arn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

