/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Revocation information for a signing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningJobRevocationRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningJobRevocationRecord.Builder, SigningJobRevocationRecord> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(SigningJobRevocationRecord::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("revokedAt").getter(getter(SigningJobRevocationRecord::revokedAt)).setter(setter(Builder::revokedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedAt").build()).build();

    private static final SdkField<String> REVOKED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revokedBy").getter(getter(SigningJobRevocationRecord::revokedBy)).setter(setter(Builder::revokedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            REVOKED_AT_FIELD, REVOKED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final Instant revokedAt;

    private final String revokedBy;

    private SigningJobRevocationRecord(BuilderImpl builder) {
        this.reason = builder.reason;
        this.revokedAt = builder.revokedAt;
        this.revokedBy = builder.revokedBy;
    }

    /**
     * <p>
     * A caller-supplied reason for revocation.
     * </p>
     * 
     * @return A caller-supplied reason for revocation.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * The time of revocation.
     * </p>
     * 
     * @return The time of revocation.
     */
    public final Instant revokedAt() {
        return revokedAt;
    }

    /**
     * <p>
     * The identity of the revoker.
     * </p>
     * 
     * @return The identity of the revoker.
     */
    public final String revokedBy() {
        return revokedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(revokedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningJobRevocationRecord)) {
            return false;
        }
        SigningJobRevocationRecord other = (SigningJobRevocationRecord) obj;
        return Objects.equals(reason(), other.reason()) && Objects.equals(revokedAt(), other.revokedAt())
                && Objects.equals(revokedBy(), other.revokedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningJobRevocationRecord").add("Reason", reason()).add("RevokedAt", revokedAt())
                .add("RevokedBy", revokedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "revokedAt":
            return Optional.ofNullable(clazz.cast(revokedAt()));
        case "revokedBy":
            return Optional.ofNullable(clazz.cast(revokedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningJobRevocationRecord, T> g) {
        return obj -> g.apply((SigningJobRevocationRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningJobRevocationRecord> {
        /**
         * <p>
         * A caller-supplied reason for revocation.
         * </p>
         * 
         * @param reason
         *        A caller-supplied reason for revocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * The time of revocation.
         * </p>
         * 
         * @param revokedAt
         *        The time of revocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedAt(Instant revokedAt);

        /**
         * <p>
         * The identity of the revoker.
         * </p>
         * 
         * @param revokedBy
         *        The identity of the revoker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedBy(String revokedBy);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private Instant revokedAt;

        private String revokedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningJobRevocationRecord model) {
            reason(model.reason);
            revokedAt(model.revokedAt);
            revokedBy(model.revokedBy);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getRevokedAt() {
            return revokedAt;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        @Override
        @Transient
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final String getRevokedBy() {
            return revokedBy;
        }

        public final void setRevokedBy(String revokedBy) {
            this.revokedBy = revokedBy;
        }

        @Override
        @Transient
        public final Builder revokedBy(String revokedBy) {
            this.revokedBy = revokedBy;
            return this;
        }

        @Override
        public SigningJobRevocationRecord build() {
            return new SigningJobRevocationRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
