/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a signing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningJob implements SdkPojo, Serializable, ToCopyableBuilder<SigningJob.Builder, SigningJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(SigningJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(SigningJob::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.<SignedObject> builder(MarshallingType.SDK_POJO)
            .memberName("signedObject").getter(getter(SigningJob::signedObject)).setter(setter(Builder::signedObject))
            .constructor(SignedObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()).build();

    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField
            .<SigningMaterial> builder(MarshallingType.SDK_POJO).memberName("signingMaterial")
            .getter(getter(SigningJob::signingMaterial)).setter(setter(Builder::signingMaterial))
            .constructor(SigningMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SigningJob::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SigningJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> IS_REVOKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRevoked").getter(getter(SigningJob::isRevoked)).setter(setter(Builder::isRevoked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRevoked").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(SigningJob::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersion").getter(getter(SigningJob::profileVersion)).setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()).build();

    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformId").getter(getter(SigningJob::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()).build();

    private static final SdkField<String> PLATFORM_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformDisplayName").getter(getter(SigningJob::platformDisplayName))
            .setter(setter(Builder::platformDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDisplayName").build())
            .build();

    private static final SdkField<Instant> SIGNATURE_EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("signatureExpiresAt").getter(getter(SigningJob::signatureExpiresAt))
            .setter(setter(Builder::signatureExpiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureExpiresAt").build())
            .build();

    private static final SdkField<String> JOB_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobOwner").getter(getter(SigningJob::jobOwner)).setter(setter(Builder::jobOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOwner").build()).build();

    private static final SdkField<String> JOB_INVOKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobInvoker").getter(getter(SigningJob::jobInvoker)).setter(setter(Builder::jobInvoker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInvoker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD,
            SIGNED_OBJECT_FIELD, SIGNING_MATERIAL_FIELD, CREATED_AT_FIELD, STATUS_FIELD, IS_REVOKED_FIELD, PROFILE_NAME_FIELD,
            PROFILE_VERSION_FIELD, PLATFORM_ID_FIELD, PLATFORM_DISPLAY_NAME_FIELD, SIGNATURE_EXPIRES_AT_FIELD, JOB_OWNER_FIELD,
            JOB_INVOKER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final Source source;

    private final SignedObject signedObject;

    private final SigningMaterial signingMaterial;

    private final Instant createdAt;

    private final String status;

    private final Boolean isRevoked;

    private final String profileName;

    private final String profileVersion;

    private final String platformId;

    private final String platformDisplayName;

    private final Instant signatureExpiresAt;

    private final String jobOwner;

    private final String jobInvoker;

    private SigningJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signedObject = builder.signedObject;
        this.signingMaterial = builder.signingMaterial;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.isRevoked = builder.isRevoked;
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.platformId = builder.platformId;
        this.platformDisplayName = builder.platformDisplayName;
        this.signatureExpiresAt = builder.signatureExpiresAt;
        this.jobOwner = builder.jobOwner;
        this.jobInvoker = builder.jobInvoker;
    }

    /**
     * <p>
     * The ID of the signing job.
     * </p>
     * 
     * @return The ID of the signing job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * A <code>Source</code> that contains information about a signing job's code image source.
     * </p>
     * 
     * @return A <code>Source</code> that contains information about a signing job's code image source.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
     * </p>
     * 
     * @return A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
     */
    public final SignedObject signedObject() {
        return signedObject;
    }

    /**
     * <p>
     * A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used for
     * the signing job.
     * </p>
     * 
     * @return A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate
     *         used for the signing job.
     */
    public final SigningMaterial signingMaterial() {
        return signingMaterial;
    }

    /**
     * <p>
     * The date and time that the signing job was created.
     * </p>
     * 
     * @return The date and time that the signing job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the signing job.
     * @see SigningStatus
     */
    public final SigningStatus status() {
        return SigningStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the signing job.
     * @see SigningStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates whether the signing job is revoked.
     * </p>
     * 
     * @return Indicates whether the signing job is revoked.
     */
    public final Boolean isRevoked() {
        return isRevoked;
    }

    /**
     * <p>
     * The name of the signing profile that created a signing job.
     * </p>
     * 
     * @return The name of the signing profile that created a signing job.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The version of the signing profile that created a signing job.
     * </p>
     * 
     * @return The version of the signing profile that created a signing job.
     */
    public final String profileVersion() {
        return profileVersion;
    }

    /**
     * <p>
     * The unique identifier for a signing platform.
     * </p>
     * 
     * @return The unique identifier for a signing platform.
     */
    public final String platformId() {
        return platformId;
    }

    /**
     * <p>
     * The name of a signing platform.
     * </p>
     * 
     * @return The name of a signing platform.
     */
    public final String platformDisplayName() {
        return platformDisplayName;
    }

    /**
     * <p>
     * The time when the signature of a signing job expires.
     * </p>
     * 
     * @return The time when the signature of a signing job expires.
     */
    public final Instant signatureExpiresAt() {
        return signatureExpiresAt;
    }

    /**
     * <p>
     * The AWS account ID of the job owner.
     * </p>
     * 
     * @return The AWS account ID of the job owner.
     */
    public final String jobOwner() {
        return jobOwner;
    }

    /**
     * <p>
     * The AWS account ID of the job invoker.
     * </p>
     * 
     * @return The AWS account ID of the job invoker.
     */
    public final String jobInvoker() {
        return jobInvoker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(signedObject());
        hashCode = 31 * hashCode + Objects.hashCode(signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isRevoked());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(platformDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(signatureExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(jobOwner());
        hashCode = 31 * hashCode + Objects.hashCode(jobInvoker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningJob)) {
            return false;
        }
        SigningJob other = (SigningJob) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(source(), other.source())
                && Objects.equals(signedObject(), other.signedObject())
                && Objects.equals(signingMaterial(), other.signingMaterial()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(isRevoked(), other.isRevoked())
                && Objects.equals(profileName(), other.profileName()) && Objects.equals(profileVersion(), other.profileVersion())
                && Objects.equals(platformId(), other.platformId())
                && Objects.equals(platformDisplayName(), other.platformDisplayName())
                && Objects.equals(signatureExpiresAt(), other.signatureExpiresAt())
                && Objects.equals(jobOwner(), other.jobOwner()) && Objects.equals(jobInvoker(), other.jobInvoker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningJob").add("JobId", jobId()).add("Source", source()).add("SignedObject", signedObject())
                .add("SigningMaterial", signingMaterial()).add("CreatedAt", createdAt()).add("Status", statusAsString())
                .add("IsRevoked", isRevoked()).add("ProfileName", profileName()).add("ProfileVersion", profileVersion())
                .add("PlatformId", platformId()).add("PlatformDisplayName", platformDisplayName())
                .add("SignatureExpiresAt", signatureExpiresAt()).add("JobOwner", jobOwner()).add("JobInvoker", jobInvoker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "signedObject":
            return Optional.ofNullable(clazz.cast(signedObject()));
        case "signingMaterial":
            return Optional.ofNullable(clazz.cast(signingMaterial()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "isRevoked":
            return Optional.ofNullable(clazz.cast(isRevoked()));
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "profileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "platformDisplayName":
            return Optional.ofNullable(clazz.cast(platformDisplayName()));
        case "signatureExpiresAt":
            return Optional.ofNullable(clazz.cast(signatureExpiresAt()));
        case "jobOwner":
            return Optional.ofNullable(clazz.cast(jobOwner()));
        case "jobInvoker":
            return Optional.ofNullable(clazz.cast(jobInvoker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningJob, T> g) {
        return obj -> g.apply((SigningJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningJob> {
        /**
         * <p>
         * The ID of the signing job.
         * </p>
         * 
         * @param jobId
         *        The ID of the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A <code>Source</code> that contains information about a signing job's code image source.
         * </p>
         * 
         * @param source
         *        A <code>Source</code> that contains information about a signing job's code image source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * A <code>Source</code> that contains information about a signing job's code image source.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
         * </p>
         * 
         * @param signedObject
         *        A <code>SignedObject</code> structure that contains information about a signing job's signed code
         *        image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedObject(SignedObject signedObject);

        /**
         * <p>
         * A <code>SignedObject</code> structure that contains information about a signing job's signed code image.
         * </p>
         * This is a convenience method that creates an instance of the {@link SignedObject.Builder} avoiding the need
         * to create one manually via {@link SignedObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link SignedObject.Builder#build()} is called immediately and its
         * result is passed to {@link #signedObject(SignedObject)}.
         * 
         * @param signedObject
         *        a consumer that will call methods on {@link SignedObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signedObject(SignedObject)
         */
        default Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return signedObject(SignedObject.builder().applyMutation(signedObject).build());
        }

        /**
         * <p>
         * A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used
         * for the signing job.
         * </p>
         * 
         * @param signingMaterial
         *        A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate
         *        used for the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingMaterial(SigningMaterial signingMaterial);

        /**
         * <p>
         * A <code>SigningMaterial</code> object that contains the Amazon Resource Name (ARN) of the certificate used
         * for the signing job.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningMaterial.Builder} avoiding the
         * need to create one manually via {@link SigningMaterial#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningMaterial.Builder#build()} is called immediately and its
         * result is passed to {@link #signingMaterial(SigningMaterial)}.
         * 
         * @param signingMaterial
         *        a consumer that will call methods on {@link SigningMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingMaterial(SigningMaterial)
         */
        default Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return signingMaterial(SigningMaterial.builder().applyMutation(signingMaterial).build());
        }

        /**
         * <p>
         * The date and time that the signing job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the signing job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the signing job.
         * </p>
         * 
         * @param status
         *        The status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the signing job.
         * </p>
         * 
         * @param status
         *        The status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(SigningStatus status);

        /**
         * <p>
         * Indicates whether the signing job is revoked.
         * </p>
         * 
         * @param isRevoked
         *        Indicates whether the signing job is revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRevoked(Boolean isRevoked);

        /**
         * <p>
         * The name of the signing profile that created a signing job.
         * </p>
         * 
         * @param profileName
         *        The name of the signing profile that created a signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The version of the signing profile that created a signing job.
         * </p>
         * 
         * @param profileVersion
         *        The version of the signing profile that created a signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);

        /**
         * <p>
         * The unique identifier for a signing platform.
         * </p>
         * 
         * @param platformId
         *        The unique identifier for a signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * The name of a signing platform.
         * </p>
         * 
         * @param platformDisplayName
         *        The name of a signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDisplayName(String platformDisplayName);

        /**
         * <p>
         * The time when the signature of a signing job expires.
         * </p>
         * 
         * @param signatureExpiresAt
         *        The time when the signature of a signing job expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureExpiresAt(Instant signatureExpiresAt);

        /**
         * <p>
         * The AWS account ID of the job owner.
         * </p>
         * 
         * @param jobOwner
         *        The AWS account ID of the job owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOwner(String jobOwner);

        /**
         * <p>
         * The AWS account ID of the job invoker.
         * </p>
         * 
         * @param jobInvoker
         *        The AWS account ID of the job invoker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobInvoker(String jobInvoker);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private Source source;

        private SignedObject signedObject;

        private SigningMaterial signingMaterial;

        private Instant createdAt;

        private String status;

        private Boolean isRevoked;

        private String profileName;

        private String profileVersion;

        private String platformId;

        private String platformDisplayName;

        private Instant signatureExpiresAt;

        private String jobOwner;

        private String jobInvoker;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningJob model) {
            jobId(model.jobId);
            source(model.source);
            signedObject(model.signedObject);
            signingMaterial(model.signingMaterial);
            createdAt(model.createdAt);
            status(model.status);
            isRevoked(model.isRevoked);
            profileName(model.profileName);
            profileVersion(model.profileVersion);
            platformId(model.platformId);
            platformDisplayName(model.platformDisplayName);
            signatureExpiresAt(model.signatureExpiresAt);
            jobOwner(model.jobOwner);
            jobInvoker(model.jobInvoker);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final SignedObject.Builder getSignedObject() {
            return signedObject != null ? signedObject.toBuilder() : null;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return signingMaterial != null ? signingMaterial.toBuilder() : null;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getIsRevoked() {
            return isRevoked;
        }

        public final void setIsRevoked(Boolean isRevoked) {
            this.isRevoked = isRevoked;
        }

        @Override
        public final Builder isRevoked(Boolean isRevoked) {
            this.isRevoked = isRevoked;
            return this;
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final String getPlatformId() {
            return platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getPlatformDisplayName() {
            return platformDisplayName;
        }

        public final void setPlatformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
        }

        @Override
        public final Builder platformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
            return this;
        }

        public final Instant getSignatureExpiresAt() {
            return signatureExpiresAt;
        }

        public final void setSignatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
        }

        @Override
        public final Builder signatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
            return this;
        }

        public final String getJobOwner() {
            return jobOwner;
        }

        public final void setJobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
        }

        @Override
        public final Builder jobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
            return this;
        }

        public final String getJobInvoker() {
            return jobInvoker;
        }

        public final void setJobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
        }

        @Override
        public final Builder jobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
            return this;
        }

        @Override
        public SigningJob build() {
            return new SigningJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
