/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionAlgorithm {
    RSA("RSA"),
    ECDSA("ECDSA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionAlgorithm> VALUE_MAP;
    private final String value;

    private EncryptionAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionAlgorithm> knownValues() {
        EnumSet<EncryptionAlgorithm> knownValues = EnumSet.allOf(EncryptionAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionAlgorithm.class, EncryptionAlgorithm::toString);
    }
}

