/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the signing configurations and parameters that are used to perform a code signing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningPlatform implements SdkPojo, Serializable, ToCopyableBuilder<SigningPlatform.Builder, SigningPlatform> {
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformId").getter(getter(SigningPlatform::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(SigningPlatform::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> PARTNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("partner")
            .getter(getter(SigningPlatform::partner)).setter(setter(Builder::partner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partner").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(SigningPlatform::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(SigningPlatform::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<SigningConfiguration> SIGNING_CONFIGURATION_FIELD = SdkField
            .<SigningConfiguration> builder(MarshallingType.SDK_POJO).memberName("signingConfiguration")
            .getter(getter(SigningPlatform::signingConfiguration)).setter(setter(Builder::signingConfiguration))
            .constructor(SigningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingConfiguration").build())
            .build();

    private static final SdkField<SigningImageFormat> SIGNING_IMAGE_FORMAT_FIELD = SdkField
            .<SigningImageFormat> builder(MarshallingType.SDK_POJO).memberName("signingImageFormat")
            .getter(getter(SigningPlatform::signingImageFormat)).setter(setter(Builder::signingImageFormat))
            .constructor(SigningImageFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingImageFormat").build())
            .build();

    private static final SdkField<Integer> MAX_SIZE_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSizeInMB").getter(getter(SigningPlatform::maxSizeInMB)).setter(setter(Builder::maxSizeInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSizeInMB").build()).build();

    private static final SdkField<Boolean> REVOCATION_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("revocationSupported").getter(getter(SigningPlatform::revocationSupported))
            .setter(setter(Builder::revocationSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationSupported").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ID_FIELD,
            DISPLAY_NAME_FIELD, PARTNER_FIELD, TARGET_FIELD, CATEGORY_FIELD, SIGNING_CONFIGURATION_FIELD,
            SIGNING_IMAGE_FORMAT_FIELD, MAX_SIZE_IN_MB_FIELD, REVOCATION_SUPPORTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platformId;

    private final String displayName;

    private final String partner;

    private final String target;

    private final String category;

    private final SigningConfiguration signingConfiguration;

    private final SigningImageFormat signingImageFormat;

    private final Integer maxSizeInMB;

    private final Boolean revocationSupported;

    private SigningPlatform(BuilderImpl builder) {
        this.platformId = builder.platformId;
        this.displayName = builder.displayName;
        this.partner = builder.partner;
        this.target = builder.target;
        this.category = builder.category;
        this.signingConfiguration = builder.signingConfiguration;
        this.signingImageFormat = builder.signingImageFormat;
        this.maxSizeInMB = builder.maxSizeInMB;
        this.revocationSupported = builder.revocationSupported;
    }

    /**
     * <p>
     * The ID of a code signing; platform.
     * </p>
     * 
     * @return The ID of a code signing; platform.
     */
    public final String platformId() {
        return platformId;
    }

    /**
     * <p>
     * The display name of a code signing platform.
     * </p>
     * 
     * @return The display name of a code signing platform.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Any partner entities linked to a code signing platform.
     * </p>
     * 
     * @return Any partner entities linked to a code signing platform.
     */
    public final String partner() {
        return partner;
    }

    /**
     * <p>
     * The types of targets that can be signed by a code signing platform.
     * </p>
     * 
     * @return The types of targets that can be signed by a code signing platform.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The category of a code signing platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of a code signing platform.
     * @see Category
     */
    public final Category category() {
        return Category.fromValue(category);
    }

    /**
     * <p>
     * The category of a code signing platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of a code signing platform.
     * @see Category
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The configuration of a code signing platform. This includes the designated hash algorithm and encryption
     * algorithm of a signing platform.
     * </p>
     * 
     * @return The configuration of a code signing platform. This includes the designated hash algorithm and encryption
     *         algorithm of a signing platform.
     */
    public final SigningConfiguration signingConfiguration() {
        return signingConfiguration;
    }

    /**
     * Returns the value of the SigningImageFormat property for this object.
     * 
     * @return The value of the SigningImageFormat property for this object.
     */
    public final SigningImageFormat signingImageFormat() {
        return signingImageFormat;
    }

    /**
     * <p>
     * The maximum size (in MB) of code that can be signed by a code signing platform.
     * </p>
     * 
     * @return The maximum size (in MB) of code that can be signed by a code signing platform.
     */
    public final Integer maxSizeInMB() {
        return maxSizeInMB;
    }

    /**
     * <p>
     * Indicates whether revocation is supported for the platform.
     * </p>
     * 
     * @return Indicates whether revocation is supported for the platform.
     */
    public final Boolean revocationSupported() {
        return revocationSupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(partner());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(signingImageFormat());
        hashCode = 31 * hashCode + Objects.hashCode(maxSizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(revocationSupported());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningPlatform)) {
            return false;
        }
        SigningPlatform other = (SigningPlatform) obj;
        return Objects.equals(platformId(), other.platformId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(partner(), other.partner()) && Objects.equals(target(), other.target())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(signingConfiguration(), other.signingConfiguration())
                && Objects.equals(signingImageFormat(), other.signingImageFormat())
                && Objects.equals(maxSizeInMB(), other.maxSizeInMB())
                && Objects.equals(revocationSupported(), other.revocationSupported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningPlatform").add("PlatformId", platformId()).add("DisplayName", displayName())
                .add("Partner", partner()).add("Target", target()).add("Category", categoryAsString())
                .add("SigningConfiguration", signingConfiguration()).add("SigningImageFormat", signingImageFormat())
                .add("MaxSizeInMB", maxSizeInMB()).add("RevocationSupported", revocationSupported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "partner":
            return Optional.ofNullable(clazz.cast(partner()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "signingConfiguration":
            return Optional.ofNullable(clazz.cast(signingConfiguration()));
        case "signingImageFormat":
            return Optional.ofNullable(clazz.cast(signingImageFormat()));
        case "maxSizeInMB":
            return Optional.ofNullable(clazz.cast(maxSizeInMB()));
        case "revocationSupported":
            return Optional.ofNullable(clazz.cast(revocationSupported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningPlatform, T> g) {
        return obj -> g.apply((SigningPlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningPlatform> {
        /**
         * <p>
         * The ID of a code signing; platform.
         * </p>
         * 
         * @param platformId
         *        The ID of a code signing; platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * The display name of a code signing platform.
         * </p>
         * 
         * @param displayName
         *        The display name of a code signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Any partner entities linked to a code signing platform.
         * </p>
         * 
         * @param partner
         *        Any partner entities linked to a code signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partner(String partner);

        /**
         * <p>
         * The types of targets that can be signed by a code signing platform.
         * </p>
         * 
         * @param target
         *        The types of targets that can be signed by a code signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The category of a code signing platform.
         * </p>
         * 
         * @param category
         *        The category of a code signing platform.
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(String category);

        /**
         * <p>
         * The category of a code signing platform.
         * </p>
         * 
         * @param category
         *        The category of a code signing platform.
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(Category category);

        /**
         * <p>
         * The configuration of a code signing platform. This includes the designated hash algorithm and encryption
         * algorithm of a signing platform.
         * </p>
         * 
         * @param signingConfiguration
         *        The configuration of a code signing platform. This includes the designated hash algorithm and
         *        encryption algorithm of a signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingConfiguration(SigningConfiguration signingConfiguration);

        /**
         * <p>
         * The configuration of a code signing platform. This includes the designated hash algorithm and encryption
         * algorithm of a signing platform.
         * </p>
         * This is a convenience that creates an instance of the {@link SigningConfiguration.Builder} avoiding the need
         * to create one manually via {@link SigningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #signingConfiguration(SigningConfiguration)}.
         * 
         * @param signingConfiguration
         *        a consumer that will call methods on {@link SigningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingConfiguration(SigningConfiguration)
         */
        default Builder signingConfiguration(Consumer<SigningConfiguration.Builder> signingConfiguration) {
            return signingConfiguration(SigningConfiguration.builder().applyMutation(signingConfiguration).build());
        }

        /**
         * Sets the value of the SigningImageFormat property for this object.
         *
         * @param signingImageFormat
         *        The new value for the SigningImageFormat property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingImageFormat(SigningImageFormat signingImageFormat);

        /**
         * Sets the value of the SigningImageFormat property for this object.
         *
         * This is a convenience that creates an instance of the {@link SigningImageFormat.Builder} avoiding the need to
         * create one manually via {@link SigningImageFormat#builder()}.
         *
         * When the {@link Consumer} completes, {@link SigningImageFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #signingImageFormat(SigningImageFormat)}.
         * 
         * @param signingImageFormat
         *        a consumer that will call methods on {@link SigningImageFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingImageFormat(SigningImageFormat)
         */
        default Builder signingImageFormat(Consumer<SigningImageFormat.Builder> signingImageFormat) {
            return signingImageFormat(SigningImageFormat.builder().applyMutation(signingImageFormat).build());
        }

        /**
         * <p>
         * The maximum size (in MB) of code that can be signed by a code signing platform.
         * </p>
         * 
         * @param maxSizeInMB
         *        The maximum size (in MB) of code that can be signed by a code signing platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSizeInMB(Integer maxSizeInMB);

        /**
         * <p>
         * Indicates whether revocation is supported for the platform.
         * </p>
         * 
         * @param revocationSupported
         *        Indicates whether revocation is supported for the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationSupported(Boolean revocationSupported);
    }

    static final class BuilderImpl implements Builder {
        private String platformId;

        private String displayName;

        private String partner;

        private String target;

        private String category;

        private SigningConfiguration signingConfiguration;

        private SigningImageFormat signingImageFormat;

        private Integer maxSizeInMB;

        private Boolean revocationSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningPlatform model) {
            platformId(model.platformId);
            displayName(model.displayName);
            partner(model.partner);
            target(model.target);
            category(model.category);
            signingConfiguration(model.signingConfiguration);
            signingImageFormat(model.signingImageFormat);
            maxSizeInMB(model.maxSizeInMB);
            revocationSupported(model.revocationSupported);
        }

        public final String getPlatformId() {
            return platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        @Transient
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getPartner() {
            return partner;
        }

        public final void setPartner(String partner) {
            this.partner = partner;
        }

        @Override
        @Transient
        public final Builder partner(String partner) {
            this.partner = partner;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        @Transient
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(Category category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final SigningConfiguration.Builder getSigningConfiguration() {
            return signingConfiguration != null ? signingConfiguration.toBuilder() : null;
        }

        public final void setSigningConfiguration(SigningConfiguration.BuilderImpl signingConfiguration) {
            this.signingConfiguration = signingConfiguration != null ? signingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder signingConfiguration(SigningConfiguration signingConfiguration) {
            this.signingConfiguration = signingConfiguration;
            return this;
        }

        public final SigningImageFormat.Builder getSigningImageFormat() {
            return signingImageFormat != null ? signingImageFormat.toBuilder() : null;
        }

        public final void setSigningImageFormat(SigningImageFormat.BuilderImpl signingImageFormat) {
            this.signingImageFormat = signingImageFormat != null ? signingImageFormat.build() : null;
        }

        @Override
        @Transient
        public final Builder signingImageFormat(SigningImageFormat signingImageFormat) {
            this.signingImageFormat = signingImageFormat;
            return this;
        }

        public final Integer getMaxSizeInMB() {
            return maxSizeInMB;
        }

        public final void setMaxSizeInMB(Integer maxSizeInMB) {
            this.maxSizeInMB = maxSizeInMB;
        }

        @Override
        @Transient
        public final Builder maxSizeInMB(Integer maxSizeInMB) {
            this.maxSizeInMB = maxSizeInMB;
            return this;
        }

        public final Boolean getRevocationSupported() {
            return revocationSupported;
        }

        public final void setRevocationSupported(Boolean revocationSupported) {
            this.revocationSupported = revocationSupported;
        }

        @Override
        @Transient
        public final Builder revocationSupported(Boolean revocationSupported) {
            this.revocationSupported = revocationSupported;
            return this;
        }

        @Override
        public SigningPlatform build() {
            return new SigningPlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
