/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A cross-account permission for a signing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Permission implements SdkPojo, Serializable, ToCopyableBuilder<Permission.Builder, Permission> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(Permission::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principal").getter(getter(Permission::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statementId").getter(getter(Permission::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersion").getter(getter(Permission::profileVersion)).setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, PRINCIPAL_FIELD,
            STATEMENT_ID_FIELD, PROFILE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String principal;

    private final String statementId;

    private final String profileVersion;

    private Permission(BuilderImpl builder) {
        this.action = builder.action;
        this.principal = builder.principal;
        this.statementId = builder.statementId;
        this.profileVersion = builder.profileVersion;
    }

    /**
     * <p>
     * An AWS Signer action permitted as part of cross-account permissions.
     * </p>
     * 
     * @return An AWS Signer action permitted as part of cross-account permissions.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The AWS principal that has been granted a cross-account permission.
     * </p>
     * 
     * @return The AWS principal that has been granted a cross-account permission.
     */
    public final String principal() {
        return principal;
    }

    /**
     * <p>
     * A unique identifier for a cross-account permission statement.
     * </p>
     * 
     * @return A unique identifier for a cross-account permission statement.
     */
    public final String statementId() {
        return statementId;
    }

    /**
     * <p>
     * The signing profile version that a permission applies to.
     * </p>
     * 
     * @return The signing profile version that a permission applies to.
     */
    public final String profileVersion() {
        return profileVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(principal(), other.principal())
                && Objects.equals(statementId(), other.statementId()) && Objects.equals(profileVersion(), other.profileVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Permission").add("Action", action()).add("Principal", principal())
                .add("StatementId", statementId()).add("ProfileVersion", profileVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "statementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "profileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Permission> {
        /**
         * <p>
         * An AWS Signer action permitted as part of cross-account permissions.
         * </p>
         * 
         * @param action
         *        An AWS Signer action permitted as part of cross-account permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The AWS principal that has been granted a cross-account permission.
         * </p>
         * 
         * @param principal
         *        The AWS principal that has been granted a cross-account permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * A unique identifier for a cross-account permission statement.
         * </p>
         * 
         * @param statementId
         *        A unique identifier for a cross-account permission statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * The signing profile version that a permission applies to.
         * </p>
         * 
         * @param profileVersion
         *        The signing profile version that a permission applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String principal;

        private String statementId;

        private String profileVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            action(model.action);
            principal(model.principal);
            statementId(model.statementId);
            profileVersion(model.profileVersion);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        @Transient
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        @Transient
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        @Transient
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        @Override
        public Permission build() {
            return new Permission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
