/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSigningProfileRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, GetSigningProfileRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(GetSigningProfileRequest.getter(GetSigningProfileRequest::profileName)).setter(GetSigningProfileRequest.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileOwner").getter(GetSigningProfileRequest.getter(GetSigningProfileRequest::profileOwner)).setter(GetSigningProfileRequest.setter(Builder::profileOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("profileOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, PROFILE_OWNER_FIELD));
    private final String profileName;
    private final String profileOwner;

    private GetSigningProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileOwner = builder.profileOwner;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileOwner() {
        return this.profileOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSigningProfileRequest)) {
            return false;
        }
        GetSigningProfileRequest other = (GetSigningProfileRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileOwner(), other.profileOwner());
    }

    public final String toString() {
        return ToString.builder((String)"GetSigningProfileRequest").add("ProfileName", (Object)this.profileName()).add("ProfileOwner", (Object)this.profileOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileOwner": {
                return Optional.ofNullable(clazz.cast(this.profileOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSigningProfileRequest, T> g) {
        return obj -> g.apply((GetSigningProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private String profileOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSigningProfileRequest model) {
            super(model);
            this.profileName(model.profileName);
            this.profileOwner(model.profileOwner);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getProfileOwner() {
            return this.profileOwner;
        }

        @Override
        public final Builder profileOwner(String profileOwner) {
            this.profileOwner = profileOwner;
            return this;
        }

        public final void setProfileOwner(String profileOwner) {
            this.profileOwner = profileOwner;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSigningProfileRequest build() {
            return new GetSigningProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSigningProfileRequest> {
        public Builder profileName(String var1);

        public Builder profileOwner(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

