/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.signer.DefaultSignerAsyncClient;
import software.amazon.awssdk.services.signer.DefaultSignerBaseClientBuilder;
import software.amazon.awssdk.services.signer.SignerAsyncClient;
import software.amazon.awssdk.services.signer.SignerAsyncClientBuilder;
import software.amazon.awssdk.services.signer.SignerServiceClientConfiguration;
import software.amazon.awssdk.services.signer.endpoints.SignerEndpointProvider;

@SdkInternalApi
final class DefaultSignerAsyncClientBuilder
extends DefaultSignerBaseClientBuilder<SignerAsyncClientBuilder, SignerAsyncClient>
implements SignerAsyncClientBuilder {
    DefaultSignerAsyncClientBuilder() {
    }

    @Override
    public DefaultSignerAsyncClientBuilder endpointProvider(SignerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SignerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSignerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SignerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSignerAsyncClient client = new DefaultSignerAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SignerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SignerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

