/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ACM certificate that is used to sign your code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningMaterial implements SdkPojo, Serializable, ToCopyableBuilder<SigningMaterial.Builder, SigningMaterial> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SigningMaterial::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private SigningMaterial(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificates that is used to sign your code.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificates that is used to sign your code.
     */
    public String certificateArn() {
        return certificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningMaterial)) {
            return false;
        }
        SigningMaterial other = (SigningMaterial) obj;
        return Objects.equals(certificateArn(), other.certificateArn());
    }

    @Override
    public String toString() {
        return ToString.builder("SigningMaterial").add("CertificateArn", certificateArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningMaterial, T> g) {
        return obj -> g.apply((SigningMaterial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningMaterial> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificates that is used to sign your code.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificates that is used to sign your code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningMaterial model) {
            certificateArn(model.certificateArn);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public SigningMaterial build() {
            return new SigningMaterial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
