/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSigningJobsResponse extends SignerResponse implements
        ToCopyableBuilder<ListSigningJobsResponse.Builder, ListSigningJobsResponse> {
    private static final SdkField<List<SigningJob>> JOBS_FIELD = SdkField
            .<List<SigningJob>> builder(MarshallingType.LIST)
            .getter(getter(ListSigningJobsResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SigningJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(SigningJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSigningJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD, NEXT_TOKEN_FIELD));

    private final List<SigningJob> jobs;

    private final String nextToken;

    private ListSigningJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of your signing jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of your signing jobs.
     */
    public List<SigningJob> jobs() {
        return jobs;
    }

    /**
     * <p>
     * String for specifying the next set of paginated results.
     * </p>
     * 
     * @return String for specifying the next set of paginated results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningJobsResponse)) {
            return false;
        }
        ListSigningJobsResponse other = (ListSigningJobsResponse) obj;
        return Objects.equals(jobs(), other.jobs()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSigningJobsResponse").add("Jobs", jobs()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSigningJobsResponse, T> g) {
        return obj -> g.apply((ListSigningJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSigningJobsResponse> {
        /**
         * <p>
         * A list of your signing jobs.
         * </p>
         * 
         * @param jobs
         *        A list of your signing jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<SigningJob> jobs);

        /**
         * <p>
         * A list of your signing jobs.
         * </p>
         * 
         * @param jobs
         *        A list of your signing jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(SigningJob... jobs);

        /**
         * <p>
         * A list of your signing jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SigningJob>.Builder} avoiding the need to
         * create one manually via {@link List<SigningJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SigningJob>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobs(List<SigningJob>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<SigningJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<SigningJob>)
         */
        Builder jobs(Consumer<SigningJob.Builder>... jobs);

        /**
         * <p>
         * String for specifying the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        String for specifying the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private List<SigningJob> jobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningJobsResponse model) {
            super(model);
            jobs(model.jobs);
            nextToken(model.nextToken);
        }

        public final Collection<SigningJob.Builder> getJobs() {
            return jobs != null ? jobs.stream().map(SigningJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<SigningJob> jobs) {
            this.jobs = SigningJobsCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(SigningJob... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<SigningJob.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> SigningJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<SigningJob.BuilderImpl> jobs) {
            this.jobs = SigningJobsCopier.copyFromBuilder(jobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSigningJobsResponse build() {
            return new ListSigningJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
