/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Points to an <code>S3SignedObject</code> object that contains information about your signed code image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignedObject implements SdkPojo, Serializable, ToCopyableBuilder<SignedObject.Builder, SignedObject> {
    private static final SdkField<S3SignedObject> S3_FIELD = SdkField.<S3SignedObject> builder(MarshallingType.SDK_POJO)
            .memberName("s3").getter(getter(SignedObject::s3)).setter(setter(Builder::s3)).constructor(S3SignedObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3SignedObject s3;

    private SignedObject(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * The <code>S3SignedObject</code>.
     * </p>
     * 
     * @return The <code>S3SignedObject</code>.
     */
    public final S3SignedObject s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignedObject)) {
            return false;
        }
        SignedObject other = (SignedObject) obj;
        return Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignedObject").add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignedObject, T> g) {
        return obj -> g.apply((SignedObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignedObject> {
        /**
         * <p>
         * The <code>S3SignedObject</code>.
         * </p>
         * 
         * @param s3
         *        The <code>S3SignedObject</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3SignedObject s3);

        /**
         * <p>
         * The <code>S3SignedObject</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3SignedObject.Builder} avoiding the need
         * to create one manually via {@link S3SignedObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3SignedObject.Builder#build()} is called immediately and its
         * result is passed to {@link #s3(S3SignedObject)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3SignedObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3SignedObject)
         */
        default Builder s3(Consumer<S3SignedObject.Builder> s3) {
            return s3(S3SignedObject.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3SignedObject s3;

        private BuilderImpl() {
        }

        private BuilderImpl(SignedObject model) {
            s3(model.s3);
        }

        public final S3SignedObject.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3SignedObject.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3SignedObject s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public SignedObject build() {
            return new SignedObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
