/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningParametersCopier;
import software.amazon.awssdk.services.signer.model.SigningPlatformOverrides;
import software.amazon.awssdk.services.signer.model.SigningProfileStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSigningProfileResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, GetSigningProfileResponse> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::profileName)).setter(GetSigningProfileResponse.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::signingMaterial)).setter(GetSigningProfileResponse.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::platformId)).setter(GetSigningProfileResponse.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::overrides)).setter(GetSigningProfileResponse.setter(Builder::overrides)).constructor(SigningPlatformOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::signingParameters)).setter(GetSigningProfileResponse.setter(Builder::signingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSigningProfileResponse.getter(GetSigningProfileResponse::statusAsString)).setter(GetSigningProfileResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, SIGNING_MATERIAL_FIELD, PLATFORM_ID_FIELD, OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD, STATUS_FIELD));
    private final String profileName;
    private final SigningMaterial signingMaterial;
    private final String platformId;
    private final SigningPlatformOverrides overrides;
    private final Map<String, String> signingParameters;
    private final String status;

    private GetSigningProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.signingMaterial = builder.signingMaterial;
        this.platformId = builder.platformId;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.status = builder.status;
    }

    public String profileName() {
        return this.profileName;
    }

    public SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public String platformId() {
        return this.platformId;
    }

    public SigningPlatformOverrides overrides() {
        return this.overrides;
    }

    public Map<String, String> signingParameters() {
        return this.signingParameters;
    }

    public SigningProfileStatus status() {
        return SigningProfileStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSigningProfileResponse)) {
            return false;
        }
        GetSigningProfileResponse other = (GetSigningProfileResponse)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.signingParameters(), other.signingParameters()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetSigningProfileResponse").add("ProfileName", (Object)this.profileName()).add("SigningMaterial", (Object)this.signingMaterial()).add("PlatformId", (Object)this.platformId()).add("Overrides", (Object)this.overrides()).add("SigningParameters", this.signingParameters()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "signingParameters": {
                return Optional.ofNullable(clazz.cast(this.signingParameters()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSigningProfileResponse, T> g) {
        return obj -> g.apply((GetSigningProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private String profileName;
        private SigningMaterial signingMaterial;
        private String platformId;
        private SigningPlatformOverrides overrides;
        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSigningProfileResponse model) {
            super(model);
            this.profileName(model.profileName);
            this.signingMaterial(model.signingMaterial);
            this.platformId(model.platformId);
            this.overrides(model.overrides);
            this.signingParameters(model.signingParameters);
            this.status(model.status);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final Map<String, String> getSigningParameters() {
            return this.signingParameters;
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningProfileStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetSigningProfileResponse build() {
            return new GetSigningProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSigningProfileResponse> {
        public Builder profileName(String var1);

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder platformId(String var1);

        public Builder overrides(SigningPlatformOverrides var1);

        default public Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return this.overrides((SigningPlatformOverrides)((SigningPlatformOverrides.Builder)SigningPlatformOverrides.builder().applyMutation(overrides)).build());
        }

        public Builder signingParameters(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(SigningProfileStatus var1);
    }
}

