/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSigningPlatformsResponse extends SignerResponse implements
        ToCopyableBuilder<ListSigningPlatformsResponse.Builder, ListSigningPlatformsResponse> {
    private static final SdkField<List<SigningPlatform>> PLATFORMS_FIELD = SdkField
            .<List<SigningPlatform>> builder(MarshallingType.LIST)
            .getter(getter(ListSigningPlatformsResponse::platforms))
            .setter(setter(Builder::platforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SigningPlatform> builder(MarshallingType.SDK_POJO)
                                            .constructor(SigningPlatform::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSigningPlatformsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SigningPlatform> platforms;

    private final String nextToken;

    private ListSigningPlatformsResponse(BuilderImpl builder) {
        super(builder);
        this.platforms = builder.platforms;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of all platforms that match the request parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of all platforms that match the request parameters.
     */
    public List<SigningPlatform> platforms() {
        return platforms;
    }

    /**
     * <p>
     * Value for specifying the next set of paginated results to return.
     * </p>
     * 
     * @return Value for specifying the next set of paginated results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platforms());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningPlatformsResponse)) {
            return false;
        }
        ListSigningPlatformsResponse other = (ListSigningPlatformsResponse) obj;
        return Objects.equals(platforms(), other.platforms()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSigningPlatformsResponse").add("Platforms", platforms()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "platforms":
            return Optional.ofNullable(clazz.cast(platforms()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSigningPlatformsResponse, T> g) {
        return obj -> g.apply((ListSigningPlatformsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSigningPlatformsResponse> {
        /**
         * <p>
         * A list of all platforms that match the request parameters.
         * </p>
         * 
         * @param platforms
         *        A list of all platforms that match the request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platforms(Collection<SigningPlatform> platforms);

        /**
         * <p>
         * A list of all platforms that match the request parameters.
         * </p>
         * 
         * @param platforms
         *        A list of all platforms that match the request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platforms(SigningPlatform... platforms);

        /**
         * <p>
         * A list of all platforms that match the request parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SigningPlatform>.Builder} avoiding the need
         * to create one manually via {@link List<SigningPlatform>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SigningPlatform>.Builder#build()} is called immediately and
         * its result is passed to {@link #platforms(List<SigningPlatform>)}.
         * 
         * @param platforms
         *        a consumer that will call methods on {@link List<SigningPlatform>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platforms(List<SigningPlatform>)
         */
        Builder platforms(Consumer<SigningPlatform.Builder>... platforms);

        /**
         * <p>
         * Value for specifying the next set of paginated results to return.
         * </p>
         * 
         * @param nextToken
         *        Value for specifying the next set of paginated results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private List<SigningPlatform> platforms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningPlatformsResponse model) {
            super(model);
            platforms(model.platforms);
            nextToken(model.nextToken);
        }

        public final Collection<SigningPlatform.Builder> getPlatforms() {
            return platforms != null ? platforms.stream().map(SigningPlatform::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platforms(Collection<SigningPlatform> platforms) {
            this.platforms = SigningPlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(SigningPlatform... platforms) {
            platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<SigningPlatform.Builder>... platforms) {
            platforms(Stream.of(platforms).map(c -> SigningPlatform.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlatforms(Collection<SigningPlatform.BuilderImpl> platforms) {
            this.platforms = SigningPlatformsCopier.copyFromBuilder(platforms);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSigningPlatformsResponse build() {
            return new ListSigningPlatformsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
