/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Destination> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Destination.getter(S3Destination::bucketName)).setter(S3Destination.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Destination.getter(S3Destination::prefix)).setter(S3Destination.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String prefix;

    private S3Destination(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix());
    }

    public String toString() {
        return ToString.builder((String)"S3Destination").add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Destination, T> g) {
        return obj -> g.apply((S3Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public S3Destination build() {
            return new S3Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Destination> {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);
    }
}

