/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignedObject;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningStatus;
import software.amazon.awssdk.services.signer.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigningJob.getter(SigningJob::jobId)).setter(SigningJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SigningJob.getter(SigningJob::source)).setter(SigningJob.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SigningJob.getter(SigningJob::signedObject)).setter(SigningJob.setter(Builder::signedObject)).constructor(SignedObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SigningJob.getter(SigningJob::signingMaterial)).setter(SigningJob.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SigningJob.getter(SigningJob::createdAt)).setter(SigningJob.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigningJob.getter(SigningJob::statusAsString)).setter(SigningJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD, SIGNED_OBJECT_FIELD, SIGNING_MATERIAL_FIELD, CREATED_AT_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final Source source;
    private final SignedObject signedObject;
    private final SigningMaterial signingMaterial;
    private final Instant createdAt;
    private final String status;

    private SigningJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signedObject = builder.signedObject;
        this.signingMaterial = builder.signingMaterial;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    public String jobId() {
        return this.jobId;
    }

    public Source source() {
        return this.source;
    }

    public SignedObject signedObject() {
        return this.signedObject;
    }

    public SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public SigningStatus status() {
        return SigningStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningJob)) {
            return false;
        }
        SigningJob other = (SigningJob)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.signedObject(), other.signedObject()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"SigningJob").add("JobId", (Object)this.jobId()).add("Source", (Object)this.source()).add("SignedObject", (Object)this.signedObject()).add("SigningMaterial", (Object)this.signingMaterial()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "signedObject": {
                return Optional.ofNullable(clazz.cast(this.signedObject()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningJob, T> g) {
        return obj -> g.apply((SigningJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private Source source;
        private SignedObject signedObject;
        private SigningMaterial signingMaterial;
        private Instant createdAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningJob model) {
            this.jobId(model.jobId);
            this.source(model.source);
            this.signedObject(model.signedObject);
            this.signingMaterial(model.signingMaterial);
            this.createdAt(model.createdAt);
            this.status(model.status);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final SignedObject.Builder getSignedObject() {
            return this.signedObject != null ? this.signedObject.toBuilder() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public SigningJob build() {
            return new SigningJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningJob> {
        public Builder jobId(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder signedObject(SignedObject var1);

        default public Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return this.signedObject((SignedObject)((SignedObject.Builder)SignedObject.builder().applyMutation(signedObject)).build());
        }

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(SigningStatus var1);
    }
}

