/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSigningJobsRequest extends SignerRequest implements
        ToCopyableBuilder<ListSigningJobsRequest.Builder, ListSigningJobsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSigningJobsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSigningJobsRequest::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("platformId").build()).build();

    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSigningJobsRequest::requestedBy)).setter(setter(Builder::requestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("requestedBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListSigningJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSigningJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            PLATFORM_ID_FIELD, REQUESTED_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String status;

    private final String platformId;

    private final String requestedBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListSigningJobsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.platformId = builder.platformId;
        this.requestedBy = builder.requestedBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A status value with which to filter your results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status value with which to filter your results.
     * @see SigningStatus
     */
    public SigningStatus status() {
        return SigningStatus.fromValue(status);
    }

    /**
     * <p>
     * A status value with which to filter your results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status value with which to filter your results.
     * @see SigningStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of microcontroller platform that you specified for the distribution of your code image.
     * </p>
     * 
     * @return The ID of microcontroller platform that you specified for the distribution of your code image.
     */
    public String platformId() {
        return platformId;
    }

    /**
     * <p>
     * The IAM principal that requested the signing job.
     * </p>
     * 
     * @return The IAM principal that requested the signing job.
     */
    public String requestedBy() {
        return requestedBy;
    }

    /**
     * <p>
     * Specifies the maximum number of items to return in the response. Use this parameter when paginating results. If
     * additional items exist beyond the number you specify, the <code>nextToken</code> element is set in the response.
     * Use the <code>nextToken</code> value in a subsequent request to retrieve additional items.
     * </p>
     * 
     * @return Specifies the maximum number of items to return in the response. Use this parameter when paginating
     *         results. If additional items exist beyond the number you specify, the <code>nextToken</code> element is
     *         set in the response. Use the <code>nextToken</code> value in a subsequent request to retrieve additional
     *         items.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * String for specifying the next set of paginated results to return. After you receive a response with truncated
     * results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code> from the
     * response that you just received.
     * </p>
     * 
     * @return String for specifying the next set of paginated results to return. After you receive a response with
     *         truncated results, use this parameter in a subsequent request. Set it to the value of
     *         <code>nextToken</code> from the response that you just received.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningJobsRequest)) {
            return false;
        }
        ListSigningJobsRequest other = (ListSigningJobsRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(platformId(), other.platformId())
                && Objects.equals(requestedBy(), other.requestedBy()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSigningJobsRequest").add("Status", statusAsString()).add("PlatformId", platformId())
                .add("RequestedBy", requestedBy()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "requestedBy":
            return Optional.ofNullable(clazz.cast(requestedBy()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSigningJobsRequest, T> g) {
        return obj -> g.apply((ListSigningJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SignerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSigningJobsRequest> {
        /**
         * <p>
         * A status value with which to filter your results.
         * </p>
         * 
         * @param status
         *        A status value with which to filter your results.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status value with which to filter your results.
         * </p>
         * 
         * @param status
         *        A status value with which to filter your results.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(SigningStatus status);

        /**
         * <p>
         * The ID of microcontroller platform that you specified for the distribution of your code image.
         * </p>
         * 
         * @param platformId
         *        The ID of microcontroller platform that you specified for the distribution of your code image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * The IAM principal that requested the signing job.
         * </p>
         * 
         * @param requestedBy
         *        The IAM principal that requested the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedBy(String requestedBy);

        /**
         * <p>
         * Specifies the maximum number of items to return in the response. Use this parameter when paginating results.
         * If additional items exist beyond the number you specify, the <code>nextToken</code> element is set in the
         * response. Use the <code>nextToken</code> value in a subsequent request to retrieve additional items.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of items to return in the response. Use this parameter when paginating
         *        results. If additional items exist beyond the number you specify, the <code>nextToken</code> element
         *        is set in the response. Use the <code>nextToken</code> value in a subsequent request to retrieve
         *        additional items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * String for specifying the next set of paginated results to return. After you receive a response with
         * truncated results, use this parameter in a subsequent request. Set it to the value of <code>nextToken</code>
         * from the response that you just received.
         * </p>
         * 
         * @param nextToken
         *        String for specifying the next set of paginated results to return. After you receive a response with
         *        truncated results, use this parameter in a subsequent request. Set it to the value of
         *        <code>nextToken</code> from the response that you just received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SignerRequest.BuilderImpl implements Builder {
        private String status;

        private String platformId;

        private String requestedBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningJobsRequest model) {
            super(model);
            status(model.status);
            platformId(model.platformId);
            requestedBy(model.requestedBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getPlatformId() {
            return platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final String getRequestedBy() {
            return requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSigningJobsRequest build() {
            return new ListSigningJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
