/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.CountOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksRequest;
import software.amazon.awssdk.services.swf.model.CountPendingDecisionTasksResponse;
import software.amazon.awssdk.services.swf.model.DefaultUndefinedException;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DeprecateDomainRequest;
import software.amazon.awssdk.services.swf.model.DeprecateDomainResponse;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DeprecateWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.DescribeDomainRequest;
import software.amazon.awssdk.services.swf.model.DescribeDomainResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.DomainAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.DomainDeprecatedException;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.LimitExceededException;
import software.amazon.awssdk.services.swf.model.ListActivityTypesRequest;
import software.amazon.awssdk.services.swf.model.ListActivityTypesResponse;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListClosedWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListDomainsRequest;
import software.amazon.awssdk.services.swf.model.ListDomainsResponse;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsRequest;
import software.amazon.awssdk.services.swf.model.ListOpenWorkflowExecutionsResponse;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest;
import software.amazon.awssdk.services.swf.model.ListWorkflowTypesResponse;
import software.amazon.awssdk.services.swf.model.OperationNotPermittedException;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForActivityTaskResponse;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterActivityTypeResponse;
import software.amazon.awssdk.services.swf.model.RegisterDomainRequest;
import software.amazon.awssdk.services.swf.model.RegisterDomainResponse;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeRequest;
import software.amazon.awssdk.services.swf.model.RegisterWorkflowTypeResponse;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.RequestCancelWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedResponse;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedResponse;
import software.amazon.awssdk.services.swf.model.SWFException;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.SignalWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.StartWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionRequest;
import software.amazon.awssdk.services.swf.model.TerminateWorkflowExecutionResponse;
import software.amazon.awssdk.services.swf.model.TypeAlreadyExistsException;
import software.amazon.awssdk.services.swf.model.TypeDeprecatedException;
import software.amazon.awssdk.services.swf.model.UnknownResourceException;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionAlreadyStartedException;
import software.amazon.awssdk.services.swf.transform.CountClosedWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountClosedWorkflowExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.CountOpenWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountOpenWorkflowExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingActivityTasksRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingActivityTasksResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingDecisionTasksRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.CountPendingDecisionTasksResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateActivityTypeResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateDomainResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DeprecateWorkflowTypeResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeActivityTypeResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeDomainResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.DescribeWorkflowTypeResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.GetWorkflowExecutionHistoryRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.GetWorkflowExecutionHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.ListActivityTypesRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListActivityTypesResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.ListClosedWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListClosedWorkflowExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListDomainsResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.ListOpenWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListOpenWorkflowExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.ListWorkflowTypesRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.ListWorkflowTypesResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.PollForActivityTaskRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.PollForActivityTaskResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.PollForDecisionTaskRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.PollForDecisionTaskResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RecordActivityTaskHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RecordActivityTaskHeartbeatResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterActivityTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterActivityTypeResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterDomainRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterDomainResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterWorkflowTypeRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RegisterWorkflowTypeResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RequestCancelWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RequestCancelWorkflowExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCanceledRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCanceledResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCompletedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskCompletedResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskFailedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondActivityTaskFailedResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.RespondDecisionTaskCompletedRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.RespondDecisionTaskCompletedResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.SignalWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.SignalWorkflowExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.StartWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.StartWorkflowExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.swf.transform.TerminateWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.swf.transform.TerminateWorkflowExecutionResponseUnmarshaller;

/**
 * Internal implementation of {@link SWFClient}.
 *
 * @see SWFClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSWFClient implements SWFClient {
    private final ClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    private final AwsSyncClientParams clientParams;

    protected DefaultSWFClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams)
                .withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Returns the number of closed workflow executions within the given domain that meet the specified filtering
     * criteria.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</li>
     * <li><code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</li>
     * <li><code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param countClosedWorkflowExecutionsRequest
     * @return Result of the CountClosedWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.CountClosedWorkflowExecutions
     */
    @Override
    public CountClosedWorkflowExecutionsResponse countClosedWorkflowExecutions(
            CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<CountClosedWorkflowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CountClosedWorkflowExecutionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CountClosedWorkflowExecutionsRequest, CountClosedWorkflowExecutionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(countClosedWorkflowExecutionsRequest)
                        .withMarshaller(new CountClosedWorkflowExecutionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the number of open workflow executions within the given domain that meet the specified filtering
     * criteria.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</li>
     * <li><code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</li>
     * <li><code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param countOpenWorkflowExecutionsRequest
     * @return Result of the CountOpenWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.CountOpenWorkflowExecutions
     */
    @Override
    public CountOpenWorkflowExecutionsResponse countOpenWorkflowExecutions(
            CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<CountOpenWorkflowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CountOpenWorkflowExecutionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CountOpenWorkflowExecutionsRequest, CountOpenWorkflowExecutionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(countOpenWorkflowExecutionsRequest)
                        .withMarshaller(new CountOpenWorkflowExecutionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the estimated number of activity tasks in the specified task list. The count returned is an approximation
     * and is not guaranteed to be exact. If you specify a task list that no activity task was ever scheduled in then 0
     * will be returned.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the <code>taskList.name</code> parameter by using a <b>Condition</b> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param countPendingActivityTasksRequest
     * @return Result of the CountPendingActivityTasks operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.CountPendingActivityTasks
     */
    @Override
    public CountPendingActivityTasksResponse countPendingActivityTasks(
            CountPendingActivityTasksRequest countPendingActivityTasksRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<CountPendingActivityTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CountPendingActivityTasksResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CountPendingActivityTasksRequest, CountPendingActivityTasksResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(countPendingActivityTasksRequest)
                        .withMarshaller(new CountPendingActivityTasksRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the estimated number of decision tasks in the specified task list. The count returned is an approximation
     * and is not guaranteed to be exact. If you specify a task list that no decision task was ever scheduled in then 0
     * will be returned.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the <code>taskList.name</code> parameter by using a <b>Condition</b> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param countPendingDecisionTasksRequest
     * @return Result of the CountPendingDecisionTasks operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.CountPendingDecisionTasks
     */
    @Override
    public CountPendingDecisionTasksResponse countPendingDecisionTasks(
            CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<CountPendingDecisionTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new CountPendingDecisionTasksResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CountPendingDecisionTasksRequest, CountPendingDecisionTasksResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(countPendingDecisionTasksRequest)
                        .withMarshaller(new CountPendingDecisionTasksRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deprecates the specified <i>activity type</i>. After an activity type has been deprecated, you cannot create new
     * tasks of that activity type. Tasks of this type that were scheduled before the type was deprecated will continue
     * to run.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.</li>
     * <li><code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param deprecateActivityTypeRequest
     * @return Result of the DeprecateActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.DeprecateActivityType
     */
    @Override
    public DeprecateActivityTypeResponse deprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest)
            throws UnknownResourceException, TypeDeprecatedException, OperationNotPermittedException, SdkBaseException,
            SdkClientException, SWFException {

        HttpResponseHandler<DeprecateActivityTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeprecateActivityTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeprecateActivityTypeRequest, DeprecateActivityTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deprecateActivityTypeRequest)
                .withMarshaller(new DeprecateActivityTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deprecates the specified domain. After a domain has been deprecated it cannot be used to create new workflow
     * executions or register new types. However, you can still use visibility actions on this domain. Deprecating a
     * domain also deprecates all activity and workflow types registered in the domain. Executions that were started
     * before the domain was deprecated will continue to run.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param deprecateDomainRequest
     * @return Result of the DeprecateDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws DomainDeprecatedException
     *         Returned when the specified domain has been deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.DeprecateDomain
     */
    @Override
    public DeprecateDomainResponse deprecateDomain(DeprecateDomainRequest deprecateDomainRequest)
            throws UnknownResourceException, DomainDeprecatedException, OperationNotPermittedException, SdkBaseException,
            SdkClientException, SWFException {

        HttpResponseHandler<DeprecateDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeprecateDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeprecateDomainRequest, DeprecateDomainResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deprecateDomainRequest).withMarshaller(new DeprecateDomainRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deprecates the specified <i>workflow type</i>. After a workflow type has been deprecated, you cannot create new
     * executions of that type. Executions that were started before the type was deprecated will continue to run. A
     * deprecated workflow type may still be used when calling visibility actions.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</li>
     * <li><code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param deprecateWorkflowTypeRequest
     * @return Result of the DeprecateWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.DeprecateWorkflowType
     */
    @Override
    public DeprecateWorkflowTypeResponse deprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest)
            throws UnknownResourceException, TypeDeprecatedException, OperationNotPermittedException, SdkBaseException,
            SdkClientException, SWFException {

        HttpResponseHandler<DeprecateWorkflowTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DeprecateWorkflowTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeprecateWorkflowTypeRequest, DeprecateWorkflowTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deprecateWorkflowTypeRequest)
                .withMarshaller(new DeprecateWorkflowTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the specified activity type. This includes configuration settings provided when the
     * type was registered and other general information about the type.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.</li>
     * <li><code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param describeActivityTypeRequest
     * @return Result of the DescribeActivityType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.DescribeActivityType
     */
    @Override
    public DescribeActivityTypeResponse describeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest)
            throws UnknownResourceException, OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<DescribeActivityTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeActivityTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeActivityTypeRequest, DescribeActivityTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeActivityTypeRequest)
                .withMarshaller(new DescribeActivityTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the specified domain, including description and status.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param describeDomainRequest
     * @return Result of the DescribeDomain operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.DescribeDomain
     */
    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<DescribeDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeDomainRequest, DescribeDomainResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeDomainRequest).withMarshaller(new DescribeDomainRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the specified workflow execution including its type and some statistics.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param describeWorkflowExecutionRequest
     * @return Result of the DescribeWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.DescribeWorkflowExecution
     */
    @Override
    public DescribeWorkflowExecutionResponse describeWorkflowExecution(
            DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<DescribeWorkflowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeWorkflowExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeWorkflowExecutionRequest, DescribeWorkflowExecutionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeWorkflowExecutionRequest)
                        .withMarshaller(new DescribeWorkflowExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the specified <i>workflow type</i>. This includes configuration settings specified when
     * the type was registered and other information such as creation date, current status, and so on.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</li>
     * <li><code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param describeWorkflowTypeRequest
     * @return Result of the DescribeWorkflowType operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.DescribeWorkflowType
     */
    @Override
    public DescribeWorkflowTypeResponse describeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest)
            throws UnknownResourceException, OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<DescribeWorkflowTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new DescribeWorkflowTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeWorkflowTypeRequest, DescribeWorkflowTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeWorkflowTypeRequest)
                .withMarshaller(new DescribeWorkflowTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the history of the specified workflow execution. The results may be split into multiple pages. To
     * retrieve subsequent pages, make the call again using the <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param getWorkflowExecutionHistoryRequest
     * @return Result of the GetWorkflowExecutionHistory operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.GetWorkflowExecutionHistory
     */
    @Override
    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(
            GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<GetWorkflowExecutionHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new GetWorkflowExecutionHistoryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetWorkflowExecutionHistoryRequest, GetWorkflowExecutionHistoryResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getWorkflowExecutionHistoryRequest)
                        .withMarshaller(new GetWorkflowExecutionHistoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about all activities registered in the specified domain that match the specified name and
     * registration status. The result includes information like creation date, current status of the activity, etc. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * <code>nextPageToken</code> returned by the initial call.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param listActivityTypesRequest
     * @return Result of the ListActivityTypes operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.ListActivityTypes
     */
    @Override
    public ListActivityTypesResponse listActivityTypes(ListActivityTypesRequest listActivityTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<ListActivityTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListActivityTypesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListActivityTypesRequest, ListActivityTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listActivityTypesRequest).withMarshaller(new ListActivityTypesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria. The
     * results may be split into multiple pages. To retrieve subsequent pages, make the call again using the
     * nextPageToken returned by the initial call.
     * </p>
     * <note>This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</li>
     * <li><code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</li>
     * <li><code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param listClosedWorkflowExecutionsRequest
     * @return Result of the ListClosedWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.ListClosedWorkflowExecutions
     */
    @Override
    public ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutions(
            ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<ListClosedWorkflowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListClosedWorkflowExecutionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListClosedWorkflowExecutionsRequest, ListClosedWorkflowExecutionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listClosedWorkflowExecutionsRequest)
                        .withMarshaller(new ListClosedWorkflowExecutionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the list of domains registered in the account. The results may be split into multiple pages. To retrieve
     * subsequent pages, make the call again using the nextPageToken returned by the initial call.
     * </p>
     * <note> This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains. The
     * element must be set to <code>arn:aws:swf::AccountID:domain/*</code>, where <i>AccountID</i> is the account ID,
     * with no dashes.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.ListDomains
     */
    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws OperationNotPermittedException,
            SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<ListDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListDomainsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDomainsRequest, ListDomainsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDomainsRequest).withMarshaller(new ListDomainsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of open workflow executions in the specified domain that meet the filtering criteria. The results
     * may be split into multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
     * returned by the initial call.
     * </p>
     * <note> This operation is eventually consistent. The results are best effort and may not exactly reflect recent
     * updates and changes.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li><code>tagFilter.tag</code>: String constraint. The key is <code>swf:tagFilter.tag</code>.</li>
     * <li><code>typeFilter.name</code>: String constraint. The key is <code>swf:typeFilter.name</code>.</li>
     * <li><code>typeFilter.version</code>: String constraint. The key is <code>swf:typeFilter.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param listOpenWorkflowExecutionsRequest
     * @return Result of the ListOpenWorkflowExecutions operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.ListOpenWorkflowExecutions
     */
    @Override
    public ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutions(
            ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<ListOpenWorkflowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListOpenWorkflowExecutionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListOpenWorkflowExecutionsRequest, ListOpenWorkflowExecutionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listOpenWorkflowExecutionsRequest)
                        .withMarshaller(new ListOpenWorkflowExecutionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about workflow types in the specified domain. The results may be split into multiple pages
     * that can be retrieved by making the call repeatedly.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param listWorkflowTypesRequest
     * @return Result of the ListWorkflowTypes operation returned by the service.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.ListWorkflowTypes
     */
    @Override
    public ListWorkflowTypesResponse listWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest)
            throws OperationNotPermittedException, UnknownResourceException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<ListWorkflowTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new ListWorkflowTypesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListWorkflowTypesRequest, ListWorkflowTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listWorkflowTypesRequest).withMarshaller(new ListWorkflowTypesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by workers to get an <a>ActivityTask</a> from the specified activity <code>taskList</code>. This initiates a
     * long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The
     * maximum time the service holds on to the request before responding is 60 seconds. If no task is available within
     * 60 seconds, the poll will return an empty result. An empty result, in this context, means that an ActivityTask is
     * returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its
     * type to identify and process it correctly.
     * </p>
     * <important>Workers should set their client side socket timeout to at least 70 seconds (10 seconds higher than the
     * maximum time service may hold the poll request).</important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the <code>taskList.name</code> parameter by using a <b>Condition</b> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param pollForActivityTaskRequest
     * @return Result of the PollForActivityTask operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.PollForActivityTask
     */
    @Override
    public PollForActivityTaskResponse pollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest)
            throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, SdkBaseException,
            SdkClientException, SWFException {

        HttpResponseHandler<PollForActivityTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new PollForActivityTaskResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PollForActivityTaskRequest, PollForActivityTaskResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(pollForActivityTaskRequest).withMarshaller(new PollForActivityTaskRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by deciders to get a <a>DecisionTask</a> from the specified decision <code>taskList</code>. A decision task
     * may be returned for any open workflow execution that is using the specified task list. The task includes a
     * paginated view of the history of the workflow execution. The decider should use the workflow type and the history
     * to determine how to properly handle the task.
     * </p>
     * <p>
     * This action initiates a long poll, where the service holds the HTTP connection open and responds as soon a task
     * becomes available. If no decision task is available in the specified task list before the timeout of 60 seconds
     * expires, an empty result is returned. An empty result, in this context, means that a DecisionTask is returned,
     * but that the value of <code>taskToken</code> is an empty string.
     * </p>
     * <important>Deciders should set their client-side socket timeout to at least 70 seconds (10 seconds higher than
     * the timeout).</important> <important>Because the number of workflow history events for a single workflow
     * execution might be very large, the result returned might be split up across a number of pages. To retrieve
     * subsequent pages, make additional calls to <code>PollForDecisionTask</code> using the <code>nextPageToken</code>
     * returned by the initial call. Note that you do <b>not</b> call <code>GetWorkflowExecutionHistory</code> with this
     * <code>nextPageToken</code>. Instead, call <code>PollForDecisionTask</code> again.</important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the <code>taskList.name</code> parameter by using a <b>Condition</b> element with the
     * <code>swf:taskList.name</code> key to allow the action to access only certain task lists.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param pollForDecisionTaskRequest
     * @return Result of the PollForDecisionTask operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.PollForDecisionTask
     */
    @Override
    public PollForDecisionTaskResponse pollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest)
            throws UnknownResourceException, OperationNotPermittedException, LimitExceededException, SdkBaseException,
            SdkClientException, SWFException {

        HttpResponseHandler<PollForDecisionTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new PollForDecisionTaskResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PollForDecisionTaskRequest, PollForDecisionTaskResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(pollForDecisionTaskRequest).withMarshaller(new PollForDecisionTaskRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by activity workers to report to the service that the <a>ActivityTask</a> represented by the specified
     * <code>taskToken</code> is still making progress. The worker can also (optionally) specify details of the
     * progress, for example percent complete, using the <code>details</code> parameter. This action can also be used by
     * the worker as a mechanism to check if cancellation is being requested for the activity task. If a cancellation is
     * being attempted for the specified task, then the boolean <code>cancelRequested</code> flag returned by the
     * service is set to <code>true</code>.
     * </p>
     * <p>
     * This action resets the <code>taskHeartbeatTimeout</code> clock. The <code>taskHeartbeatTimeout</code> is
     * specified in <a>RegisterActivityType</a>.
     * </p>
     * <p>
     * This action does not in itself create an event in the workflow execution history. However, if the task times out,
     * the workflow execution history will contain a <code>ActivityTaskTimedOut</code> event that contains the
     * information from the last heartbeat generated by the activity worker.
     * </p>
     * <note>The <code>taskStartToCloseTimeout</code> of an activity type is the maximum duration of an activity task,
     * regardless of the number of <a>RecordActivityTaskHeartbeat</a> requests received. The
     * <code>taskStartToCloseTimeout</code> is also specified in <a>RegisterActivityType</a>.</note> <note>This
     * operation is only useful for long-lived activities to report liveliness of the task and to determine if a
     * cancellation is being attempted. </note> <important>If the <code>cancelRequested</code> flag returns
     * <code>true</code>, a cancellation is being attempted. If the worker can cancel the activity, it should respond
     * with <a>RespondActivityTaskCanceled</a>. Otherwise, it should ignore the cancellation request.</important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param recordActivityTaskHeartbeatRequest
     * @return Result of the RecordActivityTaskHeartbeat operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RecordActivityTaskHeartbeat
     */
    @Override
    public RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeat(
            RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RecordActivityTaskHeartbeatResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RecordActivityTaskHeartbeatResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RecordActivityTaskHeartbeatRequest, RecordActivityTaskHeartbeatResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(recordActivityTaskHeartbeatRequest)
                        .withMarshaller(new RecordActivityTaskHeartbeatRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers a new <i>activity type</i> along with its configuration settings in the specified domain.
     * </p>
     * <important>A <code>TypeAlreadyExists</code> fault is returned if the type already exists in the domain. You
     * cannot change any configuration settings of the type after its registration, and it must be registered as a new
     * version.</important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li> <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.</li>
     * <li> <code>name</code>: String constraint. The key is <code>swf:name</code>.</li>
     * <li> <code>version</code>: String constraint. The key is <code>swf:version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param registerActivityTypeRequest
     * @return Result of the RegisterActivityType operation returned by the service.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You will get this fault even if the existing
     *         type is in deprecated status. You can specify another version if the intent is to create a new distinct
     *         version of the type.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RegisterActivityType
     */
    @Override
    public RegisterActivityTypeResponse registerActivityType(RegisterActivityTypeRequest registerActivityTypeRequest)
            throws TypeAlreadyExistsException, LimitExceededException, UnknownResourceException, OperationNotPermittedException,
            SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RegisterActivityTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterActivityTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RegisterActivityTypeRequest, RegisterActivityTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(registerActivityTypeRequest)
                .withMarshaller(new RegisterActivityTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers a new domain.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>You cannot use an IAM policy to control domain access for this action. The name of the domain being
     * registered is available as the resource of this action.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param registerDomainRequest
     * @return Result of the RegisterDomain operation returned by the service.
     * @throws DomainAlreadyExistsException
     *         Returned if the specified domain already exists. You will get this fault even if the existing domain is
     *         in deprecated status.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RegisterDomain
     */
    @Override
    public RegisterDomainResponse registerDomain(RegisterDomainRequest registerDomainRequest)
            throws DomainAlreadyExistsException, LimitExceededException, OperationNotPermittedException, SdkBaseException,
            SdkClientException, SWFException {

        HttpResponseHandler<RegisterDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterDomainResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RegisterDomainRequest, RegisterDomainResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(registerDomainRequest).withMarshaller(new RegisterDomainRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers a new <i>workflow type</i> and its configuration settings in the specified domain.
     * </p>
     * <p>
     * The retention period for the workflow history is set by the <a>RegisterDomain</a> action.
     * </p>
     * <important>If the type already exists, then a <code>TypeAlreadyExists</code> fault is returned. You cannot change
     * the configuration settings of a workflow type once it is registered and it must be registered as a new
     * version.</important>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li> <code>defaultTaskList.name</code>: String constraint. The key is <code>swf:defaultTaskList.name</code>.</li>
     * <li> <code>name</code>: String constraint. The key is <code>swf:name</code>.</li>
     * <li> <code>version</code>: String constraint. The key is <code>swf:version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param registerWorkflowTypeRequest
     * @return Result of the RegisterWorkflowType operation returned by the service.
     * @throws TypeAlreadyExistsException
     *         Returned if the type already exists in the specified domain. You will get this fault even if the existing
     *         type is in deprecated status. You can specify another version if the intent is to create a new distinct
     *         version of the type.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RegisterWorkflowType
     */
    @Override
    public RegisterWorkflowTypeResponse registerWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest)
            throws TypeAlreadyExistsException, LimitExceededException, UnknownResourceException, OperationNotPermittedException,
            SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RegisterWorkflowTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RegisterWorkflowTypeResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RegisterWorkflowTypeRequest, RegisterWorkflowTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(registerWorkflowTypeRequest)
                .withMarshaller(new RegisterWorkflowTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionCancelRequested</code> event in the currently running workflow execution
     * identified by the given domain, workflowId, and runId. This logically requests the cancellation of the workflow
     * execution as a whole. It is up to the decider to take appropriate actions when it receives an execution history
     * with this event.
     * </p>
     * <note>If the runId is not specified, the <code>WorkflowExecutionCancelRequested</code> event is recorded in the
     * history of the current open workflow execution with the specified workflowId in the domain.</note> <note>Because
     * this action allows the workflow to properly clean up and gracefully close, it should be used instead of
     * <a>TerminateWorkflowExecution</a> when possible.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param requestCancelWorkflowExecutionRequest
     * @return Result of the RequestCancelWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RequestCancelWorkflowExecution
     */
    @Override
    public RequestCancelWorkflowExecutionResponse requestCancelWorkflowExecution(
            RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RequestCancelWorkflowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RequestCancelWorkflowExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RequestCancelWorkflowExecutionRequest, RequestCancelWorkflowExecutionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(requestCancelWorkflowExecutionRequest)
                        .withMarshaller(new RequestCancelWorkflowExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code> was
     * successfully canceled. Additional <code>details</code> can be optionally provided using the <code>details</code>
     * argument.
     * </p>
     * <p>
     * These <code>details</code> (if provided) appear in the <code>ActivityTaskCanceled</code> event added to the
     * workflow history.
     * </p>
     * <important>Only use this operation if the <code>canceled</code> flag of a <a>RecordActivityTaskHeartbeat</a>
     * request returns <code>true</code> and if the activity can be safely undone or abandoned.</important>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * <a>RespondActivityTaskCompleted</a>, RespondActivityTaskCanceled, <a>RespondActivityTaskFailed</a>, or the task
     * has <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param respondActivityTaskCanceledRequest
     * @return Result of the RespondActivityTaskCanceled operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RespondActivityTaskCanceled
     */
    @Override
    public RespondActivityTaskCanceledResponse respondActivityTaskCanceled(
            RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RespondActivityTaskCanceledResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RespondActivityTaskCanceledResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RespondActivityTaskCanceledRequest, RespondActivityTaskCanceledResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(respondActivityTaskCanceledRequest)
                        .withMarshaller(new RespondActivityTaskCanceledRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code>
     * completed successfully with a <code>result</code> (if provided). The <code>result</code> appears in the
     * <code>ActivityTaskCompleted</code> event in the workflow history.
     * </p>
     * <important> If the requested task does not complete successfully, use <a>RespondActivityTaskFailed</a> instead.
     * If the worker finds that the task is canceled through the <code>canceled</code> flag returned by
     * <a>RecordActivityTaskHeartbeat</a>, it should cancel the task, clean up and then call
     * <a>RespondActivityTaskCanceled</a>.</important>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * RespondActivityTaskCompleted, <a>RespondActivityTaskCanceled</a>, <a>RespondActivityTaskFailed</a>, or the task
     * has <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param respondActivityTaskCompletedRequest
     * @return Result of the RespondActivityTaskCompleted operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RespondActivityTaskCompleted
     */
    @Override
    public RespondActivityTaskCompletedResponse respondActivityTaskCompleted(
            RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RespondActivityTaskCompletedResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RespondActivityTaskCompletedResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RespondActivityTaskCompletedRequest, RespondActivityTaskCompletedResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(respondActivityTaskCompletedRequest)
                        .withMarshaller(new RespondActivityTaskCompletedRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by workers to tell the service that the <a>ActivityTask</a> identified by the <code>taskToken</code> has
     * failed with <code>reason</code> (if specified). The <code>reason</code> and <code>details</code> appear in the
     * <code>ActivityTaskFailed</code> event added to the workflow history.
     * </p>
     * <p>
     * A task is considered open from the time that it is scheduled until it is closed. Therefore a task is reported as
     * open while a worker is processing it. A task is closed after it has been specified in a call to
     * <a>RespondActivityTaskCompleted</a>, <a>RespondActivityTaskCanceled</a>, RespondActivityTaskFailed, or the task
     * has <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types">timed
     * out</a>.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param respondActivityTaskFailedRequest
     * @return Result of the RespondActivityTaskFailed operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RespondActivityTaskFailed
     */
    @Override
    public RespondActivityTaskFailedResponse respondActivityTaskFailed(
            RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RespondActivityTaskFailedResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RespondActivityTaskFailedResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RespondActivityTaskFailedRequest, RespondActivityTaskFailedResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(respondActivityTaskFailedRequest)
                        .withMarshaller(new RespondActivityTaskFailedRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Used by deciders to tell the service that the <a>DecisionTask</a> identified by the <code>taskToken</code> has
     * successfully completed. The <code>decisions</code> argument specifies the list of decisions made while processing
     * the task.
     * </p>
     * <p>
     * A <code>DecisionTaskCompleted</code> event is added to the workflow history. The <code>executionContext</code>
     * specified is attached to the event in the workflow execution history.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * If an IAM policy grants permission to use <code>RespondDecisionTaskCompleted</code>, it can express permissions
     * for the list of decisions in the <code>decisions</code> parameter. Each of the decisions has one or more
     * parameters, much like a regular API call. To allow for policies to be as readable as possible, you can express
     * permissions on decisions as if they were actual API calls, including applying conditions to some parameters. For
     * more information, see <a href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
     * IAM to Manage Access to Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param respondDecisionTaskCompletedRequest
     * @return Result of the RespondDecisionTaskCompleted operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.RespondDecisionTaskCompleted
     */
    @Override
    public RespondDecisionTaskCompletedResponse respondDecisionTaskCompleted(
            RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<RespondDecisionTaskCompletedResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new RespondDecisionTaskCompletedResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RespondDecisionTaskCompletedRequest, RespondDecisionTaskCompletedResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(respondDecisionTaskCompletedRequest)
                        .withMarshaller(new RespondDecisionTaskCompletedRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionSignaled</code> event in the workflow execution history and creates a decision
     * task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with
     * the specified user defined signalName and input (if provided).
     * </p>
     * <note> If a runId is not specified, then the <code>WorkflowExecutionSignaled</code> event is recorded in the
     * history of the current open workflow with the matching workflowId in the domain.</note> <note> If the specified
     * workflow execution is not open, this method fails with <code>UnknownResource</code>.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param signalWorkflowExecutionRequest
     * @return Result of the SignalWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.SignalWorkflowExecution
     */
    @Override
    public SignalWorkflowExecutionResponse signalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest)
            throws UnknownResourceException, OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<SignalWorkflowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new SignalWorkflowExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SignalWorkflowExecutionRequest, SignalWorkflowExecutionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(signalWorkflowExecutionRequest)
                .withMarshaller(new SignalWorkflowExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts an execution of the workflow type in the specified domain using the provided <code>workflowId</code> and
     * input data.
     * </p>
     * <p>
     * This action returns the newly started workflow execution.
     * </p>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
     * <ul>
     * <li> <code>tagList.member.0</code>: The key is <code>swf:tagList.member.0</code>.</li>
     * <li> <code>tagList.member.1</code>: The key is <code>swf:tagList.member.1</code>.</li>
     * <li> <code>tagList.member.2</code>: The key is <code>swf:tagList.member.2</code>.</li>
     * <li> <code>tagList.member.3</code>: The key is <code>swf:tagList.member.3</code>.</li>
     * <li> <code>tagList.member.4</code>: The key is <code>swf:tagList.member.4</code>.</li>
     * <li><code>taskList</code>: String constraint. The key is <code>swf:taskList.name</code>.</li>
     * <li><code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</li>
     * <li><code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param startWorkflowExecutionRequest
     * @return Result of the StartWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws TypeDeprecatedException
     *         Returned when the specified activity or workflow type was already deprecated.
     * @throws WorkflowExecutionAlreadyStartedException
     *         Returned by <a>StartWorkflowExecution</a> when an open execution with the same workflowId is already
     *         running in the specified domain.
     * @throws LimitExceededException
     *         Returned by any operation if a system imposed limitation has been reached. To address this fault you
     *         should either clean up unused resources or increase the limit by contacting AWS.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws DefaultUndefinedException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.StartWorkflowExecution
     */
    @Override
    public StartWorkflowExecutionResponse startWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest)
            throws UnknownResourceException, TypeDeprecatedException, WorkflowExecutionAlreadyStartedException,
            LimitExceededException, OperationNotPermittedException, DefaultUndefinedException, SdkBaseException,
            SdkClientException, SWFException {

        HttpResponseHandler<StartWorkflowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new StartWorkflowExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StartWorkflowExecutionRequest, StartWorkflowExecutionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(startWorkflowExecutionRequest)
                .withMarshaller(new StartWorkflowExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Records a <code>WorkflowExecutionTerminated</code> event and forces closure of the workflow execution identified
     * by the given domain, runId, and workflowId. The child policy, registered with the workflow type or specified when
     * starting this execution, is applied to any open child workflow executions of this workflow execution.
     * </p>
     * <important> If the identified workflow execution was in progress, it is terminated immediately.</important>
     * <note> If a runId is not specified, then the <code>WorkflowExecutionTerminated</code> event is recorded in the
     * history of the current open workflow with the matching workflowId in the domain.</note> <note> You should
     * consider using <a>RequestCancelWorkflowExecution</a> action instead because it allows the workflow to gracefully
     * close while <a>TerminateWorkflowExecution</a> does not.</note>
     * <p>
     * <b>Access Control</b>
     * </p>
     * <p>
     * You can use IAM policies to control this action's access to Amazon SWF resources as follows:
     * </p>
     * <ul>
     * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
     * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
     * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
     * </ul>
     * <p>
     * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
     * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
     * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a>.
     * </p>
     * 
     * @param terminateWorkflowExecutionRequest
     * @return Result of the TerminateWorkflowExecution operation returned by the service.
     * @throws UnknownResourceException
     *         Returned when the named resource cannot be found with in the scope of this operation (region or domain).
     *         This could happen if the named resource was never created or is no longer available for this operation.
     * @throws OperationNotPermittedException
     *         Returned when the caller does not have sufficient permissions to invoke the action.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws SWFException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample SWFClient.TerminateWorkflowExecution
     */
    @Override
    public TerminateWorkflowExecutionResponse terminateWorkflowExecution(
            TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) throws UnknownResourceException,
            OperationNotPermittedException, SdkBaseException, SdkClientException, SWFException {

        HttpResponseHandler<TerminateWorkflowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true), new TerminateWorkflowExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<TerminateWorkflowExecutionRequest, TerminateWorkflowExecutionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(terminateWorkflowExecutionRequest)
                        .withMarshaller(new TerminateWorkflowExecutionRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata()
                .withProtocolVersion("1.0")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(software.amazon.awssdk.services.swf.model.SWFException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DomainAlreadyExistsFault").withModeledClass(
                                DomainAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TypeAlreadyExistsFault").withModeledClass(
                                TypeAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedFault").withModeledClass(
                                OperationNotPermittedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TypeDeprecatedFault").withModeledClass(
                                TypeDeprecatedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("LimitExceededFault").withModeledClass(
                                LimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("WorkflowExecutionAlreadyStartedFault").withModeledClass(
                                WorkflowExecutionAlreadyStartedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnknownResourceFault").withModeledClass(
                                UnknownResourceException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DomainDeprecatedFault").withModeledClass(
                                DomainDeprecatedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DefaultUndefinedFault").withModeledClass(
                                DefaultUndefinedException.class)));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }
}
