/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ActivityTypeConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings registered with the activity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActivityTypeConfiguration implements StructuredPojo,
        ToCopyableBuilder<ActivityTypeConfiguration.Builder, ActivityTypeConfiguration> {
    private final String defaultTaskStartToCloseTimeout;

    private final String defaultTaskHeartbeatTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultTaskScheduleToStartTimeout;

    private final String defaultTaskScheduleToCloseTimeout;

    private ActivityTypeConfiguration(BuilderImpl builder) {
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultTaskHeartbeatTimeout = builder.defaultTaskHeartbeatTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultTaskScheduleToStartTimeout = builder.defaultTaskScheduleToStartTimeout;
        this.defaultTaskScheduleToCloseTimeout = builder.defaultTaskScheduleToCloseTimeout;
    }

    /**
     * <p>
     * <i>Optional.</i> The default maximum duration for tasks of an activity type specified when registering the
     * activity type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
     * decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return Optional.</i> The default maximum duration for tasks of an activity type specified when registering the
     *         activity type. You can override this default when scheduling a task through the
     *         <code>ScheduleActivityTask</code> decision.</p>
     */
    public String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * <i>Optional.</i> The default maximum time, in seconds, before which a worker processing a task must report
     * progress by calling <a>RecordActivityTaskHeartbeat</a>.
     * </p>
     * <p>
     * You can specify this value only when <i>registering</i> an activity type. The registered default value can be
     * overridden when you schedule a task through the <code>ScheduleActivityTask</code> decision. If the activity
     * worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an
     * <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be valid;
     * the activity worker should clean up the activity task.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return Optional.</i> The default maximum time, in seconds, before which a worker processing a task must report
     *         progress by calling <a>RecordActivityTaskHeartbeat</a>.</p>
     *         <p>
     *         You can specify this value only when <i>registering</i> an activity type. The registered default value
     *         can be overridden when you schedule a task through the <code>ScheduleActivityTask</code> decision. If the
     *         activity worker subsequently attempts to record a heartbeat or returns a result, the activity worker
     *         receives an <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity
     *         task to be valid; the activity worker should clean up the activity task.
     *         </p>
     */
    public String defaultTaskHeartbeatTimeout() {
        return defaultTaskHeartbeatTimeout;
    }

    /**
     * <p>
     * <i>Optional.</i> The default task list specified for this activity type at registration. This default is used if
     * a task list is not provided when a task is scheduled through the <code>ScheduleActivityTask</code> decision. You
     * can override the default registered task list when scheduling a task through the
     * <code>ScheduleActivityTask</code> decision.
     * </p>
     * 
     * @return Optional.</i> The default task list specified for this activity type at registration. This default is
     *         used if a task list is not provided when a task is scheduled through the
     *         <code>ScheduleActivityTask</code> decision. You can override the default registered task list when
     *         scheduling a task through the <code>ScheduleActivityTask
     */
    public TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * <i>Optional.</i> The default task priority for tasks of this activity type, specified at registration. If not
     * set, then "0" will be used as the default priority. This default can be overridden when scheduling an activity
     * task.
     * </p>
     * <p>
     * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return Optional.</i> The default task priority for tasks of this activity type, specified at registration. If
     *         not set, then "0" will be used as the default priority. This default can be overridden when scheduling an
     *         activity task.</p>
     *         <p>
     *         Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     *         </p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide
     */
    public String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * <i>Optional.</i> The default maximum duration, specified when registering the activity type, that a task of an
     * activity type can wait before being assigned to a worker. You can override this default when scheduling a task
     * through the <code>ScheduleActivityTask</code> decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return Optional.</i> The default maximum duration, specified when registering the activity type, that a task of
     *         an activity type can wait before being assigned to a worker. You can override this default when
     *         scheduling a task through the <code>ScheduleActivityTask</code> decision.</p>
     */
    public String defaultTaskScheduleToStartTimeout() {
        return defaultTaskScheduleToStartTimeout;
    }

    /**
     * <p>
     * <i>Optional.</i> The default maximum duration, specified when registering the activity type, for tasks of this
     * activity type. You can override this default when scheduling a task through the <code>ScheduleActivityTask</code>
     * decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return Optional.</i> The default maximum duration, specified when registering the activity type, for tasks of
     *         this activity type. You can override this default when scheduling a task through the
     *         <code>ScheduleActivityTask</code> decision.</p>
     */
    public String defaultTaskScheduleToCloseTimeout() {
        return defaultTaskScheduleToCloseTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((defaultTaskStartToCloseTimeout() == null) ? 0 : defaultTaskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskHeartbeatTimeout() == null) ? 0 : defaultTaskHeartbeatTimeout().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskList() == null) ? 0 : defaultTaskList().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskPriority() == null) ? 0 : defaultTaskPriority().hashCode());
        hashCode = 31 * hashCode
                + ((defaultTaskScheduleToStartTimeout() == null) ? 0 : defaultTaskScheduleToStartTimeout().hashCode());
        hashCode = 31 * hashCode
                + ((defaultTaskScheduleToCloseTimeout() == null) ? 0 : defaultTaskScheduleToCloseTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityTypeConfiguration)) {
            return false;
        }
        ActivityTypeConfiguration other = (ActivityTypeConfiguration) obj;
        if (other.defaultTaskStartToCloseTimeout() == null ^ this.defaultTaskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultTaskStartToCloseTimeout() != null
                && !other.defaultTaskStartToCloseTimeout().equals(this.defaultTaskStartToCloseTimeout())) {
            return false;
        }
        if (other.defaultTaskHeartbeatTimeout() == null ^ this.defaultTaskHeartbeatTimeout() == null) {
            return false;
        }
        if (other.defaultTaskHeartbeatTimeout() != null
                && !other.defaultTaskHeartbeatTimeout().equals(this.defaultTaskHeartbeatTimeout())) {
            return false;
        }
        if (other.defaultTaskList() == null ^ this.defaultTaskList() == null) {
            return false;
        }
        if (other.defaultTaskList() != null && !other.defaultTaskList().equals(this.defaultTaskList())) {
            return false;
        }
        if (other.defaultTaskPriority() == null ^ this.defaultTaskPriority() == null) {
            return false;
        }
        if (other.defaultTaskPriority() != null && !other.defaultTaskPriority().equals(this.defaultTaskPriority())) {
            return false;
        }
        if (other.defaultTaskScheduleToStartTimeout() == null ^ this.defaultTaskScheduleToStartTimeout() == null) {
            return false;
        }
        if (other.defaultTaskScheduleToStartTimeout() != null
                && !other.defaultTaskScheduleToStartTimeout().equals(this.defaultTaskScheduleToStartTimeout())) {
            return false;
        }
        if (other.defaultTaskScheduleToCloseTimeout() == null ^ this.defaultTaskScheduleToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultTaskScheduleToCloseTimeout() != null
                && !other.defaultTaskScheduleToCloseTimeout().equals(this.defaultTaskScheduleToCloseTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (defaultTaskStartToCloseTimeout() != null) {
            sb.append("DefaultTaskStartToCloseTimeout: ").append(defaultTaskStartToCloseTimeout()).append(",");
        }
        if (defaultTaskHeartbeatTimeout() != null) {
            sb.append("DefaultTaskHeartbeatTimeout: ").append(defaultTaskHeartbeatTimeout()).append(",");
        }
        if (defaultTaskList() != null) {
            sb.append("DefaultTaskList: ").append(defaultTaskList()).append(",");
        }
        if (defaultTaskPriority() != null) {
            sb.append("DefaultTaskPriority: ").append(defaultTaskPriority()).append(",");
        }
        if (defaultTaskScheduleToStartTimeout() != null) {
            sb.append("DefaultTaskScheduleToStartTimeout: ").append(defaultTaskScheduleToStartTimeout()).append(",");
        }
        if (defaultTaskScheduleToCloseTimeout() != null) {
            sb.append("DefaultTaskScheduleToCloseTimeout: ").append(defaultTaskScheduleToCloseTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivityTypeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ActivityTypeConfiguration> {
        /**
         * <p>
         * <i>Optional.</i> The default maximum duration for tasks of an activity type specified when registering the
         * activity type. You can override this default when scheduling a task through the
         * <code>ScheduleActivityTask</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        Optional.</i> The default maximum duration for tasks of an activity type specified when registering
         *        the activity type. You can override this default when scheduling a task through the
         *        <code>ScheduleActivityTask</code> decision.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * <i>Optional.</i> The default maximum time, in seconds, before which a worker processing a task must report
         * progress by calling <a>RecordActivityTaskHeartbeat</a>.
         * </p>
         * <p>
         * You can specify this value only when <i>registering</i> an activity type. The registered default value can be
         * overridden when you schedule a task through the <code>ScheduleActivityTask</code> decision. If the activity
         * worker subsequently attempts to record a heartbeat or returns a result, the activity worker receives an
         * <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to be
         * valid; the activity worker should clean up the activity task.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskHeartbeatTimeout
         *        Optional.</i> The default maximum time, in seconds, before which a worker processing a task must
         *        report progress by calling <a>RecordActivityTaskHeartbeat</a>.</p>
         *        <p>
         *        You can specify this value only when <i>registering</i> an activity type. The registered default value
         *        can be overridden when you schedule a task through the <code>ScheduleActivityTask</code> decision. If
         *        the activity worker subsequently attempts to record a heartbeat or returns a result, the activity
         *        worker receives an <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers
         *        the activity task to be valid; the activity worker should clean up the activity task.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout);

        /**
         * <p>
         * <i>Optional.</i> The default task list specified for this activity type at registration. This default is used
         * if a task list is not provided when a task is scheduled through the <code>ScheduleActivityTask</code>
         * decision. You can override the default registered task list when scheduling a task through the
         * <code>ScheduleActivityTask</code> decision.
         * </p>
         * 
         * @param defaultTaskList
         *        Optional.</i> The default task list specified for this activity type at registration. This default is
         *        used if a task list is not provided when a task is scheduled through the
         *        <code>ScheduleActivityTask</code> decision. You can override the default registered task list when
         *        scheduling a task through the <code>ScheduleActivityTask
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * <i>Optional.</i> The default task priority for tasks of this activity type, specified at registration. If not
         * set, then "0" will be used as the default priority. This default can be overridden when scheduling an
         * activity task.
         * </p>
         * <p>
         * Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        Optional.</i> The default task priority for tasks of this activity type, specified at registration. If
         *        not set, then "0" will be used as the default priority. This default can be overridden when scheduling
         *        an activity task.</p>
         *        <p>
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         *        </p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * <i>Optional.</i> The default maximum duration, specified when registering the activity type, that a task of
         * an activity type can wait before being assigned to a worker. You can override this default when scheduling a
         * task through the <code>ScheduleActivityTask</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToStartTimeout
         *        Optional.</i> The default maximum duration, specified when registering the activity type, that a task
         *        of an activity type can wait before being assigned to a worker. You can override this default when
         *        scheduling a task through the <code>ScheduleActivityTask</code> decision.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout);

        /**
         * <p>
         * <i>Optional.</i> The default maximum duration, specified when registering the activity type, for tasks of
         * this activity type. You can override this default when scheduling a task through the
         * <code>ScheduleActivityTask</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToCloseTimeout
         *        Optional.</i> The default maximum duration, specified when registering the activity type, for tasks of
         *        this activity type. You can override this default when scheduling a task through the
         *        <code>ScheduleActivityTask</code> decision.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private String defaultTaskStartToCloseTimeout;

        private String defaultTaskHeartbeatTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultTaskScheduleToStartTimeout;

        private String defaultTaskScheduleToCloseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivityTypeConfiguration model) {
            setDefaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            setDefaultTaskHeartbeatTimeout(model.defaultTaskHeartbeatTimeout);
            setDefaultTaskList(model.defaultTaskList);
            setDefaultTaskPriority(model.defaultTaskPriority);
            setDefaultTaskScheduleToStartTimeout(model.defaultTaskScheduleToStartTimeout);
            setDefaultTaskScheduleToCloseTimeout(model.defaultTaskScheduleToCloseTimeout);
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        public final String getDefaultTaskHeartbeatTimeout() {
            return defaultTaskHeartbeatTimeout;
        }

        @Override
        public final Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
            return this;
        }

        public final void setDefaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
        }

        public final TaskList getDefaultTaskList() {
            return defaultTaskList;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final void setDefaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        public final String getDefaultTaskScheduleToStartTimeout() {
            return defaultTaskScheduleToStartTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
            return this;
        }

        public final void setDefaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
        }

        public final String getDefaultTaskScheduleToCloseTimeout() {
            return defaultTaskScheduleToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
        }

        @Override
        public ActivityTypeConfiguration build() {
            return new ActivityTypeConfiguration(this);
        }
    }
}
