/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.CancelTimerDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>CancelTimer</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelTimerDecisionAttributes implements StructuredPojo,
        ToCopyableBuilder<CancelTimerDecisionAttributes.Builder, CancelTimerDecisionAttributes> {
    private final String timerId;

    private CancelTimerDecisionAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
    }

    /**
     * <p>
     * <b>Required.</b> The unique ID of the timer to cancel.
     * </p>
     * 
     * @return Required.
     */
    public String timerId() {
        return timerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timerId() == null) ? 0 : timerId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelTimerDecisionAttributes)) {
            return false;
        }
        CancelTimerDecisionAttributes other = (CancelTimerDecisionAttributes) obj;
        if (other.timerId() == null ^ this.timerId() == null) {
            return false;
        }
        if (other.timerId() != null && !other.timerId().equals(this.timerId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timerId() != null) {
            sb.append("TimerId: ").append(timerId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CancelTimerDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CancelTimerDecisionAttributes> {
        /**
         * <p>
         * <b>Required.</b> The unique ID of the timer to cancel.
         * </p>
         * 
         * @param timerId
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);
    }

    private static final class BuilderImpl implements Builder {
        private String timerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelTimerDecisionAttributes model) {
            setTimerId(model.timerId);
        }

        public final String getTimerId() {
            return timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        @Override
        public CancelTimerDecisionAttributes build() {
            return new CancelTimerDecisionAttributes(this);
        }
    }
}
