/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CountPendingActivityTasksRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CountPendingActivityTasksRequest.Builder, CountPendingActivityTasksRequest> {
    private final String domain;

    private final TaskList taskList;

    private CountPendingActivityTasksRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.taskList = builder.taskList;
    }

    /**
     * <p>
     * The name of the domain that contains the task list.
     * </p>
     * 
     * @return The name of the domain that contains the task list.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the task list.
     * </p>
     * 
     * @return The name of the task list.
     */
    public TaskList taskList() {
        return taskList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountPendingActivityTasksRequest)) {
            return false;
        }
        CountPendingActivityTasksRequest other = (CountPendingActivityTasksRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CountPendingActivityTasksRequest> {
        /**
         * <p>
         * The name of the domain that contains the task list.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the task list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the task list.
         * </p>
         * 
         * @param taskList
         *        The name of the task list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private TaskList taskList;

        private BuilderImpl() {
        }

        private BuilderImpl(CountPendingActivityTasksRequest model) {
            setDomain(model.domain);
            setTaskList(model.taskList);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        @Override
        public CountPendingActivityTasksRequest build() {
            return new CountPendingActivityTasksRequest(this);
        }
    }
}
