/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the count of tasks in a task list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CountPendingDecisionTasksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CountPendingDecisionTasksResponse.Builder, CountPendingDecisionTasksResponse> {
    private final Integer count;

    private final Boolean truncated;

    private CountPendingDecisionTasksResponse(BuilderImpl builder) {
        this.count = builder.count;
        this.truncated = builder.truncated;
    }

    /**
     * <p>
     * The number of tasks in the task list.
     * </p>
     * 
     * @return The number of tasks in the task list.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * If set to true, indicates that the actual count was more than the maximum supported by this API and the count
     * returned is the truncated value.
     * </p>
     * 
     * @return If set to true, indicates that the actual count was more than the maximum supported by this API and the
     *         count returned is the truncated value.
     */
    public Boolean truncated() {
        return truncated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((count() == null) ? 0 : count().hashCode());
        hashCode = 31 * hashCode + ((truncated() == null) ? 0 : truncated().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountPendingDecisionTasksResponse)) {
            return false;
        }
        CountPendingDecisionTasksResponse other = (CountPendingDecisionTasksResponse) obj;
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.truncated() == null ^ this.truncated() == null) {
            return false;
        }
        if (other.truncated() != null && !other.truncated().equals(this.truncated())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (count() != null) {
            sb.append("Count: ").append(count()).append(",");
        }
        if (truncated() != null) {
            sb.append("Truncated: ").append(truncated()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CountPendingDecisionTasksResponse> {
        /**
         * <p>
         * The number of tasks in the task list.
         * </p>
         * 
         * @param count
         *        The number of tasks in the task list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * If set to true, indicates that the actual count was more than the maximum supported by this API and the count
         * returned is the truncated value.
         * </p>
         * 
         * @param truncated
         *        If set to true, indicates that the actual count was more than the maximum supported by this API and
         *        the count returned is the truncated value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truncated(Boolean truncated);
    }

    private static final class BuilderImpl implements Builder {
        private Integer count;

        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(CountPendingDecisionTasksResponse model) {
            setCount(model.count);
            setTruncated(model.truncated);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Boolean getTruncated() {
            return truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public CountPendingDecisionTasksResponse build() {
            return new CountPendingDecisionTasksResponse(this);
        }
    }
}
