/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDomainResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeDomainResponse.Builder, DescribeDomainResponse> {
    private final DomainInfo domainInfo;

    private final DomainConfiguration configuration;

    private DescribeDomainResponse(BuilderImpl builder) {
        this.domainInfo = builder.domainInfo;
        this.configuration = builder.configuration;
    }

    /**
     *
     * @return
     */
    public DomainInfo domainInfo() {
        return domainInfo;
    }

    /**
     *
     * @return
     */
    public DomainConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainInfo() == null) ? 0 : domainInfo().hashCode());
        hashCode = 31 * hashCode + ((configuration() == null) ? 0 : configuration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse) obj;
        if (other.domainInfo() == null ^ this.domainInfo() == null) {
            return false;
        }
        if (other.domainInfo() != null && !other.domainInfo().equals(this.domainInfo())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainInfo() != null) {
            sb.append("DomainInfo: ").append(domainInfo()).append(",");
        }
        if (configuration() != null) {
            sb.append("Configuration: ").append(configuration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDomainResponse> {
        /**
         *
         * @param domainInfo
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfo(DomainInfo domainInfo);

        /**
         *
         * @param configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DomainConfiguration configuration);
    }

    private static final class BuilderImpl implements Builder {
        private DomainInfo domainInfo;

        private DomainConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            setDomainInfo(model.domainInfo);
            setConfiguration(model.configuration);
        }

        public final DomainInfo getDomainInfo() {
            return domainInfo;
        }

        @Override
        public final Builder domainInfo(DomainInfo domainInfo) {
            this.domainInfo = domainInfo;
            return this;
        }

        public final void setDomainInfo(DomainInfo domainInfo) {
            this.domainInfo = domainInfo;
        }

        public final DomainConfiguration getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(DomainConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(DomainConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }
    }
}
