/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeWorkflowExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeWorkflowExecutionRequest.Builder, DescribeWorkflowExecutionRequest> {
    private final String domain;

    private final WorkflowExecution execution;

    private DescribeWorkflowExecutionRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.execution = builder.execution;
    }

    /**
     * <p>
     * The name of the domain containing the workflow execution.
     * </p>
     * 
     * @return The name of the domain containing the workflow execution.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The workflow execution to describe.
     * </p>
     * 
     * @return The workflow execution to describe.
     */
    public WorkflowExecution execution() {
        return execution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((execution() == null) ? 0 : execution().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowExecutionRequest)) {
            return false;
        }
        DescribeWorkflowExecutionRequest other = (DescribeWorkflowExecutionRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.execution() == null ^ this.execution() == null) {
            return false;
        }
        if (other.execution() != null && !other.execution().equals(this.execution())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (execution() != null) {
            sb.append("Execution: ").append(execution()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeWorkflowExecutionRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow execution.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The workflow execution to describe.
         * </p>
         * 
         * @param execution
         *        The workflow execution to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(WorkflowExecution execution);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private WorkflowExecution execution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowExecutionRequest model) {
            setDomain(model.domain);
            setExecution(model.execution);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final WorkflowExecution getExecution() {
            return execution;
        }

        @Override
        public final Builder execution(WorkflowExecution execution) {
            this.execution = execution;
            return this;
        }

        public final void setExecution(WorkflowExecution execution) {
            this.execution = execution;
        }

        @Override
        public DescribeWorkflowExecutionRequest build() {
            return new DescribeWorkflowExecutionRequest(this);
        }
    }
}
