/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeWorkflowExecutionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeWorkflowExecutionResponse.Builder, DescribeWorkflowExecutionResponse> {
    private final WorkflowExecutionInfo executionInfo;

    private final WorkflowExecutionConfiguration executionConfiguration;

    private final WorkflowExecutionOpenCounts openCounts;

    private final Date latestActivityTaskTimestamp;

    private final String latestExecutionContext;

    private DescribeWorkflowExecutionResponse(BuilderImpl builder) {
        this.executionInfo = builder.executionInfo;
        this.executionConfiguration = builder.executionConfiguration;
        this.openCounts = builder.openCounts;
        this.latestActivityTaskTimestamp = builder.latestActivityTaskTimestamp;
        this.latestExecutionContext = builder.latestExecutionContext;
    }

    /**
     * <p>
     * Information about the workflow execution.
     * </p>
     * 
     * @return Information about the workflow execution.
     */
    public WorkflowExecutionInfo executionInfo() {
        return executionInfo;
    }

    /**
     * <p>
     * The configuration settings for this workflow execution including timeout values, tasklist etc.
     * </p>
     * 
     * @return The configuration settings for this workflow execution including timeout values, tasklist etc.
     */
    public WorkflowExecutionConfiguration executionConfiguration() {
        return executionConfiguration;
    }

    /**
     * <p>
     * The number of tasks for this workflow execution. This includes open and closed tasks of all types.
     * </p>
     * 
     * @return The number of tasks for this workflow execution. This includes open and closed tasks of all types.
     */
    public WorkflowExecutionOpenCounts openCounts() {
        return openCounts;
    }

    /**
     * <p>
     * The time when the last activity task was scheduled for this workflow execution. You can use this information to
     * determine if the workflow has not made progress for an unusually long period of time and might require a
     * corrective action.
     * </p>
     * 
     * @return The time when the last activity task was scheduled for this workflow execution. You can use this
     *         information to determine if the workflow has not made progress for an unusually long period of time and
     *         might require a corrective action.
     */
    public Date latestActivityTaskTimestamp() {
        return latestActivityTaskTimestamp;
    }

    /**
     * <p>
     * The latest executionContext provided by the decider for this workflow execution. A decider can provide an
     * executionContext (a free-form string) when closing a decision task using <a>RespondDecisionTaskCompleted</a>.
     * </p>
     * 
     * @return The latest executionContext provided by the decider for this workflow execution. A decider can provide an
     *         executionContext (a free-form string) when closing a decision task using
     *         <a>RespondDecisionTaskCompleted</a>.
     */
    public String latestExecutionContext() {
        return latestExecutionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((executionInfo() == null) ? 0 : executionInfo().hashCode());
        hashCode = 31 * hashCode + ((executionConfiguration() == null) ? 0 : executionConfiguration().hashCode());
        hashCode = 31 * hashCode + ((openCounts() == null) ? 0 : openCounts().hashCode());
        hashCode = 31 * hashCode + ((latestActivityTaskTimestamp() == null) ? 0 : latestActivityTaskTimestamp().hashCode());
        hashCode = 31 * hashCode + ((latestExecutionContext() == null) ? 0 : latestExecutionContext().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowExecutionResponse)) {
            return false;
        }
        DescribeWorkflowExecutionResponse other = (DescribeWorkflowExecutionResponse) obj;
        if (other.executionInfo() == null ^ this.executionInfo() == null) {
            return false;
        }
        if (other.executionInfo() != null && !other.executionInfo().equals(this.executionInfo())) {
            return false;
        }
        if (other.executionConfiguration() == null ^ this.executionConfiguration() == null) {
            return false;
        }
        if (other.executionConfiguration() != null && !other.executionConfiguration().equals(this.executionConfiguration())) {
            return false;
        }
        if (other.openCounts() == null ^ this.openCounts() == null) {
            return false;
        }
        if (other.openCounts() != null && !other.openCounts().equals(this.openCounts())) {
            return false;
        }
        if (other.latestActivityTaskTimestamp() == null ^ this.latestActivityTaskTimestamp() == null) {
            return false;
        }
        if (other.latestActivityTaskTimestamp() != null
                && !other.latestActivityTaskTimestamp().equals(this.latestActivityTaskTimestamp())) {
            return false;
        }
        if (other.latestExecutionContext() == null ^ this.latestExecutionContext() == null) {
            return false;
        }
        if (other.latestExecutionContext() != null && !other.latestExecutionContext().equals(this.latestExecutionContext())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (executionInfo() != null) {
            sb.append("ExecutionInfo: ").append(executionInfo()).append(",");
        }
        if (executionConfiguration() != null) {
            sb.append("ExecutionConfiguration: ").append(executionConfiguration()).append(",");
        }
        if (openCounts() != null) {
            sb.append("OpenCounts: ").append(openCounts()).append(",");
        }
        if (latestActivityTaskTimestamp() != null) {
            sb.append("LatestActivityTaskTimestamp: ").append(latestActivityTaskTimestamp()).append(",");
        }
        if (latestExecutionContext() != null) {
            sb.append("LatestExecutionContext: ").append(latestExecutionContext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeWorkflowExecutionResponse> {
        /**
         * <p>
         * Information about the workflow execution.
         * </p>
         * 
         * @param executionInfo
         *        Information about the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfo(WorkflowExecutionInfo executionInfo);

        /**
         * <p>
         * The configuration settings for this workflow execution including timeout values, tasklist etc.
         * </p>
         * 
         * @param executionConfiguration
         *        The configuration settings for this workflow execution including timeout values, tasklist etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionConfiguration(WorkflowExecutionConfiguration executionConfiguration);

        /**
         * <p>
         * The number of tasks for this workflow execution. This includes open and closed tasks of all types.
         * </p>
         * 
         * @param openCounts
         *        The number of tasks for this workflow execution. This includes open and closed tasks of all types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openCounts(WorkflowExecutionOpenCounts openCounts);

        /**
         * <p>
         * The time when the last activity task was scheduled for this workflow execution. You can use this information
         * to determine if the workflow has not made progress for an unusually long period of time and might require a
         * corrective action.
         * </p>
         * 
         * @param latestActivityTaskTimestamp
         *        The time when the last activity task was scheduled for this workflow execution. You can use this
         *        information to determine if the workflow has not made progress for an unusually long period of time
         *        and might require a corrective action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestActivityTaskTimestamp(Date latestActivityTaskTimestamp);

        /**
         * <p>
         * The latest executionContext provided by the decider for this workflow execution. A decider can provide an
         * executionContext (a free-form string) when closing a decision task using <a>RespondDecisionTaskCompleted</a>.
         * </p>
         * 
         * @param latestExecutionContext
         *        The latest executionContext provided by the decider for this workflow execution. A decider can provide
         *        an executionContext (a free-form string) when closing a decision task using
         *        <a>RespondDecisionTaskCompleted</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecutionContext(String latestExecutionContext);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowExecutionInfo executionInfo;

        private WorkflowExecutionConfiguration executionConfiguration;

        private WorkflowExecutionOpenCounts openCounts;

        private Date latestActivityTaskTimestamp;

        private String latestExecutionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowExecutionResponse model) {
            setExecutionInfo(model.executionInfo);
            setExecutionConfiguration(model.executionConfiguration);
            setOpenCounts(model.openCounts);
            setLatestActivityTaskTimestamp(model.latestActivityTaskTimestamp);
            setLatestExecutionContext(model.latestExecutionContext);
        }

        public final WorkflowExecutionInfo getExecutionInfo() {
            return executionInfo;
        }

        @Override
        public final Builder executionInfo(WorkflowExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final void setExecutionInfo(WorkflowExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
        }

        public final WorkflowExecutionConfiguration getExecutionConfiguration() {
            return executionConfiguration;
        }

        @Override
        public final Builder executionConfiguration(WorkflowExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public final void setExecutionConfiguration(WorkflowExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
        }

        public final WorkflowExecutionOpenCounts getOpenCounts() {
            return openCounts;
        }

        @Override
        public final Builder openCounts(WorkflowExecutionOpenCounts openCounts) {
            this.openCounts = openCounts;
            return this;
        }

        public final void setOpenCounts(WorkflowExecutionOpenCounts openCounts) {
            this.openCounts = openCounts;
        }

        public final Date getLatestActivityTaskTimestamp() {
            return latestActivityTaskTimestamp;
        }

        @Override
        public final Builder latestActivityTaskTimestamp(Date latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = StandardMemberCopier.copy(latestActivityTaskTimestamp);
            return this;
        }

        public final void setLatestActivityTaskTimestamp(Date latestActivityTaskTimestamp) {
            this.latestActivityTaskTimestamp = StandardMemberCopier.copy(latestActivityTaskTimestamp);
        }

        public final String getLatestExecutionContext() {
            return latestExecutionContext;
        }

        @Override
        public final Builder latestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
            return this;
        }

        public final void setLatestExecutionContext(String latestExecutionContext) {
            this.latestExecutionContext = latestExecutionContext;
        }

        @Override
        public DescribeWorkflowExecutionResponse build() {
            return new DescribeWorkflowExecutionResponse(this);
        }
    }
}
