/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.transform.ExecutionTimeFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to filter the workflow executions in visibility APIs by various time-based rules. Each parameter, if specified,
 * defines a rule that must be satisfied by each returned query result. The parameter values are in the <a
 * href="https://en.wikipedia.org/wiki/Unix_time">Unix Time format</a>. For example:
 * <code>"oldestDate": 1325376070.</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExecutionTimeFilter implements StructuredPojo, ToCopyableBuilder<ExecutionTimeFilter.Builder, ExecutionTimeFilter> {
    private final Date oldestDate;

    private final Date latestDate;

    private ExecutionTimeFilter(BuilderImpl builder) {
        this.oldestDate = builder.oldestDate;
        this.latestDate = builder.latestDate;
    }

    /**
     * <p>
     * Specifies the oldest start or close date and time to return.
     * </p>
     * 
     * @return Specifies the oldest start or close date and time to return.
     */
    public Date oldestDate() {
        return oldestDate;
    }

    /**
     * <p>
     * Specifies the latest start or close date and time to return.
     * </p>
     * 
     * @return Specifies the latest start or close date and time to return.
     */
    public Date latestDate() {
        return latestDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((oldestDate() == null) ? 0 : oldestDate().hashCode());
        hashCode = 31 * hashCode + ((latestDate() == null) ? 0 : latestDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionTimeFilter)) {
            return false;
        }
        ExecutionTimeFilter other = (ExecutionTimeFilter) obj;
        if (other.oldestDate() == null ^ this.oldestDate() == null) {
            return false;
        }
        if (other.oldestDate() != null && !other.oldestDate().equals(this.oldestDate())) {
            return false;
        }
        if (other.latestDate() == null ^ this.latestDate() == null) {
            return false;
        }
        if (other.latestDate() != null && !other.latestDate().equals(this.latestDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (oldestDate() != null) {
            sb.append("OldestDate: ").append(oldestDate()).append(",");
        }
        if (latestDate() != null) {
            sb.append("LatestDate: ").append(latestDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionTimeFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ExecutionTimeFilter> {
        /**
         * <p>
         * Specifies the oldest start or close date and time to return.
         * </p>
         * 
         * @param oldestDate
         *        Specifies the oldest start or close date and time to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldestDate(Date oldestDate);

        /**
         * <p>
         * Specifies the latest start or close date and time to return.
         * </p>
         * 
         * @param latestDate
         *        Specifies the latest start or close date and time to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDate(Date latestDate);
    }

    private static final class BuilderImpl implements Builder {
        private Date oldestDate;

        private Date latestDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionTimeFilter model) {
            setOldestDate(model.oldestDate);
            setLatestDate(model.latestDate);
        }

        public final Date getOldestDate() {
            return oldestDate;
        }

        @Override
        public final Builder oldestDate(Date oldestDate) {
            this.oldestDate = StandardMemberCopier.copy(oldestDate);
            return this;
        }

        public final void setOldestDate(Date oldestDate) {
            this.oldestDate = StandardMemberCopier.copy(oldestDate);
        }

        public final Date getLatestDate() {
            return latestDate;
        }

        @Override
        public final Builder latestDate(Date latestDate) {
            this.latestDate = StandardMemberCopier.copy(latestDate);
            return this;
        }

        public final void setLatestDate(Date latestDate) {
            this.latestDate = StandardMemberCopier.copy(latestDate);
        }

        @Override
        public ExecutionTimeFilter build() {
            return new ExecutionTimeFilter(this);
        }
    }
}
