/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Paginated representation of a workflow history for a workflow execution. This is the up to date, complete and
 * authoritative record of the events related to all tasks and events in the life of the workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetWorkflowExecutionHistoryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetWorkflowExecutionHistoryResponse.Builder, GetWorkflowExecutionHistoryResponse> {
    private final List<HistoryEvent> events;

    private final String nextPageToken;

    private GetWorkflowExecutionHistoryResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The list of history events.
     * </p>
     * 
     * @return The list of history events.
     */
    public List<HistoryEvent> events() {
        return events;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowExecutionHistoryResponse)) {
            return false;
        }
        GetWorkflowExecutionHistoryResponse other = (GetWorkflowExecutionHistoryResponse) obj;
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetWorkflowExecutionHistoryResponse> {
        /**
         * <p>
         * The list of history events.
         * </p>
         * 
         * @param events
         *        The list of history events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<HistoryEvent> events);

        /**
         * <p>
         * The list of history events.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         *        The list of history events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(HistoryEvent... events);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<HistoryEvent> events;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowExecutionHistoryResponse model) {
            setEvents(model.events);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<HistoryEvent> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(HistoryEvent... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<HistoryEvent> events) {
            this.events = HistoryEventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(HistoryEvent... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (HistoryEvent e : events) {
                this.events.add(e);
            }
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetWorkflowExecutionHistoryResponse build() {
            return new GetWorkflowExecutionHistoryResponse(this);
        }
    }
}
