/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.swf.transform.HistoryEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Event within a workflow execution. A history event can be one of these types:
 * </p>
 * <ul>
 * <li><b>WorkflowExecutionStarted</b>: The workflow execution was started.</li>
 * <li><b>WorkflowExecutionCompleted</b>: The workflow execution was closed due to successful completion.</li>
 * <li><b>WorkflowExecutionFailed</b>: The workflow execution closed due to a failure.</li>
 * <li><b>WorkflowExecutionTimedOut</b>: The workflow execution was closed because a time out was exceeded.</li>
 * <li><b>WorkflowExecutionCanceled</b>: The workflow execution was successfully canceled and closed.</li>
 * <li><b>WorkflowExecutionTerminated</b>: The workflow execution was terminated.</li>
 * <li><b>WorkflowExecutionContinuedAsNew</b>: The workflow execution was closed and a new execution of the same type
 * was created with the same workflowId.</li>
 * <li><b>WorkflowExecutionCancelRequested</b>: A request to cancel this workflow execution was made.</li>
 * <li><b>DecisionTaskScheduled</b>: A decision task was scheduled for the workflow execution.</li>
 * <li><b>DecisionTaskStarted</b>: The decision task was dispatched to a decider.</li>
 * <li><b>DecisionTaskCompleted</b>: The decider successfully completed a decision task by calling
 * <a>RespondDecisionTaskCompleted</a>.</li>
 * <li><b>DecisionTaskTimedOut</b>: The decision task timed out.</li>
 * <li><b>ActivityTaskScheduled</b>: An activity task was scheduled for execution.</li>
 * <li><b>ScheduleActivityTaskFailed</b>: Failed to process ScheduleActivityTask decision. This happens when the
 * decision is not configured properly, for example the activity type specified is not registered.</li>
 * <li><b>ActivityTaskStarted</b>: The scheduled activity task was dispatched to a worker.</li>
 * <li><b>ActivityTaskCompleted</b>: An activity worker successfully completed an activity task by calling
 * <a>RespondActivityTaskCompleted</a>.</li>
 * <li><b>ActivityTaskFailed</b>: An activity worker failed an activity task by calling
 * <a>RespondActivityTaskFailed</a>.</li>
 * <li><b>ActivityTaskTimedOut</b>: The activity task timed out.</li>
 * <li><b>ActivityTaskCanceled</b>: The activity task was successfully canceled.</li>
 * <li><b>ActivityTaskCancelRequested</b>: A <code>RequestCancelActivityTask</code> decision was received by the system.
 * </li>
 * <li><b>RequestCancelActivityTaskFailed</b>: Failed to process RequestCancelActivityTask decision. This happens when
 * the decision is not configured properly.</li>
 * <li><b>WorkflowExecutionSignaled</b>: An external signal was received for the workflow execution.</li>
 * <li><b>MarkerRecorded</b>: A marker was recorded in the workflow history as the result of a <code>RecordMarker</code>
 * decision.</li>
 * <li><b>TimerStarted</b>: A timer was started for the workflow execution due to a <code>StartTimer</code> decision.</li>
 * <li><b>StartTimerFailed</b>: Failed to process StartTimer decision. This happens when the decision is not configured
 * properly, for example a timer already exists with the specified timer ID.</li>
 * <li><b>TimerFired</b>: A timer, previously started for this workflow execution, fired.</li>
 * <li><b>TimerCanceled</b>: A timer, previously started for this workflow execution, was successfully canceled.</li>
 * <li><b>CancelTimerFailed</b>: Failed to process CancelTimer decision. This happens when the decision is not
 * configured properly, for example no timer exists with the specified timer ID.</li>
 * <li><b>StartChildWorkflowExecutionInitiated</b>: A request was made to start a child workflow execution.</li>
 * <li><b>StartChildWorkflowExecutionFailed</b>: Failed to process StartChildWorkflowExecution decision. This happens
 * when the decision is not configured properly, for example the workflow type specified is not registered.</li>
 * <li><b>ChildWorkflowExecutionStarted</b>: A child workflow execution was successfully started.</li>
 * <li><b>ChildWorkflowExecutionCompleted</b>: A child workflow execution, started by this workflow execution, completed
 * successfully and was closed.</li>
 * <li><b>ChildWorkflowExecutionFailed</b>: A child workflow execution, started by this workflow execution, failed to
 * complete successfully and was closed.</li>
 * <li><b>ChildWorkflowExecutionTimedOut</b>: A child workflow execution, started by this workflow execution, timed out
 * and was closed.</li>
 * <li><b>ChildWorkflowExecutionCanceled</b>: A child workflow execution, started by this workflow execution, was
 * canceled and closed.</li>
 * <li><b>ChildWorkflowExecutionTerminated</b>: A child workflow execution, started by this workflow execution, was
 * terminated.</li>
 * <li><b>SignalExternalWorkflowExecutionInitiated</b>: A request to signal an external workflow was made.</li>
 * <li><b>ExternalWorkflowExecutionSignaled</b>: A signal, requested by this workflow execution, was successfully
 * delivered to the target external workflow execution.</li>
 * <li><b>SignalExternalWorkflowExecutionFailed</b>: The request to signal an external workflow execution failed.</li>
 * <li><b>RequestCancelExternalWorkflowExecutionInitiated</b>: A request was made to request the cancellation of an
 * external workflow execution.</li>
 * <li><b>ExternalWorkflowExecutionCancelRequested</b>: Request to cancel an external workflow execution was
 * successfully delivered to the target execution.</li>
 * <li><b>RequestCancelExternalWorkflowExecutionFailed</b>: Request to cancel an external workflow execution failed.</li>
 * <li><b>LambdaFunctionScheduled</b>: An AWS Lambda function was scheduled for execution.</li>
 * <li><b>LambdaFunctionStarted</b>: The scheduled function was invoked in the AWS Lambda service.</li>
 * <li><b>LambdaFunctionCompleted</b>: The AWS Lambda function successfully completed.</li>
 * <li><b>LambdaFunctionFailed</b>: The AWS Lambda function execution failed.</li>
 * <li><b>LambdaFunctionTimedOut</b>: The AWS Lambda function execution timed out.</li>
 * <li><b>ScheduleLambdaFunctionFailed</b>: Failed to process ScheduleLambdaFunction decision. This happens when the
 * workflow execution does not have the proper IAM role attached to invoke AWS Lambda functions.</li>
 * <li><b>StartLambdaFunctionFailed</b>: Failed to invoke the scheduled function in the AWS Lambda service. This happens
 * when the AWS Lambda service is not available in the current region, or received too many requests.</li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class HistoryEvent implements StructuredPojo, ToCopyableBuilder<HistoryEvent.Builder, HistoryEvent> {
    private final Date eventTimestamp;

    private final String eventType;

    private final Long eventId;

    private final WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes;

    private final WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes;

    private final CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes;

    private final FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes;

    private final WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes;

    private final CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes;

    private final ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes;

    private final WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes;

    private final WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes;

    private final DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes;

    private final DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes;

    private final DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes;

    private final DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes;

    private final ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes;

    private final ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes;

    private final ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes;

    private final ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes;

    private final ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes;

    private final ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes;

    private final ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes;

    private final WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes;

    private final MarkerRecordedEventAttributes markerRecordedEventAttributes;

    private final RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes;

    private final TimerStartedEventAttributes timerStartedEventAttributes;

    private final TimerFiredEventAttributes timerFiredEventAttributes;

    private final TimerCanceledEventAttributes timerCanceledEventAttributes;

    private final StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes;

    private final ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes;

    private final ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes;

    private final ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes;

    private final ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes;

    private final ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes;

    private final ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes;

    private final SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes;

    private final ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes;

    private final SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes;

    private final ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes;

    private final RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes;

    private final RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes;

    private final ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes;

    private final RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes;

    private final StartTimerFailedEventAttributes startTimerFailedEventAttributes;

    private final CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes;

    private final StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes;

    private final LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes;

    private final LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes;

    private final LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes;

    private final LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes;

    private final LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes;

    private final ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes;

    private final StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes;

    private HistoryEvent(BuilderImpl builder) {
        this.eventTimestamp = builder.eventTimestamp;
        this.eventType = builder.eventType;
        this.eventId = builder.eventId;
        this.workflowExecutionStartedEventAttributes = builder.workflowExecutionStartedEventAttributes;
        this.workflowExecutionCompletedEventAttributes = builder.workflowExecutionCompletedEventAttributes;
        this.completeWorkflowExecutionFailedEventAttributes = builder.completeWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionFailedEventAttributes = builder.workflowExecutionFailedEventAttributes;
        this.failWorkflowExecutionFailedEventAttributes = builder.failWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionTimedOutEventAttributes = builder.workflowExecutionTimedOutEventAttributes;
        this.workflowExecutionCanceledEventAttributes = builder.workflowExecutionCanceledEventAttributes;
        this.cancelWorkflowExecutionFailedEventAttributes = builder.cancelWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionContinuedAsNewEventAttributes = builder.workflowExecutionContinuedAsNewEventAttributes;
        this.continueAsNewWorkflowExecutionFailedEventAttributes = builder.continueAsNewWorkflowExecutionFailedEventAttributes;
        this.workflowExecutionTerminatedEventAttributes = builder.workflowExecutionTerminatedEventAttributes;
        this.workflowExecutionCancelRequestedEventAttributes = builder.workflowExecutionCancelRequestedEventAttributes;
        this.decisionTaskScheduledEventAttributes = builder.decisionTaskScheduledEventAttributes;
        this.decisionTaskStartedEventAttributes = builder.decisionTaskStartedEventAttributes;
        this.decisionTaskCompletedEventAttributes = builder.decisionTaskCompletedEventAttributes;
        this.decisionTaskTimedOutEventAttributes = builder.decisionTaskTimedOutEventAttributes;
        this.activityTaskScheduledEventAttributes = builder.activityTaskScheduledEventAttributes;
        this.activityTaskStartedEventAttributes = builder.activityTaskStartedEventAttributes;
        this.activityTaskCompletedEventAttributes = builder.activityTaskCompletedEventAttributes;
        this.activityTaskFailedEventAttributes = builder.activityTaskFailedEventAttributes;
        this.activityTaskTimedOutEventAttributes = builder.activityTaskTimedOutEventAttributes;
        this.activityTaskCanceledEventAttributes = builder.activityTaskCanceledEventAttributes;
        this.activityTaskCancelRequestedEventAttributes = builder.activityTaskCancelRequestedEventAttributes;
        this.workflowExecutionSignaledEventAttributes = builder.workflowExecutionSignaledEventAttributes;
        this.markerRecordedEventAttributes = builder.markerRecordedEventAttributes;
        this.recordMarkerFailedEventAttributes = builder.recordMarkerFailedEventAttributes;
        this.timerStartedEventAttributes = builder.timerStartedEventAttributes;
        this.timerFiredEventAttributes = builder.timerFiredEventAttributes;
        this.timerCanceledEventAttributes = builder.timerCanceledEventAttributes;
        this.startChildWorkflowExecutionInitiatedEventAttributes = builder.startChildWorkflowExecutionInitiatedEventAttributes;
        this.childWorkflowExecutionStartedEventAttributes = builder.childWorkflowExecutionStartedEventAttributes;
        this.childWorkflowExecutionCompletedEventAttributes = builder.childWorkflowExecutionCompletedEventAttributes;
        this.childWorkflowExecutionFailedEventAttributes = builder.childWorkflowExecutionFailedEventAttributes;
        this.childWorkflowExecutionTimedOutEventAttributes = builder.childWorkflowExecutionTimedOutEventAttributes;
        this.childWorkflowExecutionCanceledEventAttributes = builder.childWorkflowExecutionCanceledEventAttributes;
        this.childWorkflowExecutionTerminatedEventAttributes = builder.childWorkflowExecutionTerminatedEventAttributes;
        this.signalExternalWorkflowExecutionInitiatedEventAttributes = builder.signalExternalWorkflowExecutionInitiatedEventAttributes;
        this.externalWorkflowExecutionSignaledEventAttributes = builder.externalWorkflowExecutionSignaledEventAttributes;
        this.signalExternalWorkflowExecutionFailedEventAttributes = builder.signalExternalWorkflowExecutionFailedEventAttributes;
        this.externalWorkflowExecutionCancelRequestedEventAttributes = builder.externalWorkflowExecutionCancelRequestedEventAttributes;
        this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = builder.requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
        this.requestCancelExternalWorkflowExecutionFailedEventAttributes = builder.requestCancelExternalWorkflowExecutionFailedEventAttributes;
        this.scheduleActivityTaskFailedEventAttributes = builder.scheduleActivityTaskFailedEventAttributes;
        this.requestCancelActivityTaskFailedEventAttributes = builder.requestCancelActivityTaskFailedEventAttributes;
        this.startTimerFailedEventAttributes = builder.startTimerFailedEventAttributes;
        this.cancelTimerFailedEventAttributes = builder.cancelTimerFailedEventAttributes;
        this.startChildWorkflowExecutionFailedEventAttributes = builder.startChildWorkflowExecutionFailedEventAttributes;
        this.lambdaFunctionScheduledEventAttributes = builder.lambdaFunctionScheduledEventAttributes;
        this.lambdaFunctionStartedEventAttributes = builder.lambdaFunctionStartedEventAttributes;
        this.lambdaFunctionCompletedEventAttributes = builder.lambdaFunctionCompletedEventAttributes;
        this.lambdaFunctionFailedEventAttributes = builder.lambdaFunctionFailedEventAttributes;
        this.lambdaFunctionTimedOutEventAttributes = builder.lambdaFunctionTimedOutEventAttributes;
        this.scheduleLambdaFunctionFailedEventAttributes = builder.scheduleLambdaFunctionFailedEventAttributes;
        this.startLambdaFunctionFailedEventAttributes = builder.startLambdaFunctionFailedEventAttributes;
    }

    /**
     * <p>
     * The date and time when the event occurred.
     * </p>
     * 
     * @return The date and time when the event occurred.
     */
    public Date eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The type of the history event.
     * </p>
     * 
     * @return The type of the history event.
     * @see EventType
     */
    public String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution
     * history.
     * </p>
     * 
     * @return The system generated ID of the event. This ID uniquely identifies the event with in the workflow
     *         execution history.
     */
    public Long eventId() {
        return eventId;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes() {
        return workflowExecutionStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes() {
        return workflowExecutionCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes() {
        return completeWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes() {
        return workflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes() {
        return failWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes() {
        return workflowExecutionTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes() {
        return workflowExecutionCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes() {
        return cancelWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes() {
        return workflowExecutionContinuedAsNewEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes() {
        return continueAsNewWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes() {
        return workflowExecutionTerminatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes() {
        return workflowExecutionCancelRequestedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes() {
        return decisionTaskScheduledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes() {
        return decisionTaskStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes() {
        return decisionTaskCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes() {
        return decisionTaskTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes() {
        return activityTaskScheduledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes() {
        return activityTaskStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes() {
        return activityTaskCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed information
     * about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes() {
        return activityTaskFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes() {
        return activityTaskTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes() {
        return activityTaskCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes() {
        return activityTaskCancelRequestedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes() {
        return workflowExecutionSignaledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
     * about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public MarkerRecordedEventAttributes markerRecordedEventAttributes() {
        return markerRecordedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed information
     * about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes() {
        return recordMarkerFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information about
     * the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>TimerStarted</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public TimerStartedEventAttributes timerStartedEventAttributes() {
        return timerStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>TimerFired</code> then this member is set and provides detailed information about
     * the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>TimerFired</code> then this member is set and provides detailed information
     *         about the event. It is not set for other event types.
     */
    public TimerFiredEventAttributes timerFiredEventAttributes() {
        return timerFiredEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
     * about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public TimerCanceledEventAttributes timerCanceledEventAttributes() {
        return timerCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes() {
        return startChildWorkflowExecutionInitiatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes() {
        return childWorkflowExecutionStartedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes() {
        return childWorkflowExecutionCompletedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes() {
        return childWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes() {
        return childWorkflowExecutionTimedOutEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes() {
        return childWorkflowExecutionCanceledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes() {
        return childWorkflowExecutionTerminatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
     * provides detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes() {
        return signalExternalWorkflowExecutionInitiatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes() {
        return externalWorkflowExecutionSignaledEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes() {
        return signalExternalWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
     * provides detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes() {
        return externalWorkflowExecutionCancelRequestedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set and
     * provides detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is
     *         set and provides detailed information about the event. It is not set for other event types.
     */
    public RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes() {
        return requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
     * provides detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set
     *         and provides detailed information about the event. It is not set for other event types.
     */
    public RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes() {
        return requestCancelExternalWorkflowExecutionFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
     * information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes() {
        return scheduleActivityTaskFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
     *         detailed information about the event. It is not set for other event types.
     */
    public RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes() {
        return requestCancelActivityTaskFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed information
     * about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public StartTimerFailedEventAttributes startTimerFailedEventAttributes() {
        return startTimerFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed information
     * about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed
     *         information about the event. It is not set for other event types.
     */
    public CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes() {
        return cancelTimerFailedEventAttributes;
    }

    /**
     * <p>
     * If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
     * detailed information about the event. It is not set for other event types.
     * </p>
     * 
     * @return If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and
     *         provides detailed information about the event. It is not set for other event types.
     */
    public StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes() {
        return startChildWorkflowExecutionFailedEventAttributes;
    }

    /**
     *
     * @return
     */
    public LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes() {
        return lambdaFunctionScheduledEventAttributes;
    }

    /**
     *
     * @return
     */
    public LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes() {
        return lambdaFunctionStartedEventAttributes;
    }

    /**
     *
     * @return
     */
    public LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes() {
        return lambdaFunctionCompletedEventAttributes;
    }

    /**
     *
     * @return
     */
    public LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes() {
        return lambdaFunctionFailedEventAttributes;
    }

    /**
     *
     * @return
     */
    public LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes() {
        return lambdaFunctionTimedOutEventAttributes;
    }

    /**
     *
     * @return
     */
    public ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes() {
        return scheduleLambdaFunctionFailedEventAttributes;
    }

    /**
     *
     * @return
     */
    public StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes() {
        return startLambdaFunctionFailedEventAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((eventTimestamp() == null) ? 0 : eventTimestamp().hashCode());
        hashCode = 31 * hashCode + ((eventType() == null) ? 0 : eventType().hashCode());
        hashCode = 31 * hashCode + ((eventId() == null) ? 0 : eventId().hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionStartedEventAttributes() == null) ? 0 : workflowExecutionStartedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionCompletedEventAttributes() == null) ? 0 : workflowExecutionCompletedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((completeWorkflowExecutionFailedEventAttributes() == null) ? 0
                        : completeWorkflowExecutionFailedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((workflowExecutionFailedEventAttributes() == null) ? 0 : workflowExecutionFailedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((failWorkflowExecutionFailedEventAttributes() == null) ? 0 : failWorkflowExecutionFailedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionTimedOutEventAttributes() == null) ? 0 : workflowExecutionTimedOutEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionCanceledEventAttributes() == null) ? 0 : workflowExecutionCanceledEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((cancelWorkflowExecutionFailedEventAttributes() == null) ? 0 : cancelWorkflowExecutionFailedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionContinuedAsNewEventAttributes() == null) ? 0
                        : workflowExecutionContinuedAsNewEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((continueAsNewWorkflowExecutionFailedEventAttributes() == null) ? 0
                        : continueAsNewWorkflowExecutionFailedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionTerminatedEventAttributes() == null) ? 0 : workflowExecutionTerminatedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionCancelRequestedEventAttributes() == null) ? 0
                        : workflowExecutionCancelRequestedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((decisionTaskScheduledEventAttributes() == null) ? 0 : decisionTaskScheduledEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((decisionTaskStartedEventAttributes() == null) ? 0 : decisionTaskStartedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((decisionTaskCompletedEventAttributes() == null) ? 0 : decisionTaskCompletedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((decisionTaskTimedOutEventAttributes() == null) ? 0 : decisionTaskTimedOutEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((activityTaskScheduledEventAttributes() == null) ? 0 : activityTaskScheduledEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((activityTaskStartedEventAttributes() == null) ? 0 : activityTaskStartedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((activityTaskCompletedEventAttributes() == null) ? 0 : activityTaskCompletedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((activityTaskFailedEventAttributes() == null) ? 0 : activityTaskFailedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((activityTaskTimedOutEventAttributes() == null) ? 0 : activityTaskTimedOutEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((activityTaskCanceledEventAttributes() == null) ? 0 : activityTaskCanceledEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((activityTaskCancelRequestedEventAttributes() == null) ? 0 : activityTaskCancelRequestedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((workflowExecutionSignaledEventAttributes() == null) ? 0 : workflowExecutionSignaledEventAttributes()
                        .hashCode());
        hashCode = 31 * hashCode + ((markerRecordedEventAttributes() == null) ? 0 : markerRecordedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((recordMarkerFailedEventAttributes() == null) ? 0 : recordMarkerFailedEventAttributes().hashCode());
        hashCode = 31 * hashCode + ((timerStartedEventAttributes() == null) ? 0 : timerStartedEventAttributes().hashCode());
        hashCode = 31 * hashCode + ((timerFiredEventAttributes() == null) ? 0 : timerFiredEventAttributes().hashCode());
        hashCode = 31 * hashCode + ((timerCanceledEventAttributes() == null) ? 0 : timerCanceledEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((startChildWorkflowExecutionInitiatedEventAttributes() == null) ? 0
                        : startChildWorkflowExecutionInitiatedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((childWorkflowExecutionStartedEventAttributes() == null) ? 0 : childWorkflowExecutionStartedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((childWorkflowExecutionCompletedEventAttributes() == null) ? 0
                        : childWorkflowExecutionCompletedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((childWorkflowExecutionFailedEventAttributes() == null) ? 0 : childWorkflowExecutionFailedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((childWorkflowExecutionTimedOutEventAttributes() == null) ? 0
                        : childWorkflowExecutionTimedOutEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((childWorkflowExecutionCanceledEventAttributes() == null) ? 0
                        : childWorkflowExecutionCanceledEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((childWorkflowExecutionTerminatedEventAttributes() == null) ? 0
                        : childWorkflowExecutionTerminatedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((signalExternalWorkflowExecutionInitiatedEventAttributes() == null) ? 0
                        : signalExternalWorkflowExecutionInitiatedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((externalWorkflowExecutionSignaledEventAttributes() == null) ? 0
                        : externalWorkflowExecutionSignaledEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((signalExternalWorkflowExecutionFailedEventAttributes() == null) ? 0
                        : signalExternalWorkflowExecutionFailedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((externalWorkflowExecutionCancelRequestedEventAttributes() == null) ? 0
                        : externalWorkflowExecutionCancelRequestedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((requestCancelExternalWorkflowExecutionInitiatedEventAttributes() == null) ? 0
                        : requestCancelExternalWorkflowExecutionInitiatedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((requestCancelExternalWorkflowExecutionFailedEventAttributes() == null) ? 0
                        : requestCancelExternalWorkflowExecutionFailedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((scheduleActivityTaskFailedEventAttributes() == null) ? 0 : scheduleActivityTaskFailedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((requestCancelActivityTaskFailedEventAttributes() == null) ? 0
                        : requestCancelActivityTaskFailedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((startTimerFailedEventAttributes() == null) ? 0 : startTimerFailedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((cancelTimerFailedEventAttributes() == null) ? 0 : cancelTimerFailedEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((startChildWorkflowExecutionFailedEventAttributes() == null) ? 0
                        : startChildWorkflowExecutionFailedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((lambdaFunctionScheduledEventAttributes() == null) ? 0 : lambdaFunctionScheduledEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((lambdaFunctionStartedEventAttributes() == null) ? 0 : lambdaFunctionStartedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((lambdaFunctionCompletedEventAttributes() == null) ? 0 : lambdaFunctionCompletedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((lambdaFunctionFailedEventAttributes() == null) ? 0 : lambdaFunctionFailedEventAttributes().hashCode());
        hashCode = 31 * hashCode
                + ((lambdaFunctionTimedOutEventAttributes() == null) ? 0 : lambdaFunctionTimedOutEventAttributes().hashCode());
        hashCode = 31
                * hashCode
                + ((scheduleLambdaFunctionFailedEventAttributes() == null) ? 0 : scheduleLambdaFunctionFailedEventAttributes()
                        .hashCode());
        hashCode = 31
                * hashCode
                + ((startLambdaFunctionFailedEventAttributes() == null) ? 0 : startLambdaFunctionFailedEventAttributes()
                        .hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryEvent)) {
            return false;
        }
        HistoryEvent other = (HistoryEvent) obj;
        if (other.eventTimestamp() == null ^ this.eventTimestamp() == null) {
            return false;
        }
        if (other.eventTimestamp() != null && !other.eventTimestamp().equals(this.eventTimestamp())) {
            return false;
        }
        if (other.eventType() == null ^ this.eventType() == null) {
            return false;
        }
        if (other.eventType() != null && !other.eventType().equals(this.eventType())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.workflowExecutionStartedEventAttributes() == null ^ this.workflowExecutionStartedEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionStartedEventAttributes() != null
                && !other.workflowExecutionStartedEventAttributes().equals(this.workflowExecutionStartedEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionCompletedEventAttributes() == null ^ this.workflowExecutionCompletedEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionCompletedEventAttributes() != null
                && !other.workflowExecutionCompletedEventAttributes().equals(this.workflowExecutionCompletedEventAttributes())) {
            return false;
        }
        if (other.completeWorkflowExecutionFailedEventAttributes() == null
                ^ this.completeWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.completeWorkflowExecutionFailedEventAttributes() != null
                && !other.completeWorkflowExecutionFailedEventAttributes().equals(
                        this.completeWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionFailedEventAttributes() == null ^ this.workflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionFailedEventAttributes() != null
                && !other.workflowExecutionFailedEventAttributes().equals(this.workflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.failWorkflowExecutionFailedEventAttributes() == null
                ^ this.failWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.failWorkflowExecutionFailedEventAttributes() != null
                && !other.failWorkflowExecutionFailedEventAttributes().equals(this.failWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionTimedOutEventAttributes() == null ^ this.workflowExecutionTimedOutEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionTimedOutEventAttributes() != null
                && !other.workflowExecutionTimedOutEventAttributes().equals(this.workflowExecutionTimedOutEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionCanceledEventAttributes() == null ^ this.workflowExecutionCanceledEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionCanceledEventAttributes() != null
                && !other.workflowExecutionCanceledEventAttributes().equals(this.workflowExecutionCanceledEventAttributes())) {
            return false;
        }
        if (other.cancelWorkflowExecutionFailedEventAttributes() == null
                ^ this.cancelWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.cancelWorkflowExecutionFailedEventAttributes() != null
                && !other.cancelWorkflowExecutionFailedEventAttributes().equals(
                        this.cancelWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionContinuedAsNewEventAttributes() == null
                ^ this.workflowExecutionContinuedAsNewEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionContinuedAsNewEventAttributes() != null
                && !other.workflowExecutionContinuedAsNewEventAttributes().equals(
                        this.workflowExecutionContinuedAsNewEventAttributes())) {
            return false;
        }
        if (other.continueAsNewWorkflowExecutionFailedEventAttributes() == null
                ^ this.continueAsNewWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.continueAsNewWorkflowExecutionFailedEventAttributes() != null
                && !other.continueAsNewWorkflowExecutionFailedEventAttributes().equals(
                        this.continueAsNewWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionTerminatedEventAttributes() == null
                ^ this.workflowExecutionTerminatedEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionTerminatedEventAttributes() != null
                && !other.workflowExecutionTerminatedEventAttributes().equals(this.workflowExecutionTerminatedEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionCancelRequestedEventAttributes() == null
                ^ this.workflowExecutionCancelRequestedEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionCancelRequestedEventAttributes() != null
                && !other.workflowExecutionCancelRequestedEventAttributes().equals(
                        this.workflowExecutionCancelRequestedEventAttributes())) {
            return false;
        }
        if (other.decisionTaskScheduledEventAttributes() == null ^ this.decisionTaskScheduledEventAttributes() == null) {
            return false;
        }
        if (other.decisionTaskScheduledEventAttributes() != null
                && !other.decisionTaskScheduledEventAttributes().equals(this.decisionTaskScheduledEventAttributes())) {
            return false;
        }
        if (other.decisionTaskStartedEventAttributes() == null ^ this.decisionTaskStartedEventAttributes() == null) {
            return false;
        }
        if (other.decisionTaskStartedEventAttributes() != null
                && !other.decisionTaskStartedEventAttributes().equals(this.decisionTaskStartedEventAttributes())) {
            return false;
        }
        if (other.decisionTaskCompletedEventAttributes() == null ^ this.decisionTaskCompletedEventAttributes() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventAttributes() != null
                && !other.decisionTaskCompletedEventAttributes().equals(this.decisionTaskCompletedEventAttributes())) {
            return false;
        }
        if (other.decisionTaskTimedOutEventAttributes() == null ^ this.decisionTaskTimedOutEventAttributes() == null) {
            return false;
        }
        if (other.decisionTaskTimedOutEventAttributes() != null
                && !other.decisionTaskTimedOutEventAttributes().equals(this.decisionTaskTimedOutEventAttributes())) {
            return false;
        }
        if (other.activityTaskScheduledEventAttributes() == null ^ this.activityTaskScheduledEventAttributes() == null) {
            return false;
        }
        if (other.activityTaskScheduledEventAttributes() != null
                && !other.activityTaskScheduledEventAttributes().equals(this.activityTaskScheduledEventAttributes())) {
            return false;
        }
        if (other.activityTaskStartedEventAttributes() == null ^ this.activityTaskStartedEventAttributes() == null) {
            return false;
        }
        if (other.activityTaskStartedEventAttributes() != null
                && !other.activityTaskStartedEventAttributes().equals(this.activityTaskStartedEventAttributes())) {
            return false;
        }
        if (other.activityTaskCompletedEventAttributes() == null ^ this.activityTaskCompletedEventAttributes() == null) {
            return false;
        }
        if (other.activityTaskCompletedEventAttributes() != null
                && !other.activityTaskCompletedEventAttributes().equals(this.activityTaskCompletedEventAttributes())) {
            return false;
        }
        if (other.activityTaskFailedEventAttributes() == null ^ this.activityTaskFailedEventAttributes() == null) {
            return false;
        }
        if (other.activityTaskFailedEventAttributes() != null
                && !other.activityTaskFailedEventAttributes().equals(this.activityTaskFailedEventAttributes())) {
            return false;
        }
        if (other.activityTaskTimedOutEventAttributes() == null ^ this.activityTaskTimedOutEventAttributes() == null) {
            return false;
        }
        if (other.activityTaskTimedOutEventAttributes() != null
                && !other.activityTaskTimedOutEventAttributes().equals(this.activityTaskTimedOutEventAttributes())) {
            return false;
        }
        if (other.activityTaskCanceledEventAttributes() == null ^ this.activityTaskCanceledEventAttributes() == null) {
            return false;
        }
        if (other.activityTaskCanceledEventAttributes() != null
                && !other.activityTaskCanceledEventAttributes().equals(this.activityTaskCanceledEventAttributes())) {
            return false;
        }
        if (other.activityTaskCancelRequestedEventAttributes() == null
                ^ this.activityTaskCancelRequestedEventAttributes() == null) {
            return false;
        }
        if (other.activityTaskCancelRequestedEventAttributes() != null
                && !other.activityTaskCancelRequestedEventAttributes().equals(this.activityTaskCancelRequestedEventAttributes())) {
            return false;
        }
        if (other.workflowExecutionSignaledEventAttributes() == null ^ this.workflowExecutionSignaledEventAttributes() == null) {
            return false;
        }
        if (other.workflowExecutionSignaledEventAttributes() != null
                && !other.workflowExecutionSignaledEventAttributes().equals(this.workflowExecutionSignaledEventAttributes())) {
            return false;
        }
        if (other.markerRecordedEventAttributes() == null ^ this.markerRecordedEventAttributes() == null) {
            return false;
        }
        if (other.markerRecordedEventAttributes() != null
                && !other.markerRecordedEventAttributes().equals(this.markerRecordedEventAttributes())) {
            return false;
        }
        if (other.recordMarkerFailedEventAttributes() == null ^ this.recordMarkerFailedEventAttributes() == null) {
            return false;
        }
        if (other.recordMarkerFailedEventAttributes() != null
                && !other.recordMarkerFailedEventAttributes().equals(this.recordMarkerFailedEventAttributes())) {
            return false;
        }
        if (other.timerStartedEventAttributes() == null ^ this.timerStartedEventAttributes() == null) {
            return false;
        }
        if (other.timerStartedEventAttributes() != null
                && !other.timerStartedEventAttributes().equals(this.timerStartedEventAttributes())) {
            return false;
        }
        if (other.timerFiredEventAttributes() == null ^ this.timerFiredEventAttributes() == null) {
            return false;
        }
        if (other.timerFiredEventAttributes() != null
                && !other.timerFiredEventAttributes().equals(this.timerFiredEventAttributes())) {
            return false;
        }
        if (other.timerCanceledEventAttributes() == null ^ this.timerCanceledEventAttributes() == null) {
            return false;
        }
        if (other.timerCanceledEventAttributes() != null
                && !other.timerCanceledEventAttributes().equals(this.timerCanceledEventAttributes())) {
            return false;
        }
        if (other.startChildWorkflowExecutionInitiatedEventAttributes() == null
                ^ this.startChildWorkflowExecutionInitiatedEventAttributes() == null) {
            return false;
        }
        if (other.startChildWorkflowExecutionInitiatedEventAttributes() != null
                && !other.startChildWorkflowExecutionInitiatedEventAttributes().equals(
                        this.startChildWorkflowExecutionInitiatedEventAttributes())) {
            return false;
        }
        if (other.childWorkflowExecutionStartedEventAttributes() == null
                ^ this.childWorkflowExecutionStartedEventAttributes() == null) {
            return false;
        }
        if (other.childWorkflowExecutionStartedEventAttributes() != null
                && !other.childWorkflowExecutionStartedEventAttributes().equals(
                        this.childWorkflowExecutionStartedEventAttributes())) {
            return false;
        }
        if (other.childWorkflowExecutionCompletedEventAttributes() == null
                ^ this.childWorkflowExecutionCompletedEventAttributes() == null) {
            return false;
        }
        if (other.childWorkflowExecutionCompletedEventAttributes() != null
                && !other.childWorkflowExecutionCompletedEventAttributes().equals(
                        this.childWorkflowExecutionCompletedEventAttributes())) {
            return false;
        }
        if (other.childWorkflowExecutionFailedEventAttributes() == null
                ^ this.childWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.childWorkflowExecutionFailedEventAttributes() != null
                && !other.childWorkflowExecutionFailedEventAttributes()
                        .equals(this.childWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.childWorkflowExecutionTimedOutEventAttributes() == null
                ^ this.childWorkflowExecutionTimedOutEventAttributes() == null) {
            return false;
        }
        if (other.childWorkflowExecutionTimedOutEventAttributes() != null
                && !other.childWorkflowExecutionTimedOutEventAttributes().equals(
                        this.childWorkflowExecutionTimedOutEventAttributes())) {
            return false;
        }
        if (other.childWorkflowExecutionCanceledEventAttributes() == null
                ^ this.childWorkflowExecutionCanceledEventAttributes() == null) {
            return false;
        }
        if (other.childWorkflowExecutionCanceledEventAttributes() != null
                && !other.childWorkflowExecutionCanceledEventAttributes().equals(
                        this.childWorkflowExecutionCanceledEventAttributes())) {
            return false;
        }
        if (other.childWorkflowExecutionTerminatedEventAttributes() == null
                ^ this.childWorkflowExecutionTerminatedEventAttributes() == null) {
            return false;
        }
        if (other.childWorkflowExecutionTerminatedEventAttributes() != null
                && !other.childWorkflowExecutionTerminatedEventAttributes().equals(
                        this.childWorkflowExecutionTerminatedEventAttributes())) {
            return false;
        }
        if (other.signalExternalWorkflowExecutionInitiatedEventAttributes() == null
                ^ this.signalExternalWorkflowExecutionInitiatedEventAttributes() == null) {
            return false;
        }
        if (other.signalExternalWorkflowExecutionInitiatedEventAttributes() != null
                && !other.signalExternalWorkflowExecutionInitiatedEventAttributes().equals(
                        this.signalExternalWorkflowExecutionInitiatedEventAttributes())) {
            return false;
        }
        if (other.externalWorkflowExecutionSignaledEventAttributes() == null
                ^ this.externalWorkflowExecutionSignaledEventAttributes() == null) {
            return false;
        }
        if (other.externalWorkflowExecutionSignaledEventAttributes() != null
                && !other.externalWorkflowExecutionSignaledEventAttributes().equals(
                        this.externalWorkflowExecutionSignaledEventAttributes())) {
            return false;
        }
        if (other.signalExternalWorkflowExecutionFailedEventAttributes() == null
                ^ this.signalExternalWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.signalExternalWorkflowExecutionFailedEventAttributes() != null
                && !other.signalExternalWorkflowExecutionFailedEventAttributes().equals(
                        this.signalExternalWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.externalWorkflowExecutionCancelRequestedEventAttributes() == null
                ^ this.externalWorkflowExecutionCancelRequestedEventAttributes() == null) {
            return false;
        }
        if (other.externalWorkflowExecutionCancelRequestedEventAttributes() != null
                && !other.externalWorkflowExecutionCancelRequestedEventAttributes().equals(
                        this.externalWorkflowExecutionCancelRequestedEventAttributes())) {
            return false;
        }
        if (other.requestCancelExternalWorkflowExecutionInitiatedEventAttributes() == null
                ^ this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes() == null) {
            return false;
        }
        if (other.requestCancelExternalWorkflowExecutionInitiatedEventAttributes() != null
                && !other.requestCancelExternalWorkflowExecutionInitiatedEventAttributes().equals(
                        this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes())) {
            return false;
        }
        if (other.requestCancelExternalWorkflowExecutionFailedEventAttributes() == null
                ^ this.requestCancelExternalWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.requestCancelExternalWorkflowExecutionFailedEventAttributes() != null
                && !other.requestCancelExternalWorkflowExecutionFailedEventAttributes().equals(
                        this.requestCancelExternalWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.scheduleActivityTaskFailedEventAttributes() == null ^ this.scheduleActivityTaskFailedEventAttributes() == null) {
            return false;
        }
        if (other.scheduleActivityTaskFailedEventAttributes() != null
                && !other.scheduleActivityTaskFailedEventAttributes().equals(this.scheduleActivityTaskFailedEventAttributes())) {
            return false;
        }
        if (other.requestCancelActivityTaskFailedEventAttributes() == null
                ^ this.requestCancelActivityTaskFailedEventAttributes() == null) {
            return false;
        }
        if (other.requestCancelActivityTaskFailedEventAttributes() != null
                && !other.requestCancelActivityTaskFailedEventAttributes().equals(
                        this.requestCancelActivityTaskFailedEventAttributes())) {
            return false;
        }
        if (other.startTimerFailedEventAttributes() == null ^ this.startTimerFailedEventAttributes() == null) {
            return false;
        }
        if (other.startTimerFailedEventAttributes() != null
                && !other.startTimerFailedEventAttributes().equals(this.startTimerFailedEventAttributes())) {
            return false;
        }
        if (other.cancelTimerFailedEventAttributes() == null ^ this.cancelTimerFailedEventAttributes() == null) {
            return false;
        }
        if (other.cancelTimerFailedEventAttributes() != null
                && !other.cancelTimerFailedEventAttributes().equals(this.cancelTimerFailedEventAttributes())) {
            return false;
        }
        if (other.startChildWorkflowExecutionFailedEventAttributes() == null
                ^ this.startChildWorkflowExecutionFailedEventAttributes() == null) {
            return false;
        }
        if (other.startChildWorkflowExecutionFailedEventAttributes() != null
                && !other.startChildWorkflowExecutionFailedEventAttributes().equals(
                        this.startChildWorkflowExecutionFailedEventAttributes())) {
            return false;
        }
        if (other.lambdaFunctionScheduledEventAttributes() == null ^ this.lambdaFunctionScheduledEventAttributes() == null) {
            return false;
        }
        if (other.lambdaFunctionScheduledEventAttributes() != null
                && !other.lambdaFunctionScheduledEventAttributes().equals(this.lambdaFunctionScheduledEventAttributes())) {
            return false;
        }
        if (other.lambdaFunctionStartedEventAttributes() == null ^ this.lambdaFunctionStartedEventAttributes() == null) {
            return false;
        }
        if (other.lambdaFunctionStartedEventAttributes() != null
                && !other.lambdaFunctionStartedEventAttributes().equals(this.lambdaFunctionStartedEventAttributes())) {
            return false;
        }
        if (other.lambdaFunctionCompletedEventAttributes() == null ^ this.lambdaFunctionCompletedEventAttributes() == null) {
            return false;
        }
        if (other.lambdaFunctionCompletedEventAttributes() != null
                && !other.lambdaFunctionCompletedEventAttributes().equals(this.lambdaFunctionCompletedEventAttributes())) {
            return false;
        }
        if (other.lambdaFunctionFailedEventAttributes() == null ^ this.lambdaFunctionFailedEventAttributes() == null) {
            return false;
        }
        if (other.lambdaFunctionFailedEventAttributes() != null
                && !other.lambdaFunctionFailedEventAttributes().equals(this.lambdaFunctionFailedEventAttributes())) {
            return false;
        }
        if (other.lambdaFunctionTimedOutEventAttributes() == null ^ this.lambdaFunctionTimedOutEventAttributes() == null) {
            return false;
        }
        if (other.lambdaFunctionTimedOutEventAttributes() != null
                && !other.lambdaFunctionTimedOutEventAttributes().equals(this.lambdaFunctionTimedOutEventAttributes())) {
            return false;
        }
        if (other.scheduleLambdaFunctionFailedEventAttributes() == null
                ^ this.scheduleLambdaFunctionFailedEventAttributes() == null) {
            return false;
        }
        if (other.scheduleLambdaFunctionFailedEventAttributes() != null
                && !other.scheduleLambdaFunctionFailedEventAttributes()
                        .equals(this.scheduleLambdaFunctionFailedEventAttributes())) {
            return false;
        }
        if (other.startLambdaFunctionFailedEventAttributes() == null ^ this.startLambdaFunctionFailedEventAttributes() == null) {
            return false;
        }
        if (other.startLambdaFunctionFailedEventAttributes() != null
                && !other.startLambdaFunctionFailedEventAttributes().equals(this.startLambdaFunctionFailedEventAttributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (eventTimestamp() != null) {
            sb.append("EventTimestamp: ").append(eventTimestamp()).append(",");
        }
        if (eventType() != null) {
            sb.append("EventType: ").append(eventType()).append(",");
        }
        if (eventId() != null) {
            sb.append("EventId: ").append(eventId()).append(",");
        }
        if (workflowExecutionStartedEventAttributes() != null) {
            sb.append("WorkflowExecutionStartedEventAttributes: ").append(workflowExecutionStartedEventAttributes()).append(",");
        }
        if (workflowExecutionCompletedEventAttributes() != null) {
            sb.append("WorkflowExecutionCompletedEventAttributes: ").append(workflowExecutionCompletedEventAttributes())
                    .append(",");
        }
        if (completeWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("CompleteWorkflowExecutionFailedEventAttributes: ")
                    .append(completeWorkflowExecutionFailedEventAttributes()).append(",");
        }
        if (workflowExecutionFailedEventAttributes() != null) {
            sb.append("WorkflowExecutionFailedEventAttributes: ").append(workflowExecutionFailedEventAttributes()).append(",");
        }
        if (failWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("FailWorkflowExecutionFailedEventAttributes: ").append(failWorkflowExecutionFailedEventAttributes())
                    .append(",");
        }
        if (workflowExecutionTimedOutEventAttributes() != null) {
            sb.append("WorkflowExecutionTimedOutEventAttributes: ").append(workflowExecutionTimedOutEventAttributes())
                    .append(",");
        }
        if (workflowExecutionCanceledEventAttributes() != null) {
            sb.append("WorkflowExecutionCanceledEventAttributes: ").append(workflowExecutionCanceledEventAttributes())
                    .append(",");
        }
        if (cancelWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("CancelWorkflowExecutionFailedEventAttributes: ").append(cancelWorkflowExecutionFailedEventAttributes())
                    .append(",");
        }
        if (workflowExecutionContinuedAsNewEventAttributes() != null) {
            sb.append("WorkflowExecutionContinuedAsNewEventAttributes: ")
                    .append(workflowExecutionContinuedAsNewEventAttributes()).append(",");
        }
        if (continueAsNewWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("ContinueAsNewWorkflowExecutionFailedEventAttributes: ")
                    .append(continueAsNewWorkflowExecutionFailedEventAttributes()).append(",");
        }
        if (workflowExecutionTerminatedEventAttributes() != null) {
            sb.append("WorkflowExecutionTerminatedEventAttributes: ").append(workflowExecutionTerminatedEventAttributes())
                    .append(",");
        }
        if (workflowExecutionCancelRequestedEventAttributes() != null) {
            sb.append("WorkflowExecutionCancelRequestedEventAttributes: ")
                    .append(workflowExecutionCancelRequestedEventAttributes()).append(",");
        }
        if (decisionTaskScheduledEventAttributes() != null) {
            sb.append("DecisionTaskScheduledEventAttributes: ").append(decisionTaskScheduledEventAttributes()).append(",");
        }
        if (decisionTaskStartedEventAttributes() != null) {
            sb.append("DecisionTaskStartedEventAttributes: ").append(decisionTaskStartedEventAttributes()).append(",");
        }
        if (decisionTaskCompletedEventAttributes() != null) {
            sb.append("DecisionTaskCompletedEventAttributes: ").append(decisionTaskCompletedEventAttributes()).append(",");
        }
        if (decisionTaskTimedOutEventAttributes() != null) {
            sb.append("DecisionTaskTimedOutEventAttributes: ").append(decisionTaskTimedOutEventAttributes()).append(",");
        }
        if (activityTaskScheduledEventAttributes() != null) {
            sb.append("ActivityTaskScheduledEventAttributes: ").append(activityTaskScheduledEventAttributes()).append(",");
        }
        if (activityTaskStartedEventAttributes() != null) {
            sb.append("ActivityTaskStartedEventAttributes: ").append(activityTaskStartedEventAttributes()).append(",");
        }
        if (activityTaskCompletedEventAttributes() != null) {
            sb.append("ActivityTaskCompletedEventAttributes: ").append(activityTaskCompletedEventAttributes()).append(",");
        }
        if (activityTaskFailedEventAttributes() != null) {
            sb.append("ActivityTaskFailedEventAttributes: ").append(activityTaskFailedEventAttributes()).append(",");
        }
        if (activityTaskTimedOutEventAttributes() != null) {
            sb.append("ActivityTaskTimedOutEventAttributes: ").append(activityTaskTimedOutEventAttributes()).append(",");
        }
        if (activityTaskCanceledEventAttributes() != null) {
            sb.append("ActivityTaskCanceledEventAttributes: ").append(activityTaskCanceledEventAttributes()).append(",");
        }
        if (activityTaskCancelRequestedEventAttributes() != null) {
            sb.append("ActivityTaskCancelRequestedEventAttributes: ").append(activityTaskCancelRequestedEventAttributes())
                    .append(",");
        }
        if (workflowExecutionSignaledEventAttributes() != null) {
            sb.append("WorkflowExecutionSignaledEventAttributes: ").append(workflowExecutionSignaledEventAttributes())
                    .append(",");
        }
        if (markerRecordedEventAttributes() != null) {
            sb.append("MarkerRecordedEventAttributes: ").append(markerRecordedEventAttributes()).append(",");
        }
        if (recordMarkerFailedEventAttributes() != null) {
            sb.append("RecordMarkerFailedEventAttributes: ").append(recordMarkerFailedEventAttributes()).append(",");
        }
        if (timerStartedEventAttributes() != null) {
            sb.append("TimerStartedEventAttributes: ").append(timerStartedEventAttributes()).append(",");
        }
        if (timerFiredEventAttributes() != null) {
            sb.append("TimerFiredEventAttributes: ").append(timerFiredEventAttributes()).append(",");
        }
        if (timerCanceledEventAttributes() != null) {
            sb.append("TimerCanceledEventAttributes: ").append(timerCanceledEventAttributes()).append(",");
        }
        if (startChildWorkflowExecutionInitiatedEventAttributes() != null) {
            sb.append("StartChildWorkflowExecutionInitiatedEventAttributes: ")
                    .append(startChildWorkflowExecutionInitiatedEventAttributes()).append(",");
        }
        if (childWorkflowExecutionStartedEventAttributes() != null) {
            sb.append("ChildWorkflowExecutionStartedEventAttributes: ").append(childWorkflowExecutionStartedEventAttributes())
                    .append(",");
        }
        if (childWorkflowExecutionCompletedEventAttributes() != null) {
            sb.append("ChildWorkflowExecutionCompletedEventAttributes: ")
                    .append(childWorkflowExecutionCompletedEventAttributes()).append(",");
        }
        if (childWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("ChildWorkflowExecutionFailedEventAttributes: ").append(childWorkflowExecutionFailedEventAttributes())
                    .append(",");
        }
        if (childWorkflowExecutionTimedOutEventAttributes() != null) {
            sb.append("ChildWorkflowExecutionTimedOutEventAttributes: ").append(childWorkflowExecutionTimedOutEventAttributes())
                    .append(",");
        }
        if (childWorkflowExecutionCanceledEventAttributes() != null) {
            sb.append("ChildWorkflowExecutionCanceledEventAttributes: ").append(childWorkflowExecutionCanceledEventAttributes())
                    .append(",");
        }
        if (childWorkflowExecutionTerminatedEventAttributes() != null) {
            sb.append("ChildWorkflowExecutionTerminatedEventAttributes: ")
                    .append(childWorkflowExecutionTerminatedEventAttributes()).append(",");
        }
        if (signalExternalWorkflowExecutionInitiatedEventAttributes() != null) {
            sb.append("SignalExternalWorkflowExecutionInitiatedEventAttributes: ")
                    .append(signalExternalWorkflowExecutionInitiatedEventAttributes()).append(",");
        }
        if (externalWorkflowExecutionSignaledEventAttributes() != null) {
            sb.append("ExternalWorkflowExecutionSignaledEventAttributes: ")
                    .append(externalWorkflowExecutionSignaledEventAttributes()).append(",");
        }
        if (signalExternalWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("SignalExternalWorkflowExecutionFailedEventAttributes: ")
                    .append(signalExternalWorkflowExecutionFailedEventAttributes()).append(",");
        }
        if (externalWorkflowExecutionCancelRequestedEventAttributes() != null) {
            sb.append("ExternalWorkflowExecutionCancelRequestedEventAttributes: ")
                    .append(externalWorkflowExecutionCancelRequestedEventAttributes()).append(",");
        }
        if (requestCancelExternalWorkflowExecutionInitiatedEventAttributes() != null) {
            sb.append("RequestCancelExternalWorkflowExecutionInitiatedEventAttributes: ")
                    .append(requestCancelExternalWorkflowExecutionInitiatedEventAttributes()).append(",");
        }
        if (requestCancelExternalWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("RequestCancelExternalWorkflowExecutionFailedEventAttributes: ")
                    .append(requestCancelExternalWorkflowExecutionFailedEventAttributes()).append(",");
        }
        if (scheduleActivityTaskFailedEventAttributes() != null) {
            sb.append("ScheduleActivityTaskFailedEventAttributes: ").append(scheduleActivityTaskFailedEventAttributes())
                    .append(",");
        }
        if (requestCancelActivityTaskFailedEventAttributes() != null) {
            sb.append("RequestCancelActivityTaskFailedEventAttributes: ")
                    .append(requestCancelActivityTaskFailedEventAttributes()).append(",");
        }
        if (startTimerFailedEventAttributes() != null) {
            sb.append("StartTimerFailedEventAttributes: ").append(startTimerFailedEventAttributes()).append(",");
        }
        if (cancelTimerFailedEventAttributes() != null) {
            sb.append("CancelTimerFailedEventAttributes: ").append(cancelTimerFailedEventAttributes()).append(",");
        }
        if (startChildWorkflowExecutionFailedEventAttributes() != null) {
            sb.append("StartChildWorkflowExecutionFailedEventAttributes: ")
                    .append(startChildWorkflowExecutionFailedEventAttributes()).append(",");
        }
        if (lambdaFunctionScheduledEventAttributes() != null) {
            sb.append("LambdaFunctionScheduledEventAttributes: ").append(lambdaFunctionScheduledEventAttributes()).append(",");
        }
        if (lambdaFunctionStartedEventAttributes() != null) {
            sb.append("LambdaFunctionStartedEventAttributes: ").append(lambdaFunctionStartedEventAttributes()).append(",");
        }
        if (lambdaFunctionCompletedEventAttributes() != null) {
            sb.append("LambdaFunctionCompletedEventAttributes: ").append(lambdaFunctionCompletedEventAttributes()).append(",");
        }
        if (lambdaFunctionFailedEventAttributes() != null) {
            sb.append("LambdaFunctionFailedEventAttributes: ").append(lambdaFunctionFailedEventAttributes()).append(",");
        }
        if (lambdaFunctionTimedOutEventAttributes() != null) {
            sb.append("LambdaFunctionTimedOutEventAttributes: ").append(lambdaFunctionTimedOutEventAttributes()).append(",");
        }
        if (scheduleLambdaFunctionFailedEventAttributes() != null) {
            sb.append("ScheduleLambdaFunctionFailedEventAttributes: ").append(scheduleLambdaFunctionFailedEventAttributes())
                    .append(",");
        }
        if (startLambdaFunctionFailedEventAttributes() != null) {
            sb.append("StartLambdaFunctionFailedEventAttributes: ").append(startLambdaFunctionFailedEventAttributes())
                    .append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HistoryEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, HistoryEvent> {
        /**
         * <p>
         * The date and time when the event occurred.
         * </p>
         * 
         * @param eventTimestamp
         *        The date and time when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Date eventTimestamp);

        /**
         * <p>
         * The type of the history event.
         * </p>
         * 
         * @param eventType
         *        The type of the history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of the history event.
         * </p>
         * 
         * @param eventType
         *        The type of the history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution
         * history.
         * </p>
         * 
         * @param eventId
         *        The system generated ID of the event. This ID uniquely identifies the event with in the workflow
         *        execution history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(Long eventId);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionStartedEventAttributes
         *        If the event is of type <code>WorkflowExecutionStarted</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionStartedEventAttributes(
                WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionCompletedEventAttributes
         *        If the event is of type <code>WorkflowExecutionCompleted</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionCompletedEventAttributes(
                WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param completeWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>CompleteWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completeWorkflowExecutionFailedEventAttributes(
                CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionFailedEventAttributes
         *        If the event is of type <code>WorkflowExecutionFailed</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionFailedEventAttributes(
                WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param failWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>FailWorkflowExecutionFailed</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failWorkflowExecutionFailedEventAttributes(
                FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionTimedOutEventAttributes
         *        If the event is of type <code>WorkflowExecutionTimedOut</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionTimedOutEventAttributes(
                WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionCanceledEventAttributes
         *        If the event is of type <code>WorkflowExecutionCanceled</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionCanceledEventAttributes(
                WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param cancelWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>CancelWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelWorkflowExecutionFailedEventAttributes(
                CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionContinuedAsNewEventAttributes
         *        If the event is of type <code>WorkflowExecutionContinuedAsNew</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionContinuedAsNewEventAttributes(
                WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param continueAsNewWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>ContinueAsNewWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continueAsNewWorkflowExecutionFailedEventAttributes(
                ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionTerminatedEventAttributes
         *        If the event is of type <code>WorkflowExecutionTerminated</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionTerminatedEventAttributes(
                WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionCancelRequestedEventAttributes
         *        If the event is of type <code>WorkflowExecutionCancelRequested</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionCancelRequestedEventAttributes(
                WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param decisionTaskScheduledEventAttributes
         *        If the event is of type <code>DecisionTaskScheduled</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskScheduledEventAttributes(DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param decisionTaskStartedEventAttributes
         *        If the event is of type <code>DecisionTaskStarted</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskStartedEventAttributes(DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param decisionTaskCompletedEventAttributes
         *        If the event is of type <code>DecisionTaskCompleted</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventAttributes(DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param decisionTaskTimedOutEventAttributes
         *        If the event is of type <code>DecisionTaskTimedOut</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskTimedOutEventAttributes(DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param activityTaskScheduledEventAttributes
         *        If the event is of type <code>ActivityTaskScheduled</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskScheduledEventAttributes(ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param activityTaskStartedEventAttributes
         *        If the event is of type <code>ActivityTaskStarted</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskStartedEventAttributes(ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param activityTaskCompletedEventAttributes
         *        If the event is of type <code>ActivityTaskCompleted</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskCompletedEventAttributes(ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param activityTaskFailedEventAttributes
         *        If the event is of type <code>ActivityTaskFailed</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param activityTaskTimedOutEventAttributes
         *        If the event is of type <code>ActivityTaskTimedOut</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskTimedOutEventAttributes(ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param activityTaskCanceledEventAttributes
         *        If the event is of type <code>ActivityTaskCanceled</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskCanceledEventAttributes(ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param activityTaskCancelRequestedEventAttributes
         *        If the event is of type <code>ActivityTaskcancelRequested</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityTaskCancelRequestedEventAttributes(
                ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param workflowExecutionSignaledEventAttributes
         *        If the event is of type <code>WorkflowExecutionSignaled</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionSignaledEventAttributes(
                WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed information
         * about the event. It is not set for other event types.
         * </p>
         * 
         * @param markerRecordedEventAttributes
         *        If the event is of type <code>MarkerRecorded</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerRecordedEventAttributes(MarkerRecordedEventAttributes markerRecordedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param recordMarkerFailedEventAttributes
         *        If the event is of type <code>DecisionTaskFailed</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>TimerStarted</code> then this member is set and provides detailed information
         * about the event. It is not set for other event types.
         * </p>
         * 
         * @param timerStartedEventAttributes
         *        If the event is of type <code>TimerStarted</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerStartedEventAttributes(TimerStartedEventAttributes timerStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>TimerFired</code> then this member is set and provides detailed information
         * about the event. It is not set for other event types.
         * </p>
         * 
         * @param timerFiredEventAttributes
         *        If the event is of type <code>TimerFired</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerFiredEventAttributes(TimerFiredEventAttributes timerFiredEventAttributes);

        /**
         * <p>
         * If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed information
         * about the event. It is not set for other event types.
         * </p>
         * 
         * @param timerCanceledEventAttributes
         *        If the event is of type <code>TimerCanceled</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerCanceledEventAttributes(TimerCanceledEventAttributes timerCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and
         * provides detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param startChildWorkflowExecutionInitiatedEventAttributes
         *        If the event is of type <code>StartChildWorkflowExecutionInitiated</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startChildWorkflowExecutionInitiatedEventAttributes(
                StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionStartedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionStarted</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionStartedEventAttributes(
                ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionCompletedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionCompleted</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionCompletedEventAttributes(
                ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionFailed</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionFailedEventAttributes(
                ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionTimedOutEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionTimedOut</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionTimedOutEventAttributes(
                ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionCanceledEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionCanceled</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionCanceledEventAttributes(
                ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param childWorkflowExecutionTerminatedEventAttributes
         *        If the event is of type <code>ChildWorkflowExecutionTerminated</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childWorkflowExecutionTerminatedEventAttributes(
                ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set and
         * provides detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param signalExternalWorkflowExecutionInitiatedEventAttributes
         *        If the event is of type <code>SignalExternalWorkflowExecutionInitiated</code> then this member is set
         *        and provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalExternalWorkflowExecutionInitiatedEventAttributes(
                SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param externalWorkflowExecutionSignaledEventAttributes
         *        If the event is of type <code>ExternalWorkflowExecutionSignaled</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecutionSignaledEventAttributes(
                ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes);

        /**
         * <p>
         * If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param signalExternalWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>SignalExternalWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalExternalWorkflowExecutionFailedEventAttributes(
                SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set and
         * provides detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param externalWorkflowExecutionCancelRequestedEventAttributes
         *        If the event is of type <code>ExternalWorkflowExecutionCancelRequested</code> then this member is set
         *        and provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecutionCancelRequestedEventAttributes(
                ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member is set
         * and provides detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param requestCancelExternalWorkflowExecutionInitiatedEventAttributes
         *        If the event is of type <code>RequestCancelExternalWorkflowExecutionInitiated</code> then this member
         *        is set and provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCancelExternalWorkflowExecutionInitiatedEventAttributes(
                RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is set and
         * provides detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param requestCancelExternalWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>RequestCancelExternalWorkflowExecutionFailed</code> then this member is
         *        set and provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCancelExternalWorkflowExecutionFailedEventAttributes(
                RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param scheduleActivityTaskFailedEventAttributes
         *        If the event is of type <code>ScheduleActivityTaskFailed</code> then this member is set and provides
         *        detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActivityTaskFailedEventAttributes(
                ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param requestCancelActivityTaskFailedEventAttributes
         *        If the event is of type <code>RequestCancelActivityTaskFailed</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestCancelActivityTaskFailedEventAttributes(
                RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param startTimerFailedEventAttributes
         *        If the event is of type <code>StartTimerFailed</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimerFailedEventAttributes(StartTimerFailedEventAttributes startTimerFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed
         * information about the event. It is not set for other event types.
         * </p>
         * 
         * @param cancelTimerFailedEventAttributes
         *        If the event is of type <code>CancelTimerFailed</code> then this member is set and provides detailed
         *        information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes);

        /**
         * <p>
         * If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and provides
         * detailed information about the event. It is not set for other event types.
         * </p>
         * 
         * @param startChildWorkflowExecutionFailedEventAttributes
         *        If the event is of type <code>StartChildWorkflowExecutionFailed</code> then this member is set and
         *        provides detailed information about the event. It is not set for other event types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startChildWorkflowExecutionFailedEventAttributes(
                StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes);

        /**
         *
         * @param lambdaFunctionScheduledEventAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionScheduledEventAttributes(
                LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes);

        /**
         *
         * @param lambdaFunctionStartedEventAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionStartedEventAttributes(LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes);

        /**
         *
         * @param lambdaFunctionCompletedEventAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionCompletedEventAttributes(
                LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes);

        /**
         *
         * @param lambdaFunctionFailedEventAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionFailedEventAttributes(LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes);

        /**
         *
         * @param lambdaFunctionTimedOutEventAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionTimedOutEventAttributes(LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes);

        /**
         *
         * @param scheduleLambdaFunctionFailedEventAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleLambdaFunctionFailedEventAttributes(
                ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes);

        /**
         *
         * @param startLambdaFunctionFailedEventAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startLambdaFunctionFailedEventAttributes(
                StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes);
    }

    private static final class BuilderImpl implements Builder {
        private Date eventTimestamp;

        private String eventType;

        private Long eventId;

        private WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes;

        private WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes;

        private CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes;

        private FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes;

        private WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes;

        private CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes;

        private ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes;

        private WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes;

        private WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes;

        private DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes;

        private DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes;

        private DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes;

        private DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes;

        private ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes;

        private ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes;

        private ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes;

        private ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes;

        private ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes;

        private ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes;

        private ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes;

        private WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes;

        private MarkerRecordedEventAttributes markerRecordedEventAttributes;

        private RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes;

        private TimerStartedEventAttributes timerStartedEventAttributes;

        private TimerFiredEventAttributes timerFiredEventAttributes;

        private TimerCanceledEventAttributes timerCanceledEventAttributes;

        private StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes;

        private ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes;

        private ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes;

        private ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes;

        private ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes;

        private ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes;

        private ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes;

        private SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes;

        private ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes;

        private SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes;

        private ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes;

        private RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes;

        private RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes;

        private ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes;

        private RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes;

        private StartTimerFailedEventAttributes startTimerFailedEventAttributes;

        private CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes;

        private StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes;

        private LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes;

        private LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes;

        private LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes;

        private LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes;

        private LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes;

        private ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes;

        private StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryEvent model) {
            setEventTimestamp(model.eventTimestamp);
            setEventType(model.eventType);
            setEventId(model.eventId);
            setWorkflowExecutionStartedEventAttributes(model.workflowExecutionStartedEventAttributes);
            setWorkflowExecutionCompletedEventAttributes(model.workflowExecutionCompletedEventAttributes);
            setCompleteWorkflowExecutionFailedEventAttributes(model.completeWorkflowExecutionFailedEventAttributes);
            setWorkflowExecutionFailedEventAttributes(model.workflowExecutionFailedEventAttributes);
            setFailWorkflowExecutionFailedEventAttributes(model.failWorkflowExecutionFailedEventAttributes);
            setWorkflowExecutionTimedOutEventAttributes(model.workflowExecutionTimedOutEventAttributes);
            setWorkflowExecutionCanceledEventAttributes(model.workflowExecutionCanceledEventAttributes);
            setCancelWorkflowExecutionFailedEventAttributes(model.cancelWorkflowExecutionFailedEventAttributes);
            setWorkflowExecutionContinuedAsNewEventAttributes(model.workflowExecutionContinuedAsNewEventAttributes);
            setContinueAsNewWorkflowExecutionFailedEventAttributes(model.continueAsNewWorkflowExecutionFailedEventAttributes);
            setWorkflowExecutionTerminatedEventAttributes(model.workflowExecutionTerminatedEventAttributes);
            setWorkflowExecutionCancelRequestedEventAttributes(model.workflowExecutionCancelRequestedEventAttributes);
            setDecisionTaskScheduledEventAttributes(model.decisionTaskScheduledEventAttributes);
            setDecisionTaskStartedEventAttributes(model.decisionTaskStartedEventAttributes);
            setDecisionTaskCompletedEventAttributes(model.decisionTaskCompletedEventAttributes);
            setDecisionTaskTimedOutEventAttributes(model.decisionTaskTimedOutEventAttributes);
            setActivityTaskScheduledEventAttributes(model.activityTaskScheduledEventAttributes);
            setActivityTaskStartedEventAttributes(model.activityTaskStartedEventAttributes);
            setActivityTaskCompletedEventAttributes(model.activityTaskCompletedEventAttributes);
            setActivityTaskFailedEventAttributes(model.activityTaskFailedEventAttributes);
            setActivityTaskTimedOutEventAttributes(model.activityTaskTimedOutEventAttributes);
            setActivityTaskCanceledEventAttributes(model.activityTaskCanceledEventAttributes);
            setActivityTaskCancelRequestedEventAttributes(model.activityTaskCancelRequestedEventAttributes);
            setWorkflowExecutionSignaledEventAttributes(model.workflowExecutionSignaledEventAttributes);
            setMarkerRecordedEventAttributes(model.markerRecordedEventAttributes);
            setRecordMarkerFailedEventAttributes(model.recordMarkerFailedEventAttributes);
            setTimerStartedEventAttributes(model.timerStartedEventAttributes);
            setTimerFiredEventAttributes(model.timerFiredEventAttributes);
            setTimerCanceledEventAttributes(model.timerCanceledEventAttributes);
            setStartChildWorkflowExecutionInitiatedEventAttributes(model.startChildWorkflowExecutionInitiatedEventAttributes);
            setChildWorkflowExecutionStartedEventAttributes(model.childWorkflowExecutionStartedEventAttributes);
            setChildWorkflowExecutionCompletedEventAttributes(model.childWorkflowExecutionCompletedEventAttributes);
            setChildWorkflowExecutionFailedEventAttributes(model.childWorkflowExecutionFailedEventAttributes);
            setChildWorkflowExecutionTimedOutEventAttributes(model.childWorkflowExecutionTimedOutEventAttributes);
            setChildWorkflowExecutionCanceledEventAttributes(model.childWorkflowExecutionCanceledEventAttributes);
            setChildWorkflowExecutionTerminatedEventAttributes(model.childWorkflowExecutionTerminatedEventAttributes);
            setSignalExternalWorkflowExecutionInitiatedEventAttributes(model.signalExternalWorkflowExecutionInitiatedEventAttributes);
            setExternalWorkflowExecutionSignaledEventAttributes(model.externalWorkflowExecutionSignaledEventAttributes);
            setSignalExternalWorkflowExecutionFailedEventAttributes(model.signalExternalWorkflowExecutionFailedEventAttributes);
            setExternalWorkflowExecutionCancelRequestedEventAttributes(model.externalWorkflowExecutionCancelRequestedEventAttributes);
            setRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(model.requestCancelExternalWorkflowExecutionInitiatedEventAttributes);
            setRequestCancelExternalWorkflowExecutionFailedEventAttributes(model.requestCancelExternalWorkflowExecutionFailedEventAttributes);
            setScheduleActivityTaskFailedEventAttributes(model.scheduleActivityTaskFailedEventAttributes);
            setRequestCancelActivityTaskFailedEventAttributes(model.requestCancelActivityTaskFailedEventAttributes);
            setStartTimerFailedEventAttributes(model.startTimerFailedEventAttributes);
            setCancelTimerFailedEventAttributes(model.cancelTimerFailedEventAttributes);
            setStartChildWorkflowExecutionFailedEventAttributes(model.startChildWorkflowExecutionFailedEventAttributes);
            setLambdaFunctionScheduledEventAttributes(model.lambdaFunctionScheduledEventAttributes);
            setLambdaFunctionStartedEventAttributes(model.lambdaFunctionStartedEventAttributes);
            setLambdaFunctionCompletedEventAttributes(model.lambdaFunctionCompletedEventAttributes);
            setLambdaFunctionFailedEventAttributes(model.lambdaFunctionFailedEventAttributes);
            setLambdaFunctionTimedOutEventAttributes(model.lambdaFunctionTimedOutEventAttributes);
            setScheduleLambdaFunctionFailedEventAttributes(model.scheduleLambdaFunctionFailedEventAttributes);
            setStartLambdaFunctionFailedEventAttributes(model.startLambdaFunctionFailedEventAttributes);
        }

        public final Date getEventTimestamp() {
            return eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Date eventTimestamp) {
            this.eventTimestamp = StandardMemberCopier.copy(eventTimestamp);
            return this;
        }

        public final void setEventTimestamp(Date eventTimestamp) {
            this.eventTimestamp = StandardMemberCopier.copy(eventTimestamp);
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final void setEventType(EventType eventType) {
            this.eventType(eventType.toString());
        }

        public final Long getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(Long eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(Long eventId) {
            this.eventId = eventId;
        }

        public final WorkflowExecutionStartedEventAttributes getWorkflowExecutionStartedEventAttributes() {
            return workflowExecutionStartedEventAttributes;
        }

        @Override
        public final Builder workflowExecutionStartedEventAttributes(
                WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes) {
            this.workflowExecutionStartedEventAttributes = workflowExecutionStartedEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionStartedEventAttributes(
                WorkflowExecutionStartedEventAttributes workflowExecutionStartedEventAttributes) {
            this.workflowExecutionStartedEventAttributes = workflowExecutionStartedEventAttributes;
        }

        public final WorkflowExecutionCompletedEventAttributes getWorkflowExecutionCompletedEventAttributes() {
            return workflowExecutionCompletedEventAttributes;
        }

        @Override
        public final Builder workflowExecutionCompletedEventAttributes(
                WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes) {
            this.workflowExecutionCompletedEventAttributes = workflowExecutionCompletedEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionCompletedEventAttributes(
                WorkflowExecutionCompletedEventAttributes workflowExecutionCompletedEventAttributes) {
            this.workflowExecutionCompletedEventAttributes = workflowExecutionCompletedEventAttributes;
        }

        public final CompleteWorkflowExecutionFailedEventAttributes getCompleteWorkflowExecutionFailedEventAttributes() {
            return completeWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder completeWorkflowExecutionFailedEventAttributes(
                CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes) {
            this.completeWorkflowExecutionFailedEventAttributes = completeWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setCompleteWorkflowExecutionFailedEventAttributes(
                CompleteWorkflowExecutionFailedEventAttributes completeWorkflowExecutionFailedEventAttributes) {
            this.completeWorkflowExecutionFailedEventAttributes = completeWorkflowExecutionFailedEventAttributes;
        }

        public final WorkflowExecutionFailedEventAttributes getWorkflowExecutionFailedEventAttributes() {
            return workflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder workflowExecutionFailedEventAttributes(
                WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes) {
            this.workflowExecutionFailedEventAttributes = workflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionFailedEventAttributes(
                WorkflowExecutionFailedEventAttributes workflowExecutionFailedEventAttributes) {
            this.workflowExecutionFailedEventAttributes = workflowExecutionFailedEventAttributes;
        }

        public final FailWorkflowExecutionFailedEventAttributes getFailWorkflowExecutionFailedEventAttributes() {
            return failWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder failWorkflowExecutionFailedEventAttributes(
                FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes) {
            this.failWorkflowExecutionFailedEventAttributes = failWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setFailWorkflowExecutionFailedEventAttributes(
                FailWorkflowExecutionFailedEventAttributes failWorkflowExecutionFailedEventAttributes) {
            this.failWorkflowExecutionFailedEventAttributes = failWorkflowExecutionFailedEventAttributes;
        }

        public final WorkflowExecutionTimedOutEventAttributes getWorkflowExecutionTimedOutEventAttributes() {
            return workflowExecutionTimedOutEventAttributes;
        }

        @Override
        public final Builder workflowExecutionTimedOutEventAttributes(
                WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes) {
            this.workflowExecutionTimedOutEventAttributes = workflowExecutionTimedOutEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionTimedOutEventAttributes(
                WorkflowExecutionTimedOutEventAttributes workflowExecutionTimedOutEventAttributes) {
            this.workflowExecutionTimedOutEventAttributes = workflowExecutionTimedOutEventAttributes;
        }

        public final WorkflowExecutionCanceledEventAttributes getWorkflowExecutionCanceledEventAttributes() {
            return workflowExecutionCanceledEventAttributes;
        }

        @Override
        public final Builder workflowExecutionCanceledEventAttributes(
                WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes) {
            this.workflowExecutionCanceledEventAttributes = workflowExecutionCanceledEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionCanceledEventAttributes(
                WorkflowExecutionCanceledEventAttributes workflowExecutionCanceledEventAttributes) {
            this.workflowExecutionCanceledEventAttributes = workflowExecutionCanceledEventAttributes;
        }

        public final CancelWorkflowExecutionFailedEventAttributes getCancelWorkflowExecutionFailedEventAttributes() {
            return cancelWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder cancelWorkflowExecutionFailedEventAttributes(
                CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes) {
            this.cancelWorkflowExecutionFailedEventAttributes = cancelWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setCancelWorkflowExecutionFailedEventAttributes(
                CancelWorkflowExecutionFailedEventAttributes cancelWorkflowExecutionFailedEventAttributes) {
            this.cancelWorkflowExecutionFailedEventAttributes = cancelWorkflowExecutionFailedEventAttributes;
        }

        public final WorkflowExecutionContinuedAsNewEventAttributes getWorkflowExecutionContinuedAsNewEventAttributes() {
            return workflowExecutionContinuedAsNewEventAttributes;
        }

        @Override
        public final Builder workflowExecutionContinuedAsNewEventAttributes(
                WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes) {
            this.workflowExecutionContinuedAsNewEventAttributes = workflowExecutionContinuedAsNewEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionContinuedAsNewEventAttributes(
                WorkflowExecutionContinuedAsNewEventAttributes workflowExecutionContinuedAsNewEventAttributes) {
            this.workflowExecutionContinuedAsNewEventAttributes = workflowExecutionContinuedAsNewEventAttributes;
        }

        public final ContinueAsNewWorkflowExecutionFailedEventAttributes getContinueAsNewWorkflowExecutionFailedEventAttributes() {
            return continueAsNewWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder continueAsNewWorkflowExecutionFailedEventAttributes(
                ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes) {
            this.continueAsNewWorkflowExecutionFailedEventAttributes = continueAsNewWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setContinueAsNewWorkflowExecutionFailedEventAttributes(
                ContinueAsNewWorkflowExecutionFailedEventAttributes continueAsNewWorkflowExecutionFailedEventAttributes) {
            this.continueAsNewWorkflowExecutionFailedEventAttributes = continueAsNewWorkflowExecutionFailedEventAttributes;
        }

        public final WorkflowExecutionTerminatedEventAttributes getWorkflowExecutionTerminatedEventAttributes() {
            return workflowExecutionTerminatedEventAttributes;
        }

        @Override
        public final Builder workflowExecutionTerminatedEventAttributes(
                WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes) {
            this.workflowExecutionTerminatedEventAttributes = workflowExecutionTerminatedEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionTerminatedEventAttributes(
                WorkflowExecutionTerminatedEventAttributes workflowExecutionTerminatedEventAttributes) {
            this.workflowExecutionTerminatedEventAttributes = workflowExecutionTerminatedEventAttributes;
        }

        public final WorkflowExecutionCancelRequestedEventAttributes getWorkflowExecutionCancelRequestedEventAttributes() {
            return workflowExecutionCancelRequestedEventAttributes;
        }

        @Override
        public final Builder workflowExecutionCancelRequestedEventAttributes(
                WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes) {
            this.workflowExecutionCancelRequestedEventAttributes = workflowExecutionCancelRequestedEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionCancelRequestedEventAttributes(
                WorkflowExecutionCancelRequestedEventAttributes workflowExecutionCancelRequestedEventAttributes) {
            this.workflowExecutionCancelRequestedEventAttributes = workflowExecutionCancelRequestedEventAttributes;
        }

        public final DecisionTaskScheduledEventAttributes getDecisionTaskScheduledEventAttributes() {
            return decisionTaskScheduledEventAttributes;
        }

        @Override
        public final Builder decisionTaskScheduledEventAttributes(
                DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes) {
            this.decisionTaskScheduledEventAttributes = decisionTaskScheduledEventAttributes;
            return this;
        }

        public final void setDecisionTaskScheduledEventAttributes(
                DecisionTaskScheduledEventAttributes decisionTaskScheduledEventAttributes) {
            this.decisionTaskScheduledEventAttributes = decisionTaskScheduledEventAttributes;
        }

        public final DecisionTaskStartedEventAttributes getDecisionTaskStartedEventAttributes() {
            return decisionTaskStartedEventAttributes;
        }

        @Override
        public final Builder decisionTaskStartedEventAttributes(
                DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes) {
            this.decisionTaskStartedEventAttributes = decisionTaskStartedEventAttributes;
            return this;
        }

        public final void setDecisionTaskStartedEventAttributes(
                DecisionTaskStartedEventAttributes decisionTaskStartedEventAttributes) {
            this.decisionTaskStartedEventAttributes = decisionTaskStartedEventAttributes;
        }

        public final DecisionTaskCompletedEventAttributes getDecisionTaskCompletedEventAttributes() {
            return decisionTaskCompletedEventAttributes;
        }

        @Override
        public final Builder decisionTaskCompletedEventAttributes(
                DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes) {
            this.decisionTaskCompletedEventAttributes = decisionTaskCompletedEventAttributes;
            return this;
        }

        public final void setDecisionTaskCompletedEventAttributes(
                DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes) {
            this.decisionTaskCompletedEventAttributes = decisionTaskCompletedEventAttributes;
        }

        public final DecisionTaskTimedOutEventAttributes getDecisionTaskTimedOutEventAttributes() {
            return decisionTaskTimedOutEventAttributes;
        }

        @Override
        public final Builder decisionTaskTimedOutEventAttributes(
                DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes) {
            this.decisionTaskTimedOutEventAttributes = decisionTaskTimedOutEventAttributes;
            return this;
        }

        public final void setDecisionTaskTimedOutEventAttributes(
                DecisionTaskTimedOutEventAttributes decisionTaskTimedOutEventAttributes) {
            this.decisionTaskTimedOutEventAttributes = decisionTaskTimedOutEventAttributes;
        }

        public final ActivityTaskScheduledEventAttributes getActivityTaskScheduledEventAttributes() {
            return activityTaskScheduledEventAttributes;
        }

        @Override
        public final Builder activityTaskScheduledEventAttributes(
                ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes) {
            this.activityTaskScheduledEventAttributes = activityTaskScheduledEventAttributes;
            return this;
        }

        public final void setActivityTaskScheduledEventAttributes(
                ActivityTaskScheduledEventAttributes activityTaskScheduledEventAttributes) {
            this.activityTaskScheduledEventAttributes = activityTaskScheduledEventAttributes;
        }

        public final ActivityTaskStartedEventAttributes getActivityTaskStartedEventAttributes() {
            return activityTaskStartedEventAttributes;
        }

        @Override
        public final Builder activityTaskStartedEventAttributes(
                ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes) {
            this.activityTaskStartedEventAttributes = activityTaskStartedEventAttributes;
            return this;
        }

        public final void setActivityTaskStartedEventAttributes(
                ActivityTaskStartedEventAttributes activityTaskStartedEventAttributes) {
            this.activityTaskStartedEventAttributes = activityTaskStartedEventAttributes;
        }

        public final ActivityTaskCompletedEventAttributes getActivityTaskCompletedEventAttributes() {
            return activityTaskCompletedEventAttributes;
        }

        @Override
        public final Builder activityTaskCompletedEventAttributes(
                ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes) {
            this.activityTaskCompletedEventAttributes = activityTaskCompletedEventAttributes;
            return this;
        }

        public final void setActivityTaskCompletedEventAttributes(
                ActivityTaskCompletedEventAttributes activityTaskCompletedEventAttributes) {
            this.activityTaskCompletedEventAttributes = activityTaskCompletedEventAttributes;
        }

        public final ActivityTaskFailedEventAttributes getActivityTaskFailedEventAttributes() {
            return activityTaskFailedEventAttributes;
        }

        @Override
        public final Builder activityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes) {
            this.activityTaskFailedEventAttributes = activityTaskFailedEventAttributes;
            return this;
        }

        public final void setActivityTaskFailedEventAttributes(ActivityTaskFailedEventAttributes activityTaskFailedEventAttributes) {
            this.activityTaskFailedEventAttributes = activityTaskFailedEventAttributes;
        }

        public final ActivityTaskTimedOutEventAttributes getActivityTaskTimedOutEventAttributes() {
            return activityTaskTimedOutEventAttributes;
        }

        @Override
        public final Builder activityTaskTimedOutEventAttributes(
                ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes) {
            this.activityTaskTimedOutEventAttributes = activityTaskTimedOutEventAttributes;
            return this;
        }

        public final void setActivityTaskTimedOutEventAttributes(
                ActivityTaskTimedOutEventAttributes activityTaskTimedOutEventAttributes) {
            this.activityTaskTimedOutEventAttributes = activityTaskTimedOutEventAttributes;
        }

        public final ActivityTaskCanceledEventAttributes getActivityTaskCanceledEventAttributes() {
            return activityTaskCanceledEventAttributes;
        }

        @Override
        public final Builder activityTaskCanceledEventAttributes(
                ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes) {
            this.activityTaskCanceledEventAttributes = activityTaskCanceledEventAttributes;
            return this;
        }

        public final void setActivityTaskCanceledEventAttributes(
                ActivityTaskCanceledEventAttributes activityTaskCanceledEventAttributes) {
            this.activityTaskCanceledEventAttributes = activityTaskCanceledEventAttributes;
        }

        public final ActivityTaskCancelRequestedEventAttributes getActivityTaskCancelRequestedEventAttributes() {
            return activityTaskCancelRequestedEventAttributes;
        }

        @Override
        public final Builder activityTaskCancelRequestedEventAttributes(
                ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes) {
            this.activityTaskCancelRequestedEventAttributes = activityTaskCancelRequestedEventAttributes;
            return this;
        }

        public final void setActivityTaskCancelRequestedEventAttributes(
                ActivityTaskCancelRequestedEventAttributes activityTaskCancelRequestedEventAttributes) {
            this.activityTaskCancelRequestedEventAttributes = activityTaskCancelRequestedEventAttributes;
        }

        public final WorkflowExecutionSignaledEventAttributes getWorkflowExecutionSignaledEventAttributes() {
            return workflowExecutionSignaledEventAttributes;
        }

        @Override
        public final Builder workflowExecutionSignaledEventAttributes(
                WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes) {
            this.workflowExecutionSignaledEventAttributes = workflowExecutionSignaledEventAttributes;
            return this;
        }

        public final void setWorkflowExecutionSignaledEventAttributes(
                WorkflowExecutionSignaledEventAttributes workflowExecutionSignaledEventAttributes) {
            this.workflowExecutionSignaledEventAttributes = workflowExecutionSignaledEventAttributes;
        }

        public final MarkerRecordedEventAttributes getMarkerRecordedEventAttributes() {
            return markerRecordedEventAttributes;
        }

        @Override
        public final Builder markerRecordedEventAttributes(MarkerRecordedEventAttributes markerRecordedEventAttributes) {
            this.markerRecordedEventAttributes = markerRecordedEventAttributes;
            return this;
        }

        public final void setMarkerRecordedEventAttributes(MarkerRecordedEventAttributes markerRecordedEventAttributes) {
            this.markerRecordedEventAttributes = markerRecordedEventAttributes;
        }

        public final RecordMarkerFailedEventAttributes getRecordMarkerFailedEventAttributes() {
            return recordMarkerFailedEventAttributes;
        }

        @Override
        public final Builder recordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes) {
            this.recordMarkerFailedEventAttributes = recordMarkerFailedEventAttributes;
            return this;
        }

        public final void setRecordMarkerFailedEventAttributes(RecordMarkerFailedEventAttributes recordMarkerFailedEventAttributes) {
            this.recordMarkerFailedEventAttributes = recordMarkerFailedEventAttributes;
        }

        public final TimerStartedEventAttributes getTimerStartedEventAttributes() {
            return timerStartedEventAttributes;
        }

        @Override
        public final Builder timerStartedEventAttributes(TimerStartedEventAttributes timerStartedEventAttributes) {
            this.timerStartedEventAttributes = timerStartedEventAttributes;
            return this;
        }

        public final void setTimerStartedEventAttributes(TimerStartedEventAttributes timerStartedEventAttributes) {
            this.timerStartedEventAttributes = timerStartedEventAttributes;
        }

        public final TimerFiredEventAttributes getTimerFiredEventAttributes() {
            return timerFiredEventAttributes;
        }

        @Override
        public final Builder timerFiredEventAttributes(TimerFiredEventAttributes timerFiredEventAttributes) {
            this.timerFiredEventAttributes = timerFiredEventAttributes;
            return this;
        }

        public final void setTimerFiredEventAttributes(TimerFiredEventAttributes timerFiredEventAttributes) {
            this.timerFiredEventAttributes = timerFiredEventAttributes;
        }

        public final TimerCanceledEventAttributes getTimerCanceledEventAttributes() {
            return timerCanceledEventAttributes;
        }

        @Override
        public final Builder timerCanceledEventAttributes(TimerCanceledEventAttributes timerCanceledEventAttributes) {
            this.timerCanceledEventAttributes = timerCanceledEventAttributes;
            return this;
        }

        public final void setTimerCanceledEventAttributes(TimerCanceledEventAttributes timerCanceledEventAttributes) {
            this.timerCanceledEventAttributes = timerCanceledEventAttributes;
        }

        public final StartChildWorkflowExecutionInitiatedEventAttributes getStartChildWorkflowExecutionInitiatedEventAttributes() {
            return startChildWorkflowExecutionInitiatedEventAttributes;
        }

        @Override
        public final Builder startChildWorkflowExecutionInitiatedEventAttributes(
                StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes) {
            this.startChildWorkflowExecutionInitiatedEventAttributes = startChildWorkflowExecutionInitiatedEventAttributes;
            return this;
        }

        public final void setStartChildWorkflowExecutionInitiatedEventAttributes(
                StartChildWorkflowExecutionInitiatedEventAttributes startChildWorkflowExecutionInitiatedEventAttributes) {
            this.startChildWorkflowExecutionInitiatedEventAttributes = startChildWorkflowExecutionInitiatedEventAttributes;
        }

        public final ChildWorkflowExecutionStartedEventAttributes getChildWorkflowExecutionStartedEventAttributes() {
            return childWorkflowExecutionStartedEventAttributes;
        }

        @Override
        public final Builder childWorkflowExecutionStartedEventAttributes(
                ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes) {
            this.childWorkflowExecutionStartedEventAttributes = childWorkflowExecutionStartedEventAttributes;
            return this;
        }

        public final void setChildWorkflowExecutionStartedEventAttributes(
                ChildWorkflowExecutionStartedEventAttributes childWorkflowExecutionStartedEventAttributes) {
            this.childWorkflowExecutionStartedEventAttributes = childWorkflowExecutionStartedEventAttributes;
        }

        public final ChildWorkflowExecutionCompletedEventAttributes getChildWorkflowExecutionCompletedEventAttributes() {
            return childWorkflowExecutionCompletedEventAttributes;
        }

        @Override
        public final Builder childWorkflowExecutionCompletedEventAttributes(
                ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes) {
            this.childWorkflowExecutionCompletedEventAttributes = childWorkflowExecutionCompletedEventAttributes;
            return this;
        }

        public final void setChildWorkflowExecutionCompletedEventAttributes(
                ChildWorkflowExecutionCompletedEventAttributes childWorkflowExecutionCompletedEventAttributes) {
            this.childWorkflowExecutionCompletedEventAttributes = childWorkflowExecutionCompletedEventAttributes;
        }

        public final ChildWorkflowExecutionFailedEventAttributes getChildWorkflowExecutionFailedEventAttributes() {
            return childWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder childWorkflowExecutionFailedEventAttributes(
                ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes) {
            this.childWorkflowExecutionFailedEventAttributes = childWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setChildWorkflowExecutionFailedEventAttributes(
                ChildWorkflowExecutionFailedEventAttributes childWorkflowExecutionFailedEventAttributes) {
            this.childWorkflowExecutionFailedEventAttributes = childWorkflowExecutionFailedEventAttributes;
        }

        public final ChildWorkflowExecutionTimedOutEventAttributes getChildWorkflowExecutionTimedOutEventAttributes() {
            return childWorkflowExecutionTimedOutEventAttributes;
        }

        @Override
        public final Builder childWorkflowExecutionTimedOutEventAttributes(
                ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes) {
            this.childWorkflowExecutionTimedOutEventAttributes = childWorkflowExecutionTimedOutEventAttributes;
            return this;
        }

        public final void setChildWorkflowExecutionTimedOutEventAttributes(
                ChildWorkflowExecutionTimedOutEventAttributes childWorkflowExecutionTimedOutEventAttributes) {
            this.childWorkflowExecutionTimedOutEventAttributes = childWorkflowExecutionTimedOutEventAttributes;
        }

        public final ChildWorkflowExecutionCanceledEventAttributes getChildWorkflowExecutionCanceledEventAttributes() {
            return childWorkflowExecutionCanceledEventAttributes;
        }

        @Override
        public final Builder childWorkflowExecutionCanceledEventAttributes(
                ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes) {
            this.childWorkflowExecutionCanceledEventAttributes = childWorkflowExecutionCanceledEventAttributes;
            return this;
        }

        public final void setChildWorkflowExecutionCanceledEventAttributes(
                ChildWorkflowExecutionCanceledEventAttributes childWorkflowExecutionCanceledEventAttributes) {
            this.childWorkflowExecutionCanceledEventAttributes = childWorkflowExecutionCanceledEventAttributes;
        }

        public final ChildWorkflowExecutionTerminatedEventAttributes getChildWorkflowExecutionTerminatedEventAttributes() {
            return childWorkflowExecutionTerminatedEventAttributes;
        }

        @Override
        public final Builder childWorkflowExecutionTerminatedEventAttributes(
                ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes) {
            this.childWorkflowExecutionTerminatedEventAttributes = childWorkflowExecutionTerminatedEventAttributes;
            return this;
        }

        public final void setChildWorkflowExecutionTerminatedEventAttributes(
                ChildWorkflowExecutionTerminatedEventAttributes childWorkflowExecutionTerminatedEventAttributes) {
            this.childWorkflowExecutionTerminatedEventAttributes = childWorkflowExecutionTerminatedEventAttributes;
        }

        public final SignalExternalWorkflowExecutionInitiatedEventAttributes getSignalExternalWorkflowExecutionInitiatedEventAttributes() {
            return signalExternalWorkflowExecutionInitiatedEventAttributes;
        }

        @Override
        public final Builder signalExternalWorkflowExecutionInitiatedEventAttributes(
                SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes) {
            this.signalExternalWorkflowExecutionInitiatedEventAttributes = signalExternalWorkflowExecutionInitiatedEventAttributes;
            return this;
        }

        public final void setSignalExternalWorkflowExecutionInitiatedEventAttributes(
                SignalExternalWorkflowExecutionInitiatedEventAttributes signalExternalWorkflowExecutionInitiatedEventAttributes) {
            this.signalExternalWorkflowExecutionInitiatedEventAttributes = signalExternalWorkflowExecutionInitiatedEventAttributes;
        }

        public final ExternalWorkflowExecutionSignaledEventAttributes getExternalWorkflowExecutionSignaledEventAttributes() {
            return externalWorkflowExecutionSignaledEventAttributes;
        }

        @Override
        public final Builder externalWorkflowExecutionSignaledEventAttributes(
                ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes) {
            this.externalWorkflowExecutionSignaledEventAttributes = externalWorkflowExecutionSignaledEventAttributes;
            return this;
        }

        public final void setExternalWorkflowExecutionSignaledEventAttributes(
                ExternalWorkflowExecutionSignaledEventAttributes externalWorkflowExecutionSignaledEventAttributes) {
            this.externalWorkflowExecutionSignaledEventAttributes = externalWorkflowExecutionSignaledEventAttributes;
        }

        public final SignalExternalWorkflowExecutionFailedEventAttributes getSignalExternalWorkflowExecutionFailedEventAttributes() {
            return signalExternalWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder signalExternalWorkflowExecutionFailedEventAttributes(
                SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes) {
            this.signalExternalWorkflowExecutionFailedEventAttributes = signalExternalWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setSignalExternalWorkflowExecutionFailedEventAttributes(
                SignalExternalWorkflowExecutionFailedEventAttributes signalExternalWorkflowExecutionFailedEventAttributes) {
            this.signalExternalWorkflowExecutionFailedEventAttributes = signalExternalWorkflowExecutionFailedEventAttributes;
        }

        public final ExternalWorkflowExecutionCancelRequestedEventAttributes getExternalWorkflowExecutionCancelRequestedEventAttributes() {
            return externalWorkflowExecutionCancelRequestedEventAttributes;
        }

        @Override
        public final Builder externalWorkflowExecutionCancelRequestedEventAttributes(
                ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes) {
            this.externalWorkflowExecutionCancelRequestedEventAttributes = externalWorkflowExecutionCancelRequestedEventAttributes;
            return this;
        }

        public final void setExternalWorkflowExecutionCancelRequestedEventAttributes(
                ExternalWorkflowExecutionCancelRequestedEventAttributes externalWorkflowExecutionCancelRequestedEventAttributes) {
            this.externalWorkflowExecutionCancelRequestedEventAttributes = externalWorkflowExecutionCancelRequestedEventAttributes;
        }

        public final RequestCancelExternalWorkflowExecutionInitiatedEventAttributes getRequestCancelExternalWorkflowExecutionInitiatedEventAttributes() {
            return requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
        }

        @Override
        public final Builder requestCancelExternalWorkflowExecutionInitiatedEventAttributes(
                RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
            return this;
        }

        public final void setRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(
                RequestCancelExternalWorkflowExecutionInitiatedEventAttributes requestCancelExternalWorkflowExecutionInitiatedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = requestCancelExternalWorkflowExecutionInitiatedEventAttributes;
        }

        public final RequestCancelExternalWorkflowExecutionFailedEventAttributes getRequestCancelExternalWorkflowExecutionFailedEventAttributes() {
            return requestCancelExternalWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder requestCancelExternalWorkflowExecutionFailedEventAttributes(
                RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionFailedEventAttributes = requestCancelExternalWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setRequestCancelExternalWorkflowExecutionFailedEventAttributes(
                RequestCancelExternalWorkflowExecutionFailedEventAttributes requestCancelExternalWorkflowExecutionFailedEventAttributes) {
            this.requestCancelExternalWorkflowExecutionFailedEventAttributes = requestCancelExternalWorkflowExecutionFailedEventAttributes;
        }

        public final ScheduleActivityTaskFailedEventAttributes getScheduleActivityTaskFailedEventAttributes() {
            return scheduleActivityTaskFailedEventAttributes;
        }

        @Override
        public final Builder scheduleActivityTaskFailedEventAttributes(
                ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes) {
            this.scheduleActivityTaskFailedEventAttributes = scheduleActivityTaskFailedEventAttributes;
            return this;
        }

        public final void setScheduleActivityTaskFailedEventAttributes(
                ScheduleActivityTaskFailedEventAttributes scheduleActivityTaskFailedEventAttributes) {
            this.scheduleActivityTaskFailedEventAttributes = scheduleActivityTaskFailedEventAttributes;
        }

        public final RequestCancelActivityTaskFailedEventAttributes getRequestCancelActivityTaskFailedEventAttributes() {
            return requestCancelActivityTaskFailedEventAttributes;
        }

        @Override
        public final Builder requestCancelActivityTaskFailedEventAttributes(
                RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes) {
            this.requestCancelActivityTaskFailedEventAttributes = requestCancelActivityTaskFailedEventAttributes;
            return this;
        }

        public final void setRequestCancelActivityTaskFailedEventAttributes(
                RequestCancelActivityTaskFailedEventAttributes requestCancelActivityTaskFailedEventAttributes) {
            this.requestCancelActivityTaskFailedEventAttributes = requestCancelActivityTaskFailedEventAttributes;
        }

        public final StartTimerFailedEventAttributes getStartTimerFailedEventAttributes() {
            return startTimerFailedEventAttributes;
        }

        @Override
        public final Builder startTimerFailedEventAttributes(StartTimerFailedEventAttributes startTimerFailedEventAttributes) {
            this.startTimerFailedEventAttributes = startTimerFailedEventAttributes;
            return this;
        }

        public final void setStartTimerFailedEventAttributes(StartTimerFailedEventAttributes startTimerFailedEventAttributes) {
            this.startTimerFailedEventAttributes = startTimerFailedEventAttributes;
        }

        public final CancelTimerFailedEventAttributes getCancelTimerFailedEventAttributes() {
            return cancelTimerFailedEventAttributes;
        }

        @Override
        public final Builder cancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes) {
            this.cancelTimerFailedEventAttributes = cancelTimerFailedEventAttributes;
            return this;
        }

        public final void setCancelTimerFailedEventAttributes(CancelTimerFailedEventAttributes cancelTimerFailedEventAttributes) {
            this.cancelTimerFailedEventAttributes = cancelTimerFailedEventAttributes;
        }

        public final StartChildWorkflowExecutionFailedEventAttributes getStartChildWorkflowExecutionFailedEventAttributes() {
            return startChildWorkflowExecutionFailedEventAttributes;
        }

        @Override
        public final Builder startChildWorkflowExecutionFailedEventAttributes(
                StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes) {
            this.startChildWorkflowExecutionFailedEventAttributes = startChildWorkflowExecutionFailedEventAttributes;
            return this;
        }

        public final void setStartChildWorkflowExecutionFailedEventAttributes(
                StartChildWorkflowExecutionFailedEventAttributes startChildWorkflowExecutionFailedEventAttributes) {
            this.startChildWorkflowExecutionFailedEventAttributes = startChildWorkflowExecutionFailedEventAttributes;
        }

        public final LambdaFunctionScheduledEventAttributes getLambdaFunctionScheduledEventAttributes() {
            return lambdaFunctionScheduledEventAttributes;
        }

        @Override
        public final Builder lambdaFunctionScheduledEventAttributes(
                LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes) {
            this.lambdaFunctionScheduledEventAttributes = lambdaFunctionScheduledEventAttributes;
            return this;
        }

        public final void setLambdaFunctionScheduledEventAttributes(
                LambdaFunctionScheduledEventAttributes lambdaFunctionScheduledEventAttributes) {
            this.lambdaFunctionScheduledEventAttributes = lambdaFunctionScheduledEventAttributes;
        }

        public final LambdaFunctionStartedEventAttributes getLambdaFunctionStartedEventAttributes() {
            return lambdaFunctionStartedEventAttributes;
        }

        @Override
        public final Builder lambdaFunctionStartedEventAttributes(
                LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes) {
            this.lambdaFunctionStartedEventAttributes = lambdaFunctionStartedEventAttributes;
            return this;
        }

        public final void setLambdaFunctionStartedEventAttributes(
                LambdaFunctionStartedEventAttributes lambdaFunctionStartedEventAttributes) {
            this.lambdaFunctionStartedEventAttributes = lambdaFunctionStartedEventAttributes;
        }

        public final LambdaFunctionCompletedEventAttributes getLambdaFunctionCompletedEventAttributes() {
            return lambdaFunctionCompletedEventAttributes;
        }

        @Override
        public final Builder lambdaFunctionCompletedEventAttributes(
                LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes) {
            this.lambdaFunctionCompletedEventAttributes = lambdaFunctionCompletedEventAttributes;
            return this;
        }

        public final void setLambdaFunctionCompletedEventAttributes(
                LambdaFunctionCompletedEventAttributes lambdaFunctionCompletedEventAttributes) {
            this.lambdaFunctionCompletedEventAttributes = lambdaFunctionCompletedEventAttributes;
        }

        public final LambdaFunctionFailedEventAttributes getLambdaFunctionFailedEventAttributes() {
            return lambdaFunctionFailedEventAttributes;
        }

        @Override
        public final Builder lambdaFunctionFailedEventAttributes(
                LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes) {
            this.lambdaFunctionFailedEventAttributes = lambdaFunctionFailedEventAttributes;
            return this;
        }

        public final void setLambdaFunctionFailedEventAttributes(
                LambdaFunctionFailedEventAttributes lambdaFunctionFailedEventAttributes) {
            this.lambdaFunctionFailedEventAttributes = lambdaFunctionFailedEventAttributes;
        }

        public final LambdaFunctionTimedOutEventAttributes getLambdaFunctionTimedOutEventAttributes() {
            return lambdaFunctionTimedOutEventAttributes;
        }

        @Override
        public final Builder lambdaFunctionTimedOutEventAttributes(
                LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes) {
            this.lambdaFunctionTimedOutEventAttributes = lambdaFunctionTimedOutEventAttributes;
            return this;
        }

        public final void setLambdaFunctionTimedOutEventAttributes(
                LambdaFunctionTimedOutEventAttributes lambdaFunctionTimedOutEventAttributes) {
            this.lambdaFunctionTimedOutEventAttributes = lambdaFunctionTimedOutEventAttributes;
        }

        public final ScheduleLambdaFunctionFailedEventAttributes getScheduleLambdaFunctionFailedEventAttributes() {
            return scheduleLambdaFunctionFailedEventAttributes;
        }

        @Override
        public final Builder scheduleLambdaFunctionFailedEventAttributes(
                ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes) {
            this.scheduleLambdaFunctionFailedEventAttributes = scheduleLambdaFunctionFailedEventAttributes;
            return this;
        }

        public final void setScheduleLambdaFunctionFailedEventAttributes(
                ScheduleLambdaFunctionFailedEventAttributes scheduleLambdaFunctionFailedEventAttributes) {
            this.scheduleLambdaFunctionFailedEventAttributes = scheduleLambdaFunctionFailedEventAttributes;
        }

        public final StartLambdaFunctionFailedEventAttributes getStartLambdaFunctionFailedEventAttributes() {
            return startLambdaFunctionFailedEventAttributes;
        }

        @Override
        public final Builder startLambdaFunctionFailedEventAttributes(
                StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes) {
            this.startLambdaFunctionFailedEventAttributes = startLambdaFunctionFailedEventAttributes;
            return this;
        }

        public final void setStartLambdaFunctionFailedEventAttributes(
                StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedEventAttributes) {
            this.startLambdaFunctionFailedEventAttributes = startLambdaFunctionFailedEventAttributes;
        }

        @Override
        public HistoryEvent build() {
            return new HistoryEvent(this);
        }
    }
}
