/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated collection of DomainInfo structures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDomainsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDomainsResponse.Builder, ListDomainsResponse> {
    private final List<DomainInfo> domainInfos;

    private final String nextPageToken;

    private ListDomainsResponse(BuilderImpl builder) {
        this.domainInfos = builder.domainInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * A list of DomainInfo structures.
     * </p>
     * 
     * @return A list of DomainInfo structures.
     */
    public List<DomainInfo> domainInfos() {
        return domainInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainInfos() == null) ? 0 : domainInfos().hashCode());
        hashCode = 31 * hashCode + ((nextPageToken() == null) ? 0 : nextPageToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse) obj;
        if (other.domainInfos() == null ^ this.domainInfos() == null) {
            return false;
        }
        if (other.domainInfos() != null && !other.domainInfos().equals(this.domainInfos())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        if (other.nextPageToken() != null && !other.nextPageToken().equals(this.nextPageToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainInfos() != null) {
            sb.append("DomainInfos: ").append(domainInfos()).append(",");
        }
        if (nextPageToken() != null) {
            sb.append("NextPageToken: ").append(nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDomainsResponse> {
        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * 
         * @param domainInfos
         *        A list of DomainInfo structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfos(Collection<DomainInfo> domainInfos);

        /**
         * <p>
         * A list of DomainInfo structures.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDomainInfos(java.util.Collection)} or {@link #withDomainInfos(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param domainInfos
         *        A list of DomainInfo structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainInfos(DomainInfo... domainInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<DomainInfo> domainInfos;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            setDomainInfos(model.domainInfos);
            setNextPageToken(model.nextPageToken);
        }

        public final Collection<DomainInfo> getDomainInfos() {
            return domainInfos;
        }

        @Override
        public final Builder domainInfos(Collection<DomainInfo> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copy(domainInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainInfos(DomainInfo... domainInfos) {
            if (this.domainInfos == null) {
                this.domainInfos = new ArrayList<>(domainInfos.length);
            }
            for (DomainInfo e : domainInfos) {
                this.domainInfos.add(e);
            }
            return this;
        }

        public final void setDomainInfos(Collection<DomainInfo> domainInfos) {
            this.domainInfos = DomainInfoListCopier.copy(domainInfos);
        }

        @SafeVarargs
        public final void setDomainInfos(DomainInfo... domainInfos) {
            if (this.domainInfos == null) {
                this.domainInfos = new ArrayList<>(domainInfos.length);
            }
            for (DomainInfo e : domainInfos) {
                this.domainInfos.add(e);
            }
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }
    }
}
