/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PollForActivityTaskRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PollForActivityTaskRequest.Builder, PollForActivityTaskRequest> {
    private final String domain;

    private final TaskList taskList;

    private final String identity;

    private PollForActivityTaskRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.taskList = builder.taskList;
        this.identity = builder.identity;
    }

    /**
     * <p>
     * The name of the domain that contains the task lists being polled.
     * </p>
     * 
     * @return The name of the domain that contains the task lists being polled.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * Specifies the task list to poll for activity tasks.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return Specifies the task list to poll for activity tasks.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * Identity of the worker making the request, recorded in the <code>ActivityTaskStarted</code> event in the workflow
     * history. This enables diagnostic tracing when problems arise. The form of this identity is user defined.
     * </p>
     * 
     * @return Identity of the worker making the request, recorded in the <code>ActivityTaskStarted</code> event in the
     *         workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user
     *         defined.
     */
    public String identity() {
        return identity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((identity() == null) ? 0 : identity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForActivityTaskRequest)) {
            return false;
        }
        PollForActivityTaskRequest other = (PollForActivityTaskRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PollForActivityTaskRequest> {
        /**
         * <p>
         * The name of the domain that contains the task lists being polled.
         * </p>
         * 
         * @param domain
         *        The name of the domain that contains the task lists being polled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specifies the task list to poll for activity tasks.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param taskList
         *        Specifies the task list to poll for activity tasks.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * Identity of the worker making the request, recorded in the <code>ActivityTaskStarted</code> event in the
         * workflow history. This enables diagnostic tracing when problems arise. The form of this identity is user
         * defined.
         * </p>
         * 
         * @param identity
         *        Identity of the worker making the request, recorded in the <code>ActivityTaskStarted</code> event in
         *        the workflow history. This enables diagnostic tracing when problems arise. The form of this identity
         *        is user defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private TaskList taskList;

        private String identity;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForActivityTaskRequest model) {
            setDomain(model.domain);
            setTaskList(model.taskList);
            setIdentity(model.identity);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public PollForActivityTaskRequest build() {
            return new PollForActivityTaskRequest(this);
        }
    }
}
