/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Unit of work sent to an activity worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PollForActivityTaskResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PollForActivityTaskResponse.Builder, PollForActivityTaskResponse> {
    private final String taskToken;

    private final String activityId;

    private final Long startedEventId;

    private final WorkflowExecution workflowExecution;

    private final ActivityType activityType;

    private final String input;

    private PollForActivityTaskResponse(BuilderImpl builder) {
        this.taskToken = builder.taskToken;
        this.activityId = builder.activityId;
        this.startedEventId = builder.startedEventId;
        this.workflowExecution = builder.workflowExecution;
        this.activityType = builder.activityType;
        this.input = builder.input;
    }

    /**
     * <p>
     * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     * response information back to the system about the task.
     * </p>
     * 
     * @return The opaque string used as a handle on the task. This token is used by workers to communicate progress and
     *         response information back to the system about the task.
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * The unique ID of the task.
     * </p>
     * 
     * @return The unique ID of the task.
     */
    public String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
     * </p>
     * 
     * @return The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The workflow execution that started this activity task.
     * </p>
     * 
     * @return The workflow execution that started this activity task.
     */
    public WorkflowExecution workflowExecution() {
        return workflowExecution;
    }

    /**
     * <p>
     * The type of this activity task.
     * </p>
     * 
     * @return The type of this activity task.
     */
    public ActivityType activityType() {
        return activityType;
    }

    /**
     * <p>
     * The inputs provided when the activity task was scheduled. The form of the input is user defined and should be
     * meaningful to the activity implementation.
     * </p>
     * 
     * @return The inputs provided when the activity task was scheduled. The form of the input is user defined and
     *         should be meaningful to the activity implementation.
     */
    public String input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskToken() == null) ? 0 : taskToken().hashCode());
        hashCode = 31 * hashCode + ((activityId() == null) ? 0 : activityId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        hashCode = 31 * hashCode + ((workflowExecution() == null) ? 0 : workflowExecution().hashCode());
        hashCode = 31 * hashCode + ((activityType() == null) ? 0 : activityType().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForActivityTaskResponse)) {
            return false;
        }
        PollForActivityTaskResponse other = (PollForActivityTaskResponse) obj;
        if (other.taskToken() == null ^ this.taskToken() == null) {
            return false;
        }
        if (other.taskToken() != null && !other.taskToken().equals(this.taskToken())) {
            return false;
        }
        if (other.activityId() == null ^ this.activityId() == null) {
            return false;
        }
        if (other.activityId() != null && !other.activityId().equals(this.activityId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        if (other.workflowExecution() == null ^ this.workflowExecution() == null) {
            return false;
        }
        if (other.workflowExecution() != null && !other.workflowExecution().equals(this.workflowExecution())) {
            return false;
        }
        if (other.activityType() == null ^ this.activityType() == null) {
            return false;
        }
        if (other.activityType() != null && !other.activityType().equals(this.activityType())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskToken() != null) {
            sb.append("TaskToken: ").append(taskToken()).append(",");
        }
        if (activityId() != null) {
            sb.append("ActivityId: ").append(activityId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        if (workflowExecution() != null) {
            sb.append("WorkflowExecution: ").append(workflowExecution()).append(",");
        }
        if (activityType() != null) {
            sb.append("ActivityType: ").append(activityType()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PollForActivityTaskResponse> {
        /**
         * <p>
         * The opaque string used as a handle on the task. This token is used by workers to communicate progress and
         * response information back to the system about the task.
         * </p>
         * 
         * @param taskToken
         *        The opaque string used as a handle on the task. This token is used by workers to communicate progress
         *        and response information back to the system about the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * The unique ID of the task.
         * </p>
         * 
         * @param activityId
         *        The unique ID of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>ActivityTaskStarted</code> event recorded in the history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The workflow execution that started this activity task.
         * </p>
         * 
         * @param workflowExecution
         *        The workflow execution that started this activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecution(WorkflowExecution workflowExecution);

        /**
         * <p>
         * The type of this activity task.
         * </p>
         * 
         * @param activityType
         *        The type of this activity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityType(ActivityType activityType);

        /**
         * <p>
         * The inputs provided when the activity task was scheduled. The form of the input is user defined and should be
         * meaningful to the activity implementation.
         * </p>
         * 
         * @param input
         *        The inputs provided when the activity task was scheduled. The form of the input is user defined and
         *        should be meaningful to the activity implementation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);
    }

    private static final class BuilderImpl implements Builder {
        private String taskToken;

        private String activityId;

        private Long startedEventId;

        private WorkflowExecution workflowExecution;

        private ActivityType activityType;

        private String input;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForActivityTaskResponse model) {
            setTaskToken(model.taskToken);
            setActivityId(model.activityId);
            setStartedEventId(model.startedEventId);
            setWorkflowExecution(model.workflowExecution);
            setActivityType(model.activityType);
            setInput(model.input);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final String getActivityId() {
            return activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final WorkflowExecution getWorkflowExecution() {
            return workflowExecution;
        }

        @Override
        public final Builder workflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
            return this;
        }

        public final void setWorkflowExecution(WorkflowExecution workflowExecution) {
            this.workflowExecution = workflowExecution;
        }

        public final ActivityType getActivityType() {
            return activityType;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        public final void setActivityType(ActivityType activityType) {
            this.activityType = activityType;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public PollForActivityTaskResponse build() {
            return new PollForActivityTaskResponse(this);
        }
    }
}
