/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about an activity task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecordActivityTaskHeartbeatResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RecordActivityTaskHeartbeatResponse.Builder, RecordActivityTaskHeartbeatResponse> {
    private final Boolean cancelRequested;

    private RecordActivityTaskHeartbeatResponse(BuilderImpl builder) {
        this.cancelRequested = builder.cancelRequested;
    }

    /**
     * <p>
     * Set to <code>true</code> if cancellation of the task is requested.
     * </p>
     * 
     * @return Set to <code>true</code> if cancellation of the task is requested.
     */
    public Boolean cancelRequested() {
        return cancelRequested;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cancelRequested() == null) ? 0 : cancelRequested().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordActivityTaskHeartbeatResponse)) {
            return false;
        }
        RecordActivityTaskHeartbeatResponse other = (RecordActivityTaskHeartbeatResponse) obj;
        if (other.cancelRequested() == null ^ this.cancelRequested() == null) {
            return false;
        }
        if (other.cancelRequested() != null && !other.cancelRequested().equals(this.cancelRequested())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cancelRequested() != null) {
            sb.append("CancelRequested: ").append(cancelRequested()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RecordActivityTaskHeartbeatResponse> {
        /**
         * <p>
         * Set to <code>true</code> if cancellation of the task is requested.
         * </p>
         * 
         * @param cancelRequested
         *        Set to <code>true</code> if cancellation of the task is requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelRequested(Boolean cancelRequested);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean cancelRequested;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordActivityTaskHeartbeatResponse model) {
            setCancelRequested(model.cancelRequested);
        }

        public final Boolean getCancelRequested() {
            return cancelRequested;
        }

        @Override
        public final Builder cancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
            return this;
        }

        public final void setCancelRequested(Boolean cancelRequested) {
            this.cancelRequested = cancelRequested;
        }

        @Override
        public RecordActivityTaskHeartbeatResponse build() {
            return new RecordActivityTaskHeartbeatResponse(this);
        }
    }
}
