/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.RecordMarkerDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>RecordMarker</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecordMarkerDecisionAttributes implements StructuredPojo,
        ToCopyableBuilder<RecordMarkerDecisionAttributes.Builder, RecordMarkerDecisionAttributes> {
    private final String markerName;

    private final String details;

    private RecordMarkerDecisionAttributes(BuilderImpl builder) {
        this.markerName = builder.markerName;
        this.details = builder.details;
    }

    /**
     * <p>
     * <b>Required.</b> The name of the marker.
     * </p>
     * 
     * @return Required.
     */
    public String markerName() {
        return markerName;
    }

    /**
     * <p>
     * <i>Optional.</i> details of the marker.
     * </p>
     * 
     * @return Optional.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((markerName() == null) ? 0 : markerName().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordMarkerDecisionAttributes)) {
            return false;
        }
        RecordMarkerDecisionAttributes other = (RecordMarkerDecisionAttributes) obj;
        if (other.markerName() == null ^ this.markerName() == null) {
            return false;
        }
        if (other.markerName() != null && !other.markerName().equals(this.markerName())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (markerName() != null) {
            sb.append("MarkerName: ").append(markerName()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarkerDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RecordMarkerDecisionAttributes> {
        /**
         * <p>
         * <b>Required.</b> The name of the marker.
         * </p>
         * 
         * @param markerName
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markerName(String markerName);

        /**
         * <p>
         * <i>Optional.</i> details of the marker.
         * </p>
         * 
         * @param details
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    private static final class BuilderImpl implements Builder {
        private String markerName;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordMarkerDecisionAttributes model) {
            setMarkerName(model.markerName);
            setDetails(model.details);
        }

        public final String getMarkerName() {
            return markerName;
        }

        @Override
        public final Builder markerName(String markerName) {
            this.markerName = markerName;
            return this;
        }

        public final void setMarkerName(String markerName) {
            this.markerName = markerName;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public RecordMarkerDecisionAttributes build() {
            return new RecordMarkerDecisionAttributes(this);
        }
    }
}
