/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterActivityTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterActivityTypeRequest.Builder, RegisterActivityTypeRequest> {
    private final String domain;

    private final String name;

    private final String version;

    private final String description;

    private final String defaultTaskStartToCloseTimeout;

    private final String defaultTaskHeartbeatTimeout;

    private final TaskList defaultTaskList;

    private final String defaultTaskPriority;

    private final String defaultTaskScheduleToStartTimeout;

    private final String defaultTaskScheduleToCloseTimeout;

    private RegisterActivityTypeRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.defaultTaskStartToCloseTimeout = builder.defaultTaskStartToCloseTimeout;
        this.defaultTaskHeartbeatTimeout = builder.defaultTaskHeartbeatTimeout;
        this.defaultTaskList = builder.defaultTaskList;
        this.defaultTaskPriority = builder.defaultTaskPriority;
        this.defaultTaskScheduleToStartTimeout = builder.defaultTaskScheduleToStartTimeout;
        this.defaultTaskScheduleToCloseTimeout = builder.defaultTaskScheduleToCloseTimeout;
    }

    /**
     * <p>
     * The name of the domain in which this activity is to be registered.
     * </p>
     * 
     * @return The name of the domain in which this activity is to be registered.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The name of the activity type within the domain.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return The name of the activity type within the domain.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The version of the activity type.
     * </p>
     * <note>The activity type consists of the name and version, the combination of which must be unique within the
     * domain.</note>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return The version of the activity type.</p> <note>The activity type consists of the name and version, the
     *         combination of which must be unique within the domain.</note>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * A textual description of the activity type.
     * </p>
     * 
     * @return A textual description of the activity type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration that a worker can take to process tasks of this activity type.
     * This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
     * decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration that a worker can take to process tasks of this activity
     *         type. This default can be overridden when scheduling an activity task using the
     *         <code>ScheduleActivityTask</code> decision.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String defaultTaskStartToCloseTimeout() {
        return defaultTaskStartToCloseTimeout;
    }

    /**
     * <p>
     * If set, specifies the default maximum time before which a worker processing a task of this type must report
     * progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is
     * automatically timed out. This default can be overridden when scheduling an activity task using the
     * <code>ScheduleActivityTask</code> decision. If the activity worker subsequently attempts to record a heartbeat or
     * returns a result, the activity worker receives an <code>UnknownResource</code> fault. In this case, Amazon SWF no
     * longer considers the activity task to be valid; the activity worker should clean up the activity task.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum time before which a worker processing a task of this type must
     *         report progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity
     *         task is automatically timed out. This default can be overridden when scheduling an activity task using
     *         the <code>ScheduleActivityTask</code> decision. If the activity worker subsequently attempts to record a
     *         heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In
     *         this case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean
     *         up the activity task.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String defaultTaskHeartbeatTimeout() {
        return defaultTaskHeartbeatTimeout;
    }

    /**
     * <p>
     * If set, specifies the default task list to use for scheduling tasks of this activity type. This default task list
     * is used if a task list is not provided when a task is scheduled through the <code>ScheduleActivityTask</code>
     * decision.
     * </p>
     * 
     * @return If set, specifies the default task list to use for scheduling tasks of this activity type. This default
     *         task list is used if a task list is not provided when a task is scheduled through the
     *         <code>ScheduleActivityTask</code> decision.
     */
    public TaskList defaultTaskList() {
        return defaultTaskList;
    }

    /**
     * <p>
     * The default task priority to assign to the activity type. If not assigned, then "0" will be used. Valid values
     * are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return The default task priority to assign to the activity type. If not assigned, then "0" will be used. Valid
     *         values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     */
    public String defaultTaskPriority() {
        return defaultTaskPriority;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration that a task of this activity type can wait before being assigned
     * to a worker. This default can be overridden when scheduling an activity task using the
     * <code>ScheduleActivityTask</code> decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration that a task of this activity type can wait before being
     *         assigned to a worker. This default can be overridden when scheduling an activity task using the
     *         <code>ScheduleActivityTask</code> decision.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String defaultTaskScheduleToStartTimeout() {
        return defaultTaskScheduleToStartTimeout;
    }

    /**
     * <p>
     * If set, specifies the default maximum duration for a task of this activity type. This default can be overridden
     * when scheduling an activity task using the <code>ScheduleActivityTask</code> decision.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return If set, specifies the default maximum duration for a task of this activity type. This default can be
     *         overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> decision.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String defaultTaskScheduleToCloseTimeout() {
        return defaultTaskScheduleToCloseTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskStartToCloseTimeout() == null) ? 0 : defaultTaskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskHeartbeatTimeout() == null) ? 0 : defaultTaskHeartbeatTimeout().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskList() == null) ? 0 : defaultTaskList().hashCode());
        hashCode = 31 * hashCode + ((defaultTaskPriority() == null) ? 0 : defaultTaskPriority().hashCode());
        hashCode = 31 * hashCode
                + ((defaultTaskScheduleToStartTimeout() == null) ? 0 : defaultTaskScheduleToStartTimeout().hashCode());
        hashCode = 31 * hashCode
                + ((defaultTaskScheduleToCloseTimeout() == null) ? 0 : defaultTaskScheduleToCloseTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterActivityTypeRequest)) {
            return false;
        }
        RegisterActivityTypeRequest other = (RegisterActivityTypeRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.defaultTaskStartToCloseTimeout() == null ^ this.defaultTaskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultTaskStartToCloseTimeout() != null
                && !other.defaultTaskStartToCloseTimeout().equals(this.defaultTaskStartToCloseTimeout())) {
            return false;
        }
        if (other.defaultTaskHeartbeatTimeout() == null ^ this.defaultTaskHeartbeatTimeout() == null) {
            return false;
        }
        if (other.defaultTaskHeartbeatTimeout() != null
                && !other.defaultTaskHeartbeatTimeout().equals(this.defaultTaskHeartbeatTimeout())) {
            return false;
        }
        if (other.defaultTaskList() == null ^ this.defaultTaskList() == null) {
            return false;
        }
        if (other.defaultTaskList() != null && !other.defaultTaskList().equals(this.defaultTaskList())) {
            return false;
        }
        if (other.defaultTaskPriority() == null ^ this.defaultTaskPriority() == null) {
            return false;
        }
        if (other.defaultTaskPriority() != null && !other.defaultTaskPriority().equals(this.defaultTaskPriority())) {
            return false;
        }
        if (other.defaultTaskScheduleToStartTimeout() == null ^ this.defaultTaskScheduleToStartTimeout() == null) {
            return false;
        }
        if (other.defaultTaskScheduleToStartTimeout() != null
                && !other.defaultTaskScheduleToStartTimeout().equals(this.defaultTaskScheduleToStartTimeout())) {
            return false;
        }
        if (other.defaultTaskScheduleToCloseTimeout() == null ^ this.defaultTaskScheduleToCloseTimeout() == null) {
            return false;
        }
        if (other.defaultTaskScheduleToCloseTimeout() != null
                && !other.defaultTaskScheduleToCloseTimeout().equals(this.defaultTaskScheduleToCloseTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (defaultTaskStartToCloseTimeout() != null) {
            sb.append("DefaultTaskStartToCloseTimeout: ").append(defaultTaskStartToCloseTimeout()).append(",");
        }
        if (defaultTaskHeartbeatTimeout() != null) {
            sb.append("DefaultTaskHeartbeatTimeout: ").append(defaultTaskHeartbeatTimeout()).append(",");
        }
        if (defaultTaskList() != null) {
            sb.append("DefaultTaskList: ").append(defaultTaskList()).append(",");
        }
        if (defaultTaskPriority() != null) {
            sb.append("DefaultTaskPriority: ").append(defaultTaskPriority()).append(",");
        }
        if (defaultTaskScheduleToStartTimeout() != null) {
            sb.append("DefaultTaskScheduleToStartTimeout: ").append(defaultTaskScheduleToStartTimeout()).append(",");
        }
        if (defaultTaskScheduleToCloseTimeout() != null) {
            sb.append("DefaultTaskScheduleToCloseTimeout: ").append(defaultTaskScheduleToCloseTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterActivityTypeRequest> {
        /**
         * <p>
         * The name of the domain in which this activity is to be registered.
         * </p>
         * 
         * @param domain
         *        The name of the domain in which this activity is to be registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The name of the activity type within the domain.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param name
         *        The name of the activity type within the domain.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the activity type.
         * </p>
         * <note>The activity type consists of the name and version, the combination of which must be unique within the
         * domain.</note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param version
         *        The version of the activity type.</p> <note>The activity type consists of the name and version, the
         *        combination of which must be unique within the domain.</note>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * A textual description of the activity type.
         * </p>
         * 
         * @param description
         *        A textual description of the activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If set, specifies the default maximum duration that a worker can take to process tasks of this activity type.
         * This default can be overridden when scheduling an activity task using the <code>ScheduleActivityTask</code>
         * decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskStartToCloseTimeout
         *        If set, specifies the default maximum duration that a worker can take to process tasks of this
         *        activity type. This default can be overridden when scheduling an activity task using the
         *        <code>ScheduleActivityTask</code> decision.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout);

        /**
         * <p>
         * If set, specifies the default maximum time before which a worker processing a task of this type must report
         * progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the activity task is
         * automatically timed out. This default can be overridden when scheduling an activity task using the
         * <code>ScheduleActivityTask</code> decision. If the activity worker subsequently attempts to record a
         * heartbeat or returns a result, the activity worker receives an <code>UnknownResource</code> fault. In this
         * case, Amazon SWF no longer considers the activity task to be valid; the activity worker should clean up the
         * activity task.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskHeartbeatTimeout
         *        If set, specifies the default maximum time before which a worker processing a task of this type must
         *        report progress by calling <a>RecordActivityTaskHeartbeat</a>. If the timeout is exceeded, the
         *        activity task is automatically timed out. This default can be overridden when scheduling an activity
         *        task using the <code>ScheduleActivityTask</code> decision. If the activity worker subsequently
         *        attempts to record a heartbeat or returns a result, the activity worker receives an
         *        <code>UnknownResource</code> fault. In this case, Amazon SWF no longer considers the activity task to
         *        be valid; the activity worker should clean up the activity task.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout);

        /**
         * <p>
         * If set, specifies the default task list to use for scheduling tasks of this activity type. This default task
         * list is used if a task list is not provided when a task is scheduled through the
         * <code>ScheduleActivityTask</code> decision.
         * </p>
         * 
         * @param defaultTaskList
         *        If set, specifies the default task list to use for scheduling tasks of this activity type. This
         *        default task list is used if a task list is not provided when a task is scheduled through the
         *        <code>ScheduleActivityTask</code> decision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskList(TaskList defaultTaskList);

        /**
         * <p>
         * The default task priority to assign to the activity type. If not assigned, then "0" will be used. Valid
         * values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param defaultTaskPriority
         *        The default task priority to assign to the activity type. If not assigned, then "0" will be used.
         *        Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskPriority(String defaultTaskPriority);

        /**
         * <p>
         * If set, specifies the default maximum duration that a task of this activity type can wait before being
         * assigned to a worker. This default can be overridden when scheduling an activity task using the
         * <code>ScheduleActivityTask</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToStartTimeout
         *        If set, specifies the default maximum duration that a task of this activity type can wait before being
         *        assigned to a worker. This default can be overridden when scheduling an activity task using the
         *        <code>ScheduleActivityTask</code> decision.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout);

        /**
         * <p>
         * If set, specifies the default maximum duration for a task of this activity type. This default can be
         * overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> decision.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param defaultTaskScheduleToCloseTimeout
         *        If set, specifies the default maximum duration for a task of this activity type. This default can be
         *        overridden when scheduling an activity task using the <code>ScheduleActivityTask</code> decision.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private String name;

        private String version;

        private String description;

        private String defaultTaskStartToCloseTimeout;

        private String defaultTaskHeartbeatTimeout;

        private TaskList defaultTaskList;

        private String defaultTaskPriority;

        private String defaultTaskScheduleToStartTimeout;

        private String defaultTaskScheduleToCloseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterActivityTypeRequest model) {
            setDomain(model.domain);
            setName(model.name);
            setVersion(model.version);
            setDescription(model.description);
            setDefaultTaskStartToCloseTimeout(model.defaultTaskStartToCloseTimeout);
            setDefaultTaskHeartbeatTimeout(model.defaultTaskHeartbeatTimeout);
            setDefaultTaskList(model.defaultTaskList);
            setDefaultTaskPriority(model.defaultTaskPriority);
            setDefaultTaskScheduleToStartTimeout(model.defaultTaskScheduleToStartTimeout);
            setDefaultTaskScheduleToCloseTimeout(model.defaultTaskScheduleToCloseTimeout);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultTaskStartToCloseTimeout() {
            return defaultTaskStartToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskStartToCloseTimeout(String defaultTaskStartToCloseTimeout) {
            this.defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout;
        }

        public final String getDefaultTaskHeartbeatTimeout() {
            return defaultTaskHeartbeatTimeout;
        }

        @Override
        public final Builder defaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
            return this;
        }

        public final void setDefaultTaskHeartbeatTimeout(String defaultTaskHeartbeatTimeout) {
            this.defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout;
        }

        public final TaskList getDefaultTaskList() {
            return defaultTaskList;
        }

        @Override
        public final Builder defaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
            return this;
        }

        public final void setDefaultTaskList(TaskList defaultTaskList) {
            this.defaultTaskList = defaultTaskList;
        }

        public final String getDefaultTaskPriority() {
            return defaultTaskPriority;
        }

        @Override
        public final Builder defaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
            return this;
        }

        public final void setDefaultTaskPriority(String defaultTaskPriority) {
            this.defaultTaskPriority = defaultTaskPriority;
        }

        public final String getDefaultTaskScheduleToStartTimeout() {
            return defaultTaskScheduleToStartTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
            return this;
        }

        public final void setDefaultTaskScheduleToStartTimeout(String defaultTaskScheduleToStartTimeout) {
            this.defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout;
        }

        public final String getDefaultTaskScheduleToCloseTimeout() {
            return defaultTaskScheduleToCloseTimeout;
        }

        @Override
        public final Builder defaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
            return this;
        }

        public final void setDefaultTaskScheduleToCloseTimeout(String defaultTaskScheduleToCloseTimeout) {
            this.defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout;
        }

        @Override
        public RegisterActivityTypeRequest build() {
            return new RegisterActivityTypeRequest(this);
        }
    }
}
