/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.RequestCancelActivityTaskDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>RequestCancelActivityTask</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestCancelActivityTaskDecisionAttributes implements StructuredPojo,
        ToCopyableBuilder<RequestCancelActivityTaskDecisionAttributes.Builder, RequestCancelActivityTaskDecisionAttributes> {
    private final String activityId;

    private RequestCancelActivityTaskDecisionAttributes(BuilderImpl builder) {
        this.activityId = builder.activityId;
    }

    /**
     * <p>
     * The <code>activityId</code> of the activity task to be canceled.
     * </p>
     * 
     * @return The <code>activityId</code> of the activity task to be canceled.
     */
    public String activityId() {
        return activityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activityId() == null) ? 0 : activityId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCancelActivityTaskDecisionAttributes)) {
            return false;
        }
        RequestCancelActivityTaskDecisionAttributes other = (RequestCancelActivityTaskDecisionAttributes) obj;
        if (other.activityId() == null ^ this.activityId() == null) {
            return false;
        }
        if (other.activityId() != null && !other.activityId().equals(this.activityId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activityId() != null) {
            sb.append("ActivityId: ").append(activityId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RequestCancelActivityTaskDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RequestCancelActivityTaskDecisionAttributes> {
        /**
         * <p>
         * The <code>activityId</code> of the activity task to be canceled.
         * </p>
         * 
         * @param activityId
         *        The <code>activityId</code> of the activity task to be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);
    }

    private static final class BuilderImpl implements Builder {
        private String activityId;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestCancelActivityTaskDecisionAttributes model) {
            setActivityId(model.activityId);
        }

        public final String getActivityId() {
            return activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @Override
        public RequestCancelActivityTaskDecisionAttributes build() {
            return new RequestCancelActivityTaskDecisionAttributes(this);
        }
    }
}
