/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestCancelWorkflowExecutionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RequestCancelWorkflowExecutionRequest.Builder, RequestCancelWorkflowExecutionRequest> {
    private final String domain;

    private final String workflowId;

    private final String runId;

    private RequestCancelWorkflowExecutionRequest(BuilderImpl builder) {
        this.domain = builder.domain;
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
    }

    /**
     * <p>
     * The name of the domain containing the workflow execution to cancel.
     * </p>
     * 
     * @return The name of the domain containing the workflow execution to cancel.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The workflowId of the workflow execution to cancel.
     * </p>
     * 
     * @return The workflowId of the workflow execution to cancel.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The runId of the workflow execution to cancel.
     * </p>
     * 
     * @return The runId of the workflow execution to cancel.
     */
    public String runId() {
        return runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domain() == null) ? 0 : domain().hashCode());
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        hashCode = 31 * hashCode + ((runId() == null) ? 0 : runId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCancelWorkflowExecutionRequest)) {
            return false;
        }
        RequestCancelWorkflowExecutionRequest other = (RequestCancelWorkflowExecutionRequest) obj;
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.runId() == null ^ this.runId() == null) {
            return false;
        }
        if (other.runId() != null && !other.runId().equals(this.runId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domain() != null) {
            sb.append("Domain: ").append(domain()).append(",");
        }
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        if (runId() != null) {
            sb.append("RunId: ").append(runId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RequestCancelWorkflowExecutionRequest> {
        /**
         * <p>
         * The name of the domain containing the workflow execution to cancel.
         * </p>
         * 
         * @param domain
         *        The name of the domain containing the workflow execution to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The workflowId of the workflow execution to cancel.
         * </p>
         * 
         * @param workflowId
         *        The workflowId of the workflow execution to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The runId of the workflow execution to cancel.
         * </p>
         * 
         * @param runId
         *        The runId of the workflow execution to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);
    }

    private static final class BuilderImpl implements Builder {
        private String domain;

        private String workflowId;

        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestCancelWorkflowExecutionRequest model) {
            setDomain(model.domain);
            setWorkflowId(model.workflowId);
            setRunId(model.runId);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public RequestCancelWorkflowExecutionRequest build() {
            return new RequestCancelWorkflowExecutionRequest(this);
        }
    }
}
