/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RespondActivityTaskFailedRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RespondActivityTaskFailedRequest.Builder, RespondActivityTaskFailedRequest> {
    private final String taskToken;

    private final String reason;

    private final String details;

    private RespondActivityTaskFailedRequest(BuilderImpl builder) {
        this.taskToken = builder.taskToken;
        this.reason = builder.reason;
        this.details = builder.details;
    }

    /**
     * <p>
     * The <code>taskToken</code> of the <a>ActivityTask</a>.
     * </p>
     * <important> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If the
     * task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to provide its
     * progress and respond with results.</important>
     * 
     * @return The <code>taskToken</code> of the <a>ActivityTask</a>.</p> <important> <code>taskToken</code> is
     *         generated by the service and should be treated as an opaque value. If the task is passed to another
     *         process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and
     *         respond with results.
     */
    public String taskToken() {
        return taskToken;
    }

    /**
     * <p>
     * Description of the error that may assist in diagnostics.
     * </p>
     * 
     * @return Description of the error that may assist in diagnostics.
     */
    public String reason() {
        return reason;
    }

    /**
     * <p>
     * <i>Optional.</i> Detailed information about the failure.
     * </p>
     * 
     * @return Optional.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskToken() == null) ? 0 : taskToken().hashCode());
        hashCode = 31 * hashCode + ((reason() == null) ? 0 : reason().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondActivityTaskFailedRequest)) {
            return false;
        }
        RespondActivityTaskFailedRequest other = (RespondActivityTaskFailedRequest) obj;
        if (other.taskToken() == null ^ this.taskToken() == null) {
            return false;
        }
        if (other.taskToken() != null && !other.taskToken().equals(this.taskToken())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskToken() != null) {
            sb.append("TaskToken: ").append(taskToken()).append(",");
        }
        if (reason() != null) {
            sb.append("Reason: ").append(reason()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RespondActivityTaskFailedRequest> {
        /**
         * <p>
         * The <code>taskToken</code> of the <a>ActivityTask</a>.
         * </p>
         * <important> <code>taskToken</code> is generated by the service and should be treated as an opaque value. If
         * the task is passed to another process, its <code>taskToken</code> must also be passed. This enables it to
         * provide its progress and respond with results.</important>
         * 
         * @param taskToken
         *        The <code>taskToken</code> of the <a>ActivityTask</a>.</p> <important> <code>taskToken</code> is
         *        generated by the service and should be treated as an opaque value. If the task is passed to another
         *        process, its <code>taskToken</code> must also be passed. This enables it to provide its progress and
         *        respond with results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskToken(String taskToken);

        /**
         * <p>
         * Description of the error that may assist in diagnostics.
         * </p>
         * 
         * @param reason
         *        Description of the error that may assist in diagnostics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * <i>Optional.</i> Detailed information about the failure.
         * </p>
         * 
         * @param details
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    private static final class BuilderImpl implements Builder {
        private String taskToken;

        private String reason;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondActivityTaskFailedRequest model) {
            setTaskToken(model.taskToken);
            setReason(model.reason);
            setDetails(model.details);
        }

        public final String getTaskToken() {
            return taskToken;
        }

        @Override
        public final Builder taskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public final void setTaskToken(String taskToken) {
            this.taskToken = taskToken;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public RespondActivityTaskFailedRequest build() {
            return new RespondActivityTaskFailedRequest(this);
        }
    }
}
