/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.ScheduleLambdaFunctionDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>ScheduleLambdaFunction</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
 * <ul>
 * <li><code>activityType.name</code>: String constraint. The key is <code>swf:activityType.name</code>.</li>
 * <li><code>activityType.version</code>: String constraint. The key is <code>swf:activityType.version</code>.</li>
 * <li><code>taskList</code>: String constraint. The key is <code>swf:taskList.name</code>.</li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleLambdaFunctionDecisionAttributes implements StructuredPojo,
        ToCopyableBuilder<ScheduleLambdaFunctionDecisionAttributes.Builder, ScheduleLambdaFunctionDecisionAttributes> {
    private final String id;

    private final String name;

    private final String input;

    private final String startToCloseTimeout;

    private ScheduleLambdaFunctionDecisionAttributes(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.input = builder.input;
        this.startToCloseTimeout = builder.startToCloseTimeout;
    }

    /**
     * <p>
     * <b>Required.</b> The SWF <code>id</code> of the AWS Lambda task.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return Required.</b> The SWF <code>id</code> of the AWS Lambda task.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * <b>Required.</b> The name of the AWS Lambda function to invoke.
     * </p>
     * 
     * @return Required.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The input provided to the AWS Lambda function.
     * </p>
     * 
     * @return The input provided to the AWS Lambda function.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * If set, specifies the maximum duration the function may take to execute.
     * </p>
     * 
     * @return If set, specifies the maximum duration the function may take to execute.
     */
    public String startToCloseTimeout() {
        return startToCloseTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((startToCloseTimeout() == null) ? 0 : startToCloseTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleLambdaFunctionDecisionAttributes)) {
            return false;
        }
        ScheduleLambdaFunctionDecisionAttributes other = (ScheduleLambdaFunctionDecisionAttributes) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.startToCloseTimeout() == null ^ this.startToCloseTimeout() == null) {
            return false;
        }
        if (other.startToCloseTimeout() != null && !other.startToCloseTimeout().equals(this.startToCloseTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (startToCloseTimeout() != null) {
            sb.append("StartToCloseTimeout: ").append(startToCloseTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleLambdaFunctionDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleLambdaFunctionDecisionAttributes> {
        /**
         * <p>
         * <b>Required.</b> The SWF <code>id</code> of the AWS Lambda task.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param id
         *        Required.</b> The SWF <code>id</code> of the AWS Lambda task.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * <b>Required.</b> The name of the AWS Lambda function to invoke.
         * </p>
         * 
         * @param name
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The input provided to the AWS Lambda function.
         * </p>
         * 
         * @param input
         *        The input provided to the AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * If set, specifies the maximum duration the function may take to execute.
         * </p>
         * 
         * @param startToCloseTimeout
         *        If set, specifies the maximum duration the function may take to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToCloseTimeout(String startToCloseTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String input;

        private String startToCloseTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleLambdaFunctionDecisionAttributes model) {
            setId(model.id);
            setName(model.name);
            setInput(model.input);
            setStartToCloseTimeout(model.startToCloseTimeout);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getStartToCloseTimeout() {
            return startToCloseTimeout;
        }

        @Override
        public final Builder startToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public final void setStartToCloseTimeout(String startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
        }

        @Override
        public ScheduleLambdaFunctionDecisionAttributes build() {
            return new ScheduleLambdaFunctionDecisionAttributes(this);
        }
    }
}
