/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.StartChildWorkflowExecutionDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>StartChildWorkflowExecution</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>Constrain the following parameters by using a <code>Condition</code> element with the appropriate keys.
 * <ul>
 * <li> <code>tagList.member.N</code>: The key is "swf:tagList.N" where N is the tag number from 0 to 4, inclusive.</li>
 * <li><code>taskList</code>: String constraint. The key is <code>swf:taskList.name</code>.</li>
 * <li><code>workflowType.name</code>: String constraint. The key is <code>swf:workflowType.name</code>.</li>
 * <li><code>workflowType.version</code>: String constraint. The key is <code>swf:workflowType.version</code>.</li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartChildWorkflowExecutionDecisionAttributes implements StructuredPojo,
        ToCopyableBuilder<StartChildWorkflowExecutionDecisionAttributes.Builder, StartChildWorkflowExecutionDecisionAttributes> {
    private final WorkflowType workflowType;

    private final String workflowId;

    private final String control;

    private final String input;

    private final String executionStartToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final String taskStartToCloseTimeout;

    private final String childPolicy;

    private final List<String> tagList;

    private final String lambdaRole;

    private StartChildWorkflowExecutionDecisionAttributes(BuilderImpl builder) {
        this.workflowType = builder.workflowType;
        this.workflowId = builder.workflowId;
        this.control = builder.control;
        this.input = builder.input;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.childPolicy = builder.childPolicy;
        this.tagList = builder.tagList;
        this.lambdaRole = builder.lambdaRole;
    }

    /**
     * <p>
     * <b>Required.</b> The type of the workflow execution to be started.
     * </p>
     * 
     * @return Required.
     */
    public WorkflowType workflowType() {
        return workflowType;
    }

    /**
     * <p>
     * <b>Required.</b> The <code>workflowId</code> of the workflow execution.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return Required.</b> The <code>workflowId</code> of the workflow execution.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks. This
     * data is not sent to the child workflow execution.
     * </p>
     * 
     * @return Optional.
     */
    public String control() {
        return control;
    }

    /**
     * <p>
     * The input to be provided to the workflow execution.
     * </p>
     * 
     * @return The input to be provided to the workflow execution.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified
     * when registering the workflow type.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * <note>An execution start-to-close timeout for this workflow execution must be specified either as a default for
     * the workflow type or through this parameter. If neither this parameter is set nor a default execution
     * start-to-close timeout was specified at registration time then a fault will be returned.</note>
     * 
     * @return The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
     *         specified when registering the workflow type.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     *         </p>
     *         <note>An execution start-to-close timeout for this workflow execution must be specified either as a
     *         default for the workflow type or through this parameter. If neither this parameter is set nor a default
     *         execution start-to-close timeout was specified at registration time then a fault will be returned.
     */
    public String executionStartToCloseTimeout() {
        return executionStartToCloseTimeout;
    }

    /**
     * <p>
     * The name of the task list to be used for decision tasks of the child workflow execution.
     * </p>
     * <note>A task list for this workflow execution must be specified either as a default for the workflow type or
     * through this parameter. If neither this parameter is set nor a default task list was specified at registration
     * time then a fault will be returned.</note>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return The name of the task list to be used for decision tasks of the child workflow execution.</p> <note>A task
     *         list for this workflow execution must be specified either as a default for the workflow type or through
     *         this parameter. If neither this parameter is set nor a default task list was specified at registration
     *         time then a fault will be returned.</note>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f
     *         - \u009f). Also, it must not contain the literal string quotarnquot.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * <i>Optional.</i> A task priority that, if set, specifies the priority for a decision task of this workflow
     * execution. This overrides the defaultTaskPriority specified when registering the workflow type. Valid values are
     * integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code>
     * (2147483647). Higher numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return Optional.</i> A task priority that, if set, specifies the priority for a decision task of this workflow
     *         execution. This overrides the defaultTaskPriority specified when registering the workflow type. Valid
     *         values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
     *         <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
     * <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
     * <a>RegisterWorkflowType</a>.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * <note>A task start-to-close timeout for this workflow execution must be specified either as a default for the
     * workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close
     * timeout was specified at registration time then a fault will be returned.</note>
     * 
     * @return Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides
     *         the <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
     *         <a>RegisterWorkflowType</a>.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     *         </p>
     *         <note>A task start-to-close timeout for this workflow execution must be specified either as a default for
     *         the workflow type or through this parameter. If neither this parameter is set nor a default task
     *         start-to-close timeout was specified at registration time then a fault will be returned.
     */
    public String taskStartToCloseTimeout() {
        return taskStartToCloseTimeout;
    }

    /**
     * <p>
     * <i>Optional.</i> If set, specifies the policy to use for the child workflow executions if the workflow execution
     * being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an
     * expired timeout. This policy overrides the default child policy specified when registering the workflow type
     * using <a>RegisterWorkflowType</a>.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * <note>A child policy for this workflow execution must be specified either as a default for the workflow type or
     * through this parameter. If neither this parameter is set nor a default child policy was specified at registration
     * time then a fault will be returned.</note>
     * 
     * @return Optional.</i> If set, specifies the policy to use for the child workflow executions if the workflow
     *         execution being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly
     *         or due to an expired timeout. This policy overrides the default child policy specified when registering
     *         the workflow type using <a>RegisterWorkflowType</a>.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     *         </ul>
     * @see ChildPolicy
     */
    public String childPolicy() {
        return childPolicy;
    }

    /**
     * <p>
     * The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You can
     * list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
     * <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
     * </p>
     * 
     * @return The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified.
     *         You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
     *         <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
     */
    public List<String> tagList() {
        return tagList;
    }

    /**
     * <p>
     * The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.
     * </p>
     * <note>In order for this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be
     * specified either as a default for the workflow type or through this field.</note>
     * 
     * @return The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.</p> <note>In order for
     *         this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be specified either
     *         as a default for the workflow type or through this field.
     */
    public String lambdaRole() {
        return lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((workflowType() == null) ? 0 : workflowType().hashCode());
        hashCode = 31 * hashCode + ((workflowId() == null) ? 0 : workflowId().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((executionStartToCloseTimeout() == null) ? 0 : executionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((taskPriority() == null) ? 0 : taskPriority().hashCode());
        hashCode = 31 * hashCode + ((taskStartToCloseTimeout() == null) ? 0 : taskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((childPolicy() == null) ? 0 : childPolicy().hashCode());
        hashCode = 31 * hashCode + ((tagList() == null) ? 0 : tagList().hashCode());
        hashCode = 31 * hashCode + ((lambdaRole() == null) ? 0 : lambdaRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChildWorkflowExecutionDecisionAttributes)) {
            return false;
        }
        StartChildWorkflowExecutionDecisionAttributes other = (StartChildWorkflowExecutionDecisionAttributes) obj;
        if (other.workflowType() == null ^ this.workflowType() == null) {
            return false;
        }
        if (other.workflowType() != null && !other.workflowType().equals(this.workflowType())) {
            return false;
        }
        if (other.workflowId() == null ^ this.workflowId() == null) {
            return false;
        }
        if (other.workflowId() != null && !other.workflowId().equals(this.workflowId())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.executionStartToCloseTimeout() == null ^ this.executionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.executionStartToCloseTimeout() != null
                && !other.executionStartToCloseTimeout().equals(this.executionStartToCloseTimeout())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.taskStartToCloseTimeout() == null ^ this.taskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.taskStartToCloseTimeout() != null && !other.taskStartToCloseTimeout().equals(this.taskStartToCloseTimeout())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        if (other.tagList() != null && !other.tagList().equals(this.tagList())) {
            return false;
        }
        if (other.lambdaRole() == null ^ this.lambdaRole() == null) {
            return false;
        }
        if (other.lambdaRole() != null && !other.lambdaRole().equals(this.lambdaRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (workflowType() != null) {
            sb.append("WorkflowType: ").append(workflowType()).append(",");
        }
        if (workflowId() != null) {
            sb.append("WorkflowId: ").append(workflowId()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (executionStartToCloseTimeout() != null) {
            sb.append("ExecutionStartToCloseTimeout: ").append(executionStartToCloseTimeout()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (taskPriority() != null) {
            sb.append("TaskPriority: ").append(taskPriority()).append(",");
        }
        if (taskStartToCloseTimeout() != null) {
            sb.append("TaskStartToCloseTimeout: ").append(taskStartToCloseTimeout()).append(",");
        }
        if (childPolicy() != null) {
            sb.append("ChildPolicy: ").append(childPolicy()).append(",");
        }
        if (tagList() != null) {
            sb.append("TagList: ").append(tagList()).append(",");
        }
        if (lambdaRole() != null) {
            sb.append("LambdaRole: ").append(lambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StartChildWorkflowExecutionDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StartChildWorkflowExecutionDecisionAttributes> {
        /**
         * <p>
         * <b>Required.</b> The type of the workflow execution to be started.
         * </p>
         * 
         * @param workflowType
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * <b>Required.</b> The <code>workflowId</code> of the workflow execution.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param workflowId
         *        Required.</b> The <code>workflowId</code> of the workflow execution.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * This data is not sent to the child workflow execution.
         * </p>
         * 
         * @param control
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The input to be provided to the workflow execution.
         * </p>
         * 
         * @param input
         *        The input to be provided to the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
         * specified when registering the workflow type.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * <note>An execution start-to-close timeout for this workflow execution must be specified either as a default
         * for the workflow type or through this parameter. If neither this parameter is set nor a default execution
         * start-to-close timeout was specified at registration time then a fault will be returned.</note>
         * 
         * @param executionStartToCloseTimeout
         *        The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
         *        specified when registering the workflow type.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         *        </p>
         *        <note>An execution start-to-close timeout for this workflow execution must be specified either as a
         *        default for the workflow type or through this parameter. If neither this parameter is set nor a
         *        default execution start-to-close timeout was specified at registration time then a fault will be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartToCloseTimeout(String executionStartToCloseTimeout);

        /**
         * <p>
         * The name of the task list to be used for decision tasks of the child workflow execution.
         * </p>
         * <note>A task list for this workflow execution must be specified either as a default for the workflow type or
         * through this parameter. If neither this parameter is set nor a default task list was specified at
         * registration time then a fault will be returned.</note>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param taskList
         *        The name of the task list to be used for decision tasks of the child workflow execution.</p> <note>A
         *        task list for this workflow execution must be specified either as a default for the workflow type or
         *        through this parameter. If neither this parameter is set nor a default task list was specified at
         *        registration time then a fault will be returned.</note>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters
         *        (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal string quotarnquot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * <i>Optional.</i> A task priority that, if set, specifies the priority for a decision task of this workflow
         * execution. This overrides the defaultTaskPriority specified when registering the workflow type. Valid values
         * are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         * <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        Optional.</i> A task priority that, if set, specifies the priority for a decision task of this
         *        workflow execution. This overrides the defaultTaskPriority specified when registering the workflow
         *        type. Valid values are integers that range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to
         *        <code>Integer.MAX_VALUE</code> (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the
         * <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
         * <a>RegisterWorkflowType</a>.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * <note>A task start-to-close timeout for this workflow execution must be specified either as a default for the
         * workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close
         * timeout was specified at registration time then a fault will be returned.</note>
         * 
         * @param taskStartToCloseTimeout
         *        Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides
         *        the <code>defaultTaskStartToCloseTimout</code> specified when registering the workflow type using
         *        <a>RegisterWorkflowType</a>.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         *        </p>
         *        <note>A task start-to-close timeout for this workflow execution must be specified either as a default
         *        for the workflow type or through this parameter. If neither this parameter is set nor a default task
         *        start-to-close timeout was specified at registration time then a fault will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartToCloseTimeout(String taskStartToCloseTimeout);

        /**
         * <p>
         * <i>Optional.</i> If set, specifies the policy to use for the child workflow executions if the workflow
         * execution being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly or
         * due to an expired timeout. This policy overrides the default child policy specified when registering the
         * workflow type using <a>RegisterWorkflowType</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * <note>A child policy for this workflow execution must be specified either as a default for the workflow type
         * or through this parameter. If neither this parameter is set nor a default child policy was specified at
         * registration time then a fault will be returned.</note>
         * 
         * @param childPolicy
         *        Optional.</i> If set, specifies the policy to use for the child workflow executions if the workflow
         *        execution being started is terminated by calling the <a>TerminateWorkflowExecution</a> action
         *        explicitly or due to an expired timeout. This policy overrides the default child policy specified when
         *        registering the workflow type using <a>RegisterWorkflowType</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * <i>Optional.</i> If set, specifies the policy to use for the child workflow executions if the workflow
         * execution being started is terminated by calling the <a>TerminateWorkflowExecution</a> action explicitly or
         * due to an expired timeout. This policy overrides the default child policy specified when registering the
         * workflow type using <a>RegisterWorkflowType</a>.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * <note>A child policy for this workflow execution must be specified either as a default for the workflow type
         * or through this parameter. If neither this parameter is set nor a default child policy was specified at
         * registration time then a fault will be returned.</note>
         * 
         * @param childPolicy
         *        Optional.</i> If set, specifies the policy to use for the child workflow executions if the workflow
         *        execution being started is terminated by calling the <a>TerminateWorkflowExecution</a> action
         *        explicitly or due to an expired timeout. This policy overrides the default child policy specified when
         *        registering the workflow type using <a>RegisterWorkflowType</a>.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You
         * can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         * <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * </p>
         * 
         * @param tagList
         *        The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified.
         *        You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         *        <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<String> tagList);

        /**
         * <p>
         * The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You
         * can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         * <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTagList(java.util.Collection)} or {@link #withTagList(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param tagList
         *        The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified.
         *        You can list workflow executions with a specific tag by calling <a>ListOpenWorkflowExecutions</a> or
         *        <a>ListClosedWorkflowExecutions</a> and specifying a <a>TagFilter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(String... tagList);

        /**
         * <p>
         * The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.
         * </p>
         * <note>In order for this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be
         * specified either as a default for the workflow type or through this field.</note>
         * 
         * @param lambdaRole
         *        The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.</p> <note>In order
         *        for this workflow execution to invoke AWS Lambda functions, an appropriate IAM role must be specified
         *        either as a default for the workflow type or through this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaRole(String lambdaRole);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowType workflowType;

        private String workflowId;

        private String control;

        private String input;

        private String executionStartToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private String taskStartToCloseTimeout;

        private String childPolicy;

        private List<String> tagList;

        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChildWorkflowExecutionDecisionAttributes model) {
            setWorkflowType(model.workflowType);
            setWorkflowId(model.workflowId);
            setControl(model.control);
            setInput(model.input);
            setExecutionStartToCloseTimeout(model.executionStartToCloseTimeout);
            setTaskList(model.taskList);
            setTaskPriority(model.taskPriority);
            setTaskStartToCloseTimeout(model.taskStartToCloseTimeout);
            setChildPolicy(model.childPolicy);
            setTagList(model.tagList);
            setLambdaRole(model.lambdaRole);
        }

        public final WorkflowType getWorkflowType() {
            return workflowType;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public final void setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getExecutionStartToCloseTimeout() {
            return executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getTaskStartToCloseTimeout() {
            return taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        public final Collection<String> getTagList() {
            return tagList;
        }

        @Override
        public final Builder tagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<String> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(String... tagList) {
            if (this.tagList == null) {
                this.tagList = new ArrayList<>(tagList.length);
            }
            for (String e : tagList) {
                this.tagList.add(e);
            }
        }

        public final String getLambdaRole() {
            return lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public StartChildWorkflowExecutionDecisionAttributes build() {
            return new StartChildWorkflowExecutionDecisionAttributes(this);
        }
    }
}
