/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.StartTimerDecisionAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>StartTimer</code> decision.
 * </p>
 * <p>
 * <b>Access Control</b>
 * </p>
 * <p>
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * </p>
 * <ul>
 * <li>Use a <code>Resource</code> element with the domain name to limit the action to only specified domains.</li>
 * <li>Use an <code>Action</code> element to allow or deny permission to call this action.</li>
 * <li>You cannot use an IAM policy to constrain this action's parameters.</li>
 * </ul>
 * <p>
 * If the caller does not have sufficient permissions to invoke the action, or the parameter values fall outside the
 * specified constraints, the action fails. The associated event attribute's <b>cause</b> parameter will be set to
 * OPERATION_NOT_PERMITTED. For details and example IAM policies, see <a
 * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
 * Amazon SWF Workflows</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartTimerDecisionAttributes implements StructuredPojo,
        ToCopyableBuilder<StartTimerDecisionAttributes.Builder, StartTimerDecisionAttributes> {
    private final String timerId;

    private final String control;

    private final String startToFireTimeout;

    private StartTimerDecisionAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
        this.control = builder.control;
        this.startToFireTimeout = builder.startToFireTimeout;
    }

    /**
     * <p>
     * <b>Required.</b> The unique ID of the timer.
     * </p>
     * <p>
     * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
     * \u009f). Also, it must not contain the literal string quotarnquot.
     * </p>
     * 
     * @return Required.</b> The unique ID of the timer.</p>
     *         <p>
     *         The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
     *         <code>/</code> (slash), <code>|
     */
    public String timerId() {
        return timerId;
    }

    /**
     * <p>
     * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
     * </p>
     * 
     * @return Optional.
     */
    public String control() {
        return control;
    }

    /**
     * <p>
     * <b>Required.</b> The duration to wait before firing the timer.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0.
     * </p>
     * 
     * @return Required.</b> The duration to wait before firing the timer.</p>
     */
    public String startToFireTimeout() {
        return startToFireTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timerId() == null) ? 0 : timerId().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        hashCode = 31 * hashCode + ((startToFireTimeout() == null) ? 0 : startToFireTimeout().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTimerDecisionAttributes)) {
            return false;
        }
        StartTimerDecisionAttributes other = (StartTimerDecisionAttributes) obj;
        if (other.timerId() == null ^ this.timerId() == null) {
            return false;
        }
        if (other.timerId() != null && !other.timerId().equals(this.timerId())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        if (other.startToFireTimeout() == null ^ this.startToFireTimeout() == null) {
            return false;
        }
        if (other.startToFireTimeout() != null && !other.startToFireTimeout().equals(this.startToFireTimeout())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timerId() != null) {
            sb.append("TimerId: ").append(timerId()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        if (startToFireTimeout() != null) {
            sb.append("StartToFireTimeout: ").append(startToFireTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StartTimerDecisionAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StartTimerDecisionAttributes> {
        /**
         * <p>
         * <b>Required.</b> The unique ID of the timer.
         * </p>
         * <p>
         * The specified string must not start or end with whitespace. It must not contain a <code>:</code> (colon),
         * <code>/</code> (slash), <code>|</code> (vertical bar), or any control characters (\u0000-\u001f | \u007f -
         * \u009f). Also, it must not contain the literal string quotarnquot.
         * </p>
         * 
         * @param timerId
         *        Required.</b> The unique ID of the timer.</p>
         *        <p>
         *        The specified string must not start or end with whitespace. It must not contain a <code>:</code>
         *        (colon), <code>/</code> (slash), <code>|
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);

        /**
         * <p>
         * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * </p>
         * 
         * @param control
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * <b>Required.</b> The duration to wait before firing the timer.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0.
         * </p>
         * 
         * @param startToFireTimeout
         *        Required.</b> The duration to wait before firing the timer.</p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToFireTimeout(String startToFireTimeout);
    }

    private static final class BuilderImpl implements Builder {
        private String timerId;

        private String control;

        private String startToFireTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTimerDecisionAttributes model) {
            setTimerId(model.timerId);
            setControl(model.control);
            setStartToFireTimeout(model.startToFireTimeout);
        }

        public final String getTimerId() {
            return timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getStartToFireTimeout() {
            return startToFireTimeout;
        }

        @Override
        public final Builder startToFireTimeout(String startToFireTimeout) {
            this.startToFireTimeout = startToFireTimeout;
            return this;
        }

        public final void setStartToFireTimeout(String startToFireTimeout) {
            this.startToFireTimeout = startToFireTimeout;
        }

        @Override
        public StartTimerDecisionAttributes build() {
            return new StartTimerDecisionAttributes(this);
        }
    }
}
