/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the <code>runId</code> of a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartWorkflowExecutionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<StartWorkflowExecutionResponse.Builder, StartWorkflowExecutionResponse> {
    private final String runId;

    private StartWorkflowExecutionResponse(BuilderImpl builder) {
        this.runId = builder.runId;
    }

    /**
     * <p>
     * The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to uniquely
     * identify the workflow execution within a domain.
     * </p>
     * 
     * @return The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to
     *         uniquely identify the workflow execution within a domain.
     */
    public String runId() {
        return runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((runId() == null) ? 0 : runId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowExecutionResponse)) {
            return false;
        }
        StartWorkflowExecutionResponse other = (StartWorkflowExecutionResponse) obj;
        if (other.runId() == null ^ this.runId() == null) {
            return false;
        }
        if (other.runId() != null && !other.runId().equals(this.runId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (runId() != null) {
            sb.append("RunId: ").append(runId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StartWorkflowExecutionResponse> {
        /**
         * <p>
         * The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to
         * uniquely identify the workflow execution within a domain.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to
         *        uniquely identify the workflow execution within a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);
    }

    private static final class BuilderImpl implements Builder {
        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowExecutionResponse model) {
            setRunId(model.runId);
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public StartWorkflowExecutionResponse build() {
            return new StartWorkflowExecutionResponse(this);
        }
    }
}
