/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.TagFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to filter the workflow executions in visibility APIs based on a tag.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TagFilter implements StructuredPojo, ToCopyableBuilder<TagFilter.Builder, TagFilter> {
    private final String tag;

    private TagFilter(BuilderImpl builder) {
        this.tag = builder.tag;
    }

    /**
     * <p>
     * <b>Required.</b> Specifies the tag that must be associated with the execution for it to meet the filter criteria.
     * </p>
     * 
     * @return Required.
     */
    public String tag() {
        return tag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tag() == null) ? 0 : tag().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagFilter)) {
            return false;
        }
        TagFilter other = (TagFilter) obj;
        if (other.tag() == null ^ this.tag() == null) {
            return false;
        }
        if (other.tag() != null && !other.tag().equals(this.tag())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tag() != null) {
            sb.append("Tag: ").append(tag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TagFilter> {
        /**
         * <p>
         * <b>Required.</b> Specifies the tag that must be associated with the execution for it to meet the filter
         * criteria.
         * </p>
         * 
         * @param tag
         *        Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(String tag);
    }

    private static final class BuilderImpl implements Builder {
        private String tag;

        private BuilderImpl() {
        }

        private BuilderImpl(TagFilter model) {
            setTag(model.tag);
        }

        public final String getTag() {
            return tag;
        }

        @Override
        public final Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(String tag) {
            this.tag = tag;
        }

        @Override
        public TagFilter build() {
            return new TagFilter(this);
        }
    }
}
