/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.TimerCanceledEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>TimerCanceled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TimerCanceledEventAttributes implements StructuredPojo,
        ToCopyableBuilder<TimerCanceledEventAttributes.Builder, TimerCanceledEventAttributes> {
    private final String timerId;

    private final Long startedEventId;

    private final Long decisionTaskCompletedEventId;

    private TimerCanceledEventAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
        this.startedEventId = builder.startedEventId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The unique ID of the timer that was canceled.
     * </p>
     * 
     * @return The unique ID of the timer that was canceled.
     */
    public String timerId() {
        return timerId;
    }

    /**
     * <p>
     * The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This information can
     * be useful for diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This
     *         information can be useful for diagnosing problems by tracing back the chain of events leading up to this
     *         event.
     */
    public Long startedEventId() {
        return startedEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing problems by
     * tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timerId() == null) ? 0 : timerId().hashCode());
        hashCode = 31 * hashCode + ((startedEventId() == null) ? 0 : startedEventId().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerCanceledEventAttributes)) {
            return false;
        }
        TimerCanceledEventAttributes other = (TimerCanceledEventAttributes) obj;
        if (other.timerId() == null ^ this.timerId() == null) {
            return false;
        }
        if (other.timerId() != null && !other.timerId().equals(this.timerId())) {
            return false;
        }
        if (other.startedEventId() == null ^ this.startedEventId() == null) {
            return false;
        }
        if (other.startedEventId() != null && !other.startedEventId().equals(this.startedEventId())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timerId() != null) {
            sb.append("TimerId: ").append(timerId()).append(",");
        }
        if (startedEventId() != null) {
            sb.append("StartedEventId: ").append(startedEventId()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimerCanceledEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimerCanceledEventAttributes> {
        /**
         * <p>
         * The unique ID of the timer that was canceled.
         * </p>
         * 
         * @param timerId
         *        The unique ID of the timer that was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);

        /**
         * <p>
         * The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This information
         * can be useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param startedEventId
         *        The ID of the <code>TimerStarted</code> event that was recorded when this timer was started. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedEventId(Long startedEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>CancelTimer</code> decision to cancel this timer. This information can be useful for diagnosing
         * problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>CancelTimer</code> decision to cancel this timer. This information can be useful
         *        for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String timerId;

        private Long startedEventId;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(TimerCanceledEventAttributes model) {
            setTimerId(model.timerId);
            setStartedEventId(model.startedEventId);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getTimerId() {
            return timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        public final Long getStartedEventId() {
            return startedEventId;
        }

        @Override
        public final Builder startedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
            return this;
        }

        public final void setStartedEventId(Long startedEventId) {
            this.startedEventId = startedEventId;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public TimerCanceledEventAttributes build() {
            return new TimerCanceledEventAttributes(this);
        }
    }
}
