/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.TimerStartedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>TimerStarted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TimerStartedEventAttributes implements StructuredPojo,
        ToCopyableBuilder<TimerStartedEventAttributes.Builder, TimerStartedEventAttributes> {
    private final String timerId;

    private final String control;

    private final String startToFireTimeout;

    private final Long decisionTaskCompletedEventId;

    private TimerStartedEventAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
        this.control = builder.control;
        this.startToFireTimeout = builder.startToFireTimeout;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The unique ID of the timer that was started.
     * </p>
     * 
     * @return The unique ID of the timer that was started.
     */
    public String timerId() {
        return timerId;
    }

    /**
     * <p>
     * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
     * </p>
     * 
     * @return Optional.
     */
    public String control() {
        return control;
    }

    /**
     * <p>
     * The duration of time after which the timer will fire.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0.
     * </p>
     * 
     * @return The duration of time after which the timer will fire.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0.
     */
    public String startToFireTimeout() {
        return startToFireTimeout;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems
     * by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>StartTimer</code> decision for this activity task. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timerId() == null) ? 0 : timerId().hashCode());
        hashCode = 31 * hashCode + ((control() == null) ? 0 : control().hashCode());
        hashCode = 31 * hashCode + ((startToFireTimeout() == null) ? 0 : startToFireTimeout().hashCode());
        hashCode = 31 * hashCode + ((decisionTaskCompletedEventId() == null) ? 0 : decisionTaskCompletedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerStartedEventAttributes)) {
            return false;
        }
        TimerStartedEventAttributes other = (TimerStartedEventAttributes) obj;
        if (other.timerId() == null ^ this.timerId() == null) {
            return false;
        }
        if (other.timerId() != null && !other.timerId().equals(this.timerId())) {
            return false;
        }
        if (other.control() == null ^ this.control() == null) {
            return false;
        }
        if (other.control() != null && !other.control().equals(this.control())) {
            return false;
        }
        if (other.startToFireTimeout() == null ^ this.startToFireTimeout() == null) {
            return false;
        }
        if (other.startToFireTimeout() != null && !other.startToFireTimeout().equals(this.startToFireTimeout())) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() == null ^ this.decisionTaskCompletedEventId() == null) {
            return false;
        }
        if (other.decisionTaskCompletedEventId() != null
                && !other.decisionTaskCompletedEventId().equals(this.decisionTaskCompletedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timerId() != null) {
            sb.append("TimerId: ").append(timerId()).append(",");
        }
        if (control() != null) {
            sb.append("Control: ").append(control()).append(",");
        }
        if (startToFireTimeout() != null) {
            sb.append("StartToFireTimeout: ").append(startToFireTimeout()).append(",");
        }
        if (decisionTaskCompletedEventId() != null) {
            sb.append("DecisionTaskCompletedEventId: ").append(decisionTaskCompletedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimerStartedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimerStartedEventAttributes> {
        /**
         * <p>
         * The unique ID of the timer that was started.
         * </p>
         * 
         * @param timerId
         *        The unique ID of the timer that was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);

        /**
         * <p>
         * <i>Optional.</i> Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * </p>
         * 
         * @param control
         *        Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The duration of time after which the timer will fire.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0.
         * </p>
         * 
         * @param startToFireTimeout
         *        The duration of time after which the timer will fire.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToFireTimeout(String startToFireTimeout);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing
         * problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>StartTimer</code> decision for this activity task. This information can be
         *        useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String timerId;

        private String control;

        private String startToFireTimeout;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(TimerStartedEventAttributes model) {
            setTimerId(model.timerId);
            setControl(model.control);
            setStartToFireTimeout(model.startToFireTimeout);
            setDecisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getTimerId() {
            return timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getStartToFireTimeout() {
            return startToFireTimeout;
        }

        @Override
        public final Builder startToFireTimeout(String startToFireTimeout) {
            this.startToFireTimeout = startToFireTimeout;
            return this;
        }

        public final void setStartToFireTimeout(String startToFireTimeout) {
            this.startToFireTimeout = startToFireTimeout;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public TimerStartedEventAttributes build() {
            return new TimerStartedEventAttributes(this);
        }
    }
}
