/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionCancelRequestedEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>WorkflowExecutionCancelRequested</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionCancelRequestedEventAttributes
        implements
        StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionCancelRequestedEventAttributes.Builder, WorkflowExecutionCancelRequestedEventAttributes> {
    private final WorkflowExecution externalWorkflowExecution;

    private final Long externalInitiatedEventId;

    private final String cause;

    private WorkflowExecutionCancelRequestedEventAttributes(BuilderImpl builder) {
        this.externalWorkflowExecution = builder.externalWorkflowExecution;
        this.externalInitiatedEventId = builder.externalInitiatedEventId;
        this.cause = builder.cause;
    }

    /**
     * <p>
     * The external workflow execution for which the cancellation was requested.
     * </p>
     * 
     * @return The external workflow execution for which the cancellation was requested.
     */
    public WorkflowExecution externalWorkflowExecution() {
        return externalWorkflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source event
     * with this ID can be found in the history of the source workflow execution. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source
     *         event with this ID can be found in the history of the source workflow execution. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long externalInitiatedEventId() {
        return externalInitiatedEventId;
    }

    /**
     * <p>
     * If set, indicates that the request to cancel the workflow execution was automatically generated, and specifies
     * the cause. This happens if the parent workflow execution times out or is terminated, and the child policy is set
     * to cancel child executions.
     * </p>
     * 
     * @return If set, indicates that the request to cancel the workflow execution was automatically generated, and
     *         specifies the cause. This happens if the parent workflow execution times out or is terminated, and the
     *         child policy is set to cancel child executions.
     * @see WorkflowExecutionCancelRequestedCause
     */
    public String cause() {
        return cause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((externalWorkflowExecution() == null) ? 0 : externalWorkflowExecution().hashCode());
        hashCode = 31 * hashCode + ((externalInitiatedEventId() == null) ? 0 : externalInitiatedEventId().hashCode());
        hashCode = 31 * hashCode + ((cause() == null) ? 0 : cause().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionCancelRequestedEventAttributes)) {
            return false;
        }
        WorkflowExecutionCancelRequestedEventAttributes other = (WorkflowExecutionCancelRequestedEventAttributes) obj;
        if (other.externalWorkflowExecution() == null ^ this.externalWorkflowExecution() == null) {
            return false;
        }
        if (other.externalWorkflowExecution() != null
                && !other.externalWorkflowExecution().equals(this.externalWorkflowExecution())) {
            return false;
        }
        if (other.externalInitiatedEventId() == null ^ this.externalInitiatedEventId() == null) {
            return false;
        }
        if (other.externalInitiatedEventId() != null && !other.externalInitiatedEventId().equals(this.externalInitiatedEventId())) {
            return false;
        }
        if (other.cause() == null ^ this.cause() == null) {
            return false;
        }
        if (other.cause() != null && !other.cause().equals(this.cause())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (externalWorkflowExecution() != null) {
            sb.append("ExternalWorkflowExecution: ").append(externalWorkflowExecution()).append(",");
        }
        if (externalInitiatedEventId() != null) {
            sb.append("ExternalInitiatedEventId: ").append(externalInitiatedEventId()).append(",");
        }
        if (cause() != null) {
            sb.append("Cause: ").append(cause()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionCancelRequestedEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionCancelRequestedEventAttributes> {
        /**
         * <p>
         * The external workflow execution for which the cancellation was requested.
         * </p>
         * 
         * @param externalWorkflowExecution
         *        The external workflow execution for which the cancellation was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution);

        /**
         * <p>
         * The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The source
         * event with this ID can be found in the history of the source workflow execution. This information can be
         * useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param externalInitiatedEventId
         *        The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>RequestCancelExternalWorkflowExecution</code> decision to cancel this workflow execution.The
         *        source event with this ID can be found in the history of the source workflow execution. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalInitiatedEventId(Long externalInitiatedEventId);

        /**
         * <p>
         * If set, indicates that the request to cancel the workflow execution was automatically generated, and
         * specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child
         * policy is set to cancel child executions.
         * </p>
         * 
         * @param cause
         *        If set, indicates that the request to cancel the workflow execution was automatically generated, and
         *        specifies the cause. This happens if the parent workflow execution times out or is terminated, and the
         *        child policy is set to cancel child executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionCancelRequestedCause
         */
        Builder cause(String cause);

        /**
         * <p>
         * If set, indicates that the request to cancel the workflow execution was automatically generated, and
         * specifies the cause. This happens if the parent workflow execution times out or is terminated, and the child
         * policy is set to cancel child executions.
         * </p>
         * 
         * @param cause
         *        If set, indicates that the request to cancel the workflow execution was automatically generated, and
         *        specifies the cause. This happens if the parent workflow execution times out or is terminated, and the
         *        child policy is set to cancel child executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionCancelRequestedCause
         */
        Builder cause(WorkflowExecutionCancelRequestedCause cause);
    }

    private static final class BuilderImpl implements Builder {
        private WorkflowExecution externalWorkflowExecution;

        private Long externalInitiatedEventId;

        private String cause;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionCancelRequestedEventAttributes model) {
            setExternalWorkflowExecution(model.externalWorkflowExecution);
            setExternalInitiatedEventId(model.externalInitiatedEventId);
            setCause(model.cause);
        }

        public final WorkflowExecution getExternalWorkflowExecution() {
            return externalWorkflowExecution;
        }

        @Override
        public final Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution;
            return this;
        }

        public final void setExternalWorkflowExecution(WorkflowExecution externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution;
        }

        public final Long getExternalInitiatedEventId() {
            return externalInitiatedEventId;
        }

        @Override
        public final Builder externalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
            return this;
        }

        public final void setExternalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public final Builder cause(WorkflowExecutionCancelRequestedCause cause) {
            this.cause(cause.toString());
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final void setCause(WorkflowExecutionCancelRequestedCause cause) {
            this.cause(cause.toString());
        }

        @Override
        public WorkflowExecutionCancelRequestedEventAttributes build() {
            return new WorkflowExecutionCancelRequestedEventAttributes(this);
        }
    }
}
