/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a workflow execution including timeout values, tasklist etc. These configuration
 * settings are determined from the defaults specified when registering the workflow type and those specified when
 * starting the workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionConfiguration implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionConfiguration.Builder, WorkflowExecutionConfiguration> {
    private final String taskStartToCloseTimeout;

    private final String executionStartToCloseTimeout;

    private final TaskList taskList;

    private final String taskPriority;

    private final String childPolicy;

    private final String lambdaRole;

    private WorkflowExecutionConfiguration(BuilderImpl builder) {
        this.taskStartToCloseTimeout = builder.taskStartToCloseTimeout;
        this.executionStartToCloseTimeout = builder.executionStartToCloseTimeout;
        this.taskList = builder.taskList;
        this.taskPriority = builder.taskPriority;
        this.childPolicy = builder.childPolicy;
        this.lambdaRole = builder.lambdaRole;
    }

    /**
     * <p>
     * The maximum duration allowed for decision tasks for this workflow execution.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return The maximum duration allowed for decision tasks for this workflow execution.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String taskStartToCloseTimeout() {
        return taskStartToCloseTimeout;
    }

    /**
     * <p>
     * The total duration for this workflow execution.
     * </p>
     * <p>
     * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
     * specify unlimited duration.
     * </p>
     * 
     * @return The total duration for this workflow execution.</p>
     *         <p>
     *         The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used
     *         to specify unlimited duration.
     */
    public String executionStartToCloseTimeout() {
        return executionStartToCloseTimeout;
    }

    /**
     * <p>
     * The task list used for the decision tasks generated for this workflow execution.
     * </p>
     * 
     * @return The task list used for the decision tasks generated for this workflow execution.
     */
    public TaskList taskList() {
        return taskList;
    }

    /**
     * <p>
     * The priority assigned to decision tasks for this workflow execution. Valid values are integers that range from
     * Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647). Higher
     * numbers indicate higher priority.
     * </p>
     * <p>
     * For more information about setting task priority, see <a
     * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     * </p>
     * 
     * @return The priority assigned to decision tasks for this workflow execution. Valid values are integers that range
     *         from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
     *         Higher numbers indicate higher priority.</p>
     *         <p>
     *         For more information about setting task priority, see <a
     *         href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
     *         Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
     */
    public String taskPriority() {
        return taskPriority;
    }

    /**
     * <p>
     * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
     * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * 
     * @return The policy to use for the child workflow executions if this workflow execution is terminated, by calling
     *         the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * @see ChildPolicy
     */
    public String childPolicy() {
        return childPolicy;
    }

    /**
     * <p>
     * The IAM role used by this workflow execution when invoking AWS Lambda functions.
     * </p>
     * 
     * @return The IAM role used by this workflow execution when invoking AWS Lambda functions.
     */
    public String lambdaRole() {
        return lambdaRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskStartToCloseTimeout() == null) ? 0 : taskStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((executionStartToCloseTimeout() == null) ? 0 : executionStartToCloseTimeout().hashCode());
        hashCode = 31 * hashCode + ((taskList() == null) ? 0 : taskList().hashCode());
        hashCode = 31 * hashCode + ((taskPriority() == null) ? 0 : taskPriority().hashCode());
        hashCode = 31 * hashCode + ((childPolicy() == null) ? 0 : childPolicy().hashCode());
        hashCode = 31 * hashCode + ((lambdaRole() == null) ? 0 : lambdaRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionConfiguration)) {
            return false;
        }
        WorkflowExecutionConfiguration other = (WorkflowExecutionConfiguration) obj;
        if (other.taskStartToCloseTimeout() == null ^ this.taskStartToCloseTimeout() == null) {
            return false;
        }
        if (other.taskStartToCloseTimeout() != null && !other.taskStartToCloseTimeout().equals(this.taskStartToCloseTimeout())) {
            return false;
        }
        if (other.executionStartToCloseTimeout() == null ^ this.executionStartToCloseTimeout() == null) {
            return false;
        }
        if (other.executionStartToCloseTimeout() != null
                && !other.executionStartToCloseTimeout().equals(this.executionStartToCloseTimeout())) {
            return false;
        }
        if (other.taskList() == null ^ this.taskList() == null) {
            return false;
        }
        if (other.taskList() != null && !other.taskList().equals(this.taskList())) {
            return false;
        }
        if (other.taskPriority() == null ^ this.taskPriority() == null) {
            return false;
        }
        if (other.taskPriority() != null && !other.taskPriority().equals(this.taskPriority())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        if (other.lambdaRole() == null ^ this.lambdaRole() == null) {
            return false;
        }
        if (other.lambdaRole() != null && !other.lambdaRole().equals(this.lambdaRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskStartToCloseTimeout() != null) {
            sb.append("TaskStartToCloseTimeout: ").append(taskStartToCloseTimeout()).append(",");
        }
        if (executionStartToCloseTimeout() != null) {
            sb.append("ExecutionStartToCloseTimeout: ").append(executionStartToCloseTimeout()).append(",");
        }
        if (taskList() != null) {
            sb.append("TaskList: ").append(taskList()).append(",");
        }
        if (taskPriority() != null) {
            sb.append("TaskPriority: ").append(taskPriority()).append(",");
        }
        if (childPolicy() != null) {
            sb.append("ChildPolicy: ").append(childPolicy()).append(",");
        }
        if (lambdaRole() != null) {
            sb.append("LambdaRole: ").append(lambdaRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionConfiguration> {
        /**
         * <p>
         * The maximum duration allowed for decision tasks for this workflow execution.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param taskStartToCloseTimeout
         *        The maximum duration allowed for decision tasks for this workflow execution.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartToCloseTimeout(String taskStartToCloseTimeout);

        /**
         * <p>
         * The total duration for this workflow execution.
         * </p>
         * <p>
         * The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be used to
         * specify unlimited duration.
         * </p>
         * 
         * @param executionStartToCloseTimeout
         *        The total duration for this workflow execution.</p>
         *        <p>
         *        The duration is specified in seconds; an integer greater than or equal to 0. The value "NONE" can be
         *        used to specify unlimited duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartToCloseTimeout(String executionStartToCloseTimeout);

        /**
         * <p>
         * The task list used for the decision tasks generated for this workflow execution.
         * </p>
         * 
         * @param taskList
         *        The task list used for the decision tasks generated for this workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskList(TaskList taskList);

        /**
         * <p>
         * The priority assigned to decision tasks for this workflow execution. Valid values are integers that range
         * from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code> (2147483647).
         * Higher numbers indicate higher priority.
         * </p>
         * <p>
         * For more information about setting task priority, see <a
         * href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting Task
         * Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * </p>
         * 
         * @param taskPriority
         *        The priority assigned to decision tasks for this workflow execution. Valid values are integers that
         *        range from Java's <code>Integer.MIN_VALUE</code> (-2147483648) to <code>Integer.MAX_VALUE</code>
         *        (2147483647). Higher numbers indicate higher priority.</p>
         *        <p>
         *        For more information about setting task priority, see <a
         *        href="http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html">Setting
         *        Task Priority</a> in the <i>Amazon Simple Workflow Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPriority(String taskPriority);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy to use for the child workflow executions if this workflow execution is terminated, by calling the
         * <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy to use for the child workflow executions if this workflow execution is terminated, by
         *        calling the <a>TerminateWorkflowExecution</a> action explicitly or due to an expired timeout.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);

        /**
         * <p>
         * The IAM role used by this workflow execution when invoking AWS Lambda functions.
         * </p>
         * 
         * @param lambdaRole
         *        The IAM role used by this workflow execution when invoking AWS Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaRole(String lambdaRole);
    }

    private static final class BuilderImpl implements Builder {
        private String taskStartToCloseTimeout;

        private String executionStartToCloseTimeout;

        private TaskList taskList;

        private String taskPriority;

        private String childPolicy;

        private String lambdaRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionConfiguration model) {
            setTaskStartToCloseTimeout(model.taskStartToCloseTimeout);
            setExecutionStartToCloseTimeout(model.executionStartToCloseTimeout);
            setTaskList(model.taskList);
            setTaskPriority(model.taskPriority);
            setChildPolicy(model.childPolicy);
            setLambdaRole(model.lambdaRole);
        }

        public final String getTaskStartToCloseTimeout() {
            return taskStartToCloseTimeout;
        }

        @Override
        public final Builder taskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
            return this;
        }

        public final void setTaskStartToCloseTimeout(String taskStartToCloseTimeout) {
            this.taskStartToCloseTimeout = taskStartToCloseTimeout;
        }

        public final String getExecutionStartToCloseTimeout() {
            return executionStartToCloseTimeout;
        }

        @Override
        public final Builder executionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
            return this;
        }

        public final void setExecutionStartToCloseTimeout(String executionStartToCloseTimeout) {
            this.executionStartToCloseTimeout = executionStartToCloseTimeout;
        }

        public final TaskList getTaskList() {
            return taskList;
        }

        @Override
        public final Builder taskList(TaskList taskList) {
            this.taskList = taskList;
            return this;
        }

        public final void setTaskList(TaskList taskList) {
            this.taskList = taskList;
        }

        public final String getTaskPriority() {
            return taskPriority;
        }

        @Override
        public final Builder taskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public final void setTaskPriority(String taskPriority) {
            this.taskPriority = taskPriority;
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        public final String getLambdaRole() {
            return lambdaRole;
        }

        @Override
        public final Builder lambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
            return this;
        }

        public final void setLambdaRole(String lambdaRole) {
            this.lambdaRole = lambdaRole;
        }

        @Override
        public WorkflowExecutionConfiguration build() {
            return new WorkflowExecutionConfiguration(this);
        }
    }
}
