/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionSignaledEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>WorkflowExecutionSignaled</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionSignaledEventAttributes implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionSignaledEventAttributes.Builder, WorkflowExecutionSignaledEventAttributes> {
    private final String signalName;

    private final String input;

    private final WorkflowExecution externalWorkflowExecution;

    private final Long externalInitiatedEventId;

    private WorkflowExecutionSignaledEventAttributes(BuilderImpl builder) {
        this.signalName = builder.signalName;
        this.input = builder.input;
        this.externalWorkflowExecution = builder.externalWorkflowExecution;
        this.externalInitiatedEventId = builder.externalInitiatedEventId;
    }

    /**
     * <p>
     * The name of the signal received. The decider can use the signal name and inputs to determine how to the process
     * the signal.
     * </p>
     * 
     * @return The name of the signal received. The decider can use the signal name and inputs to determine how to the
     *         process the signal.
     */
    public String signalName() {
        return signalName;
    }

    /**
     * <p>
     * Inputs provided with the signal (if any). The decider can use the signal name and inputs to determine how to
     * process the signal.
     * </p>
     * 
     * @return Inputs provided with the signal (if any). The decider can use the signal name and inputs to determine how
     *         to process the signal.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The workflow execution that sent the signal. This is set only of the signal was sent by another workflow
     * execution.
     * </p>
     * 
     * @return The workflow execution that sent the signal. This is set only of the signal was sent by another workflow
     *         execution.
     */
    public WorkflowExecution externalWorkflowExecution() {
        return externalWorkflowExecution;
    }

    /**
     * <p>
     * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID can
     * be found in the history of the source workflow execution. This information can be useful for diagnosing problems
     * by tracing back the chain of events leading up to this event. This field is set only if the signal was initiated
     * by another workflow execution.
     * </p>
     * 
     * @return The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this
     *         ID can be found in the history of the source workflow execution. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event. This field is set only
     *         if the signal was initiated by another workflow execution.
     */
    public Long externalInitiatedEventId() {
        return externalInitiatedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((signalName() == null) ? 0 : signalName().hashCode());
        hashCode = 31 * hashCode + ((input() == null) ? 0 : input().hashCode());
        hashCode = 31 * hashCode + ((externalWorkflowExecution() == null) ? 0 : externalWorkflowExecution().hashCode());
        hashCode = 31 * hashCode + ((externalInitiatedEventId() == null) ? 0 : externalInitiatedEventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionSignaledEventAttributes)) {
            return false;
        }
        WorkflowExecutionSignaledEventAttributes other = (WorkflowExecutionSignaledEventAttributes) obj;
        if (other.signalName() == null ^ this.signalName() == null) {
            return false;
        }
        if (other.signalName() != null && !other.signalName().equals(this.signalName())) {
            return false;
        }
        if (other.input() == null ^ this.input() == null) {
            return false;
        }
        if (other.input() != null && !other.input().equals(this.input())) {
            return false;
        }
        if (other.externalWorkflowExecution() == null ^ this.externalWorkflowExecution() == null) {
            return false;
        }
        if (other.externalWorkflowExecution() != null
                && !other.externalWorkflowExecution().equals(this.externalWorkflowExecution())) {
            return false;
        }
        if (other.externalInitiatedEventId() == null ^ this.externalInitiatedEventId() == null) {
            return false;
        }
        if (other.externalInitiatedEventId() != null && !other.externalInitiatedEventId().equals(this.externalInitiatedEventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (signalName() != null) {
            sb.append("SignalName: ").append(signalName()).append(",");
        }
        if (input() != null) {
            sb.append("Input: ").append(input()).append(",");
        }
        if (externalWorkflowExecution() != null) {
            sb.append("ExternalWorkflowExecution: ").append(externalWorkflowExecution()).append(",");
        }
        if (externalInitiatedEventId() != null) {
            sb.append("ExternalInitiatedEventId: ").append(externalInitiatedEventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionSignaledEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionSignaledEventAttributes> {
        /**
         * <p>
         * The name of the signal received. The decider can use the signal name and inputs to determine how to the
         * process the signal.
         * </p>
         * 
         * @param signalName
         *        The name of the signal received. The decider can use the signal name and inputs to determine how to
         *        the process the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalName(String signalName);

        /**
         * <p>
         * Inputs provided with the signal (if any). The decider can use the signal name and inputs to determine how to
         * process the signal.
         * </p>
         * 
         * @param input
         *        Inputs provided with the signal (if any). The decider can use the signal name and inputs to determine
         *        how to process the signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The workflow execution that sent the signal. This is set only of the signal was sent by another workflow
         * execution.
         * </p>
         * 
         * @param externalWorkflowExecution
         *        The workflow execution that sent the signal. This is set only of the signal was sent by another
         *        workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution);

        /**
         * <p>
         * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with this ID
         * can be found in the history of the source workflow execution. This information can be useful for diagnosing
         * problems by tracing back the chain of events leading up to this event. This field is set only if the signal
         * was initiated by another workflow execution.
         * </p>
         * 
         * @param externalInitiatedEventId
         *        The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>SignalExternalWorkflow</code> decision to signal this workflow execution.The source event with
         *        this ID can be found in the history of the source workflow execution. This information can be useful
         *        for diagnosing problems by tracing back the chain of events leading up to this event. This field is
         *        set only if the signal was initiated by another workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalInitiatedEventId(Long externalInitiatedEventId);
    }

    private static final class BuilderImpl implements Builder {
        private String signalName;

        private String input;

        private WorkflowExecution externalWorkflowExecution;

        private Long externalInitiatedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionSignaledEventAttributes model) {
            setSignalName(model.signalName);
            setInput(model.input);
            setExternalWorkflowExecution(model.externalWorkflowExecution);
            setExternalInitiatedEventId(model.externalInitiatedEventId);
        }

        public final String getSignalName() {
            return signalName;
        }

        @Override
        public final Builder signalName(String signalName) {
            this.signalName = signalName;
            return this;
        }

        public final void setSignalName(String signalName) {
            this.signalName = signalName;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final WorkflowExecution getExternalWorkflowExecution() {
            return externalWorkflowExecution;
        }

        @Override
        public final Builder externalWorkflowExecution(WorkflowExecution externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution;
            return this;
        }

        public final void setExternalWorkflowExecution(WorkflowExecution externalWorkflowExecution) {
            this.externalWorkflowExecution = externalWorkflowExecution;
        }

        public final Long getExternalInitiatedEventId() {
            return externalInitiatedEventId;
        }

        @Override
        public final Builder externalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
            return this;
        }

        public final void setExternalInitiatedEventId(Long externalInitiatedEventId) {
            this.externalInitiatedEventId = externalInitiatedEventId;
        }

        @Override
        public WorkflowExecutionSignaledEventAttributes build() {
            return new WorkflowExecutionSignaledEventAttributes(this);
        }
    }
}
