/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.swf.transform.WorkflowExecutionTimedOutEventAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of the <code>WorkflowExecutionTimedOut</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkflowExecutionTimedOutEventAttributes implements StructuredPojo,
        ToCopyableBuilder<WorkflowExecutionTimedOutEventAttributes.Builder, WorkflowExecutionTimedOutEventAttributes> {
    private final String timeoutType;

    private final String childPolicy;

    private WorkflowExecutionTimedOutEventAttributes(BuilderImpl builder) {
        this.timeoutType = builder.timeoutType;
        this.childPolicy = builder.childPolicy;
    }

    /**
     * <p>
     * The type of timeout that caused this event.
     * </p>
     * 
     * @return The type of timeout that caused this event.
     * @see WorkflowExecutionTimeoutType
     */
    public String timeoutType() {
        return timeoutType;
    }

    /**
     * <p>
     * The policy used for the child workflow executions of this workflow execution.
     * </p>
     * <p>
     * The supported child policies are:
     * </p>
     * <ul>
     * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take appropriate
     * actions when it receives an execution history with this event.</li>
     * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * </ul>
     * 
     * @return The policy used for the child workflow executions of this workflow execution.</p>
     *         <p>
     *         The supported child policies are:
     *         </p>
     *         <ul>
     *         <li><b>TERMINATE:</b> the child executions will be terminated.</li>
     *         <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
     *         <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
     *         appropriate actions when it receives an execution history with this event.</li>
     *         <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
     * @see ChildPolicy
     */
    public String childPolicy() {
        return childPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timeoutType() == null) ? 0 : timeoutType().hashCode());
        hashCode = 31 * hashCode + ((childPolicy() == null) ? 0 : childPolicy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionTimedOutEventAttributes)) {
            return false;
        }
        WorkflowExecutionTimedOutEventAttributes other = (WorkflowExecutionTimedOutEventAttributes) obj;
        if (other.timeoutType() == null ^ this.timeoutType() == null) {
            return false;
        }
        if (other.timeoutType() != null && !other.timeoutType().equals(this.timeoutType())) {
            return false;
        }
        if (other.childPolicy() == null ^ this.childPolicy() == null) {
            return false;
        }
        if (other.childPolicy() != null && !other.childPolicy().equals(this.childPolicy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timeoutType() != null) {
            sb.append("TimeoutType: ").append(timeoutType()).append(",");
        }
        if (childPolicy() != null) {
            sb.append("ChildPolicy: ").append(childPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionTimedOutEventAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WorkflowExecutionTimedOutEventAttributes> {
        /**
         * <p>
         * The type of timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that caused this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionTimeoutType
         */
        Builder timeoutType(String timeoutType);

        /**
         * <p>
         * The type of timeout that caused this event.
         * </p>
         * 
         * @param timeoutType
         *        The type of timeout that caused this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionTimeoutType
         */
        Builder timeoutType(WorkflowExecutionTimeoutType timeoutType);

        /**
         * <p>
         * The policy used for the child workflow executions of this workflow execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy used for the child workflow executions of this workflow execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(String childPolicy);

        /**
         * <p>
         * The policy used for the child workflow executions of this workflow execution.
         * </p>
         * <p>
         * The supported child policies are:
         * </p>
         * <ul>
         * <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         * <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording a
         * <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         * appropriate actions when it receives an execution history with this event.</li>
         * <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * </ul>
         * 
         * @param childPolicy
         *        The policy used for the child workflow executions of this workflow execution.</p>
         *        <p>
         *        The supported child policies are:
         *        </p>
         *        <ul>
         *        <li><b>TERMINATE:</b> the child executions will be terminated.</li>
         *        <li><b>REQUEST_CANCEL:</b> a request to cancel will be attempted for each child execution by recording
         *        a <code>WorkflowExecutionCancelRequested</code> event in its history. It is up to the decider to take
         *        appropriate actions when it receives an execution history with this event.</li>
         *        <li><b>ABANDON:</b> no action will be taken. The child executions will continue to run.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChildPolicy
         */
        Builder childPolicy(ChildPolicy childPolicy);
    }

    private static final class BuilderImpl implements Builder {
        private String timeoutType;

        private String childPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionTimedOutEventAttributes model) {
            setTimeoutType(model.timeoutType);
            setChildPolicy(model.childPolicy);
        }

        public final String getTimeoutType() {
            return timeoutType;
        }

        @Override
        public final Builder timeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
            return this;
        }

        @Override
        public final Builder timeoutType(WorkflowExecutionTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
            return this;
        }

        public final void setTimeoutType(String timeoutType) {
            this.timeoutType = timeoutType;
        }

        public final void setTimeoutType(WorkflowExecutionTimeoutType timeoutType) {
            this.timeoutType(timeoutType.toString());
        }

        public final String getChildPolicy() {
            return childPolicy;
        }

        @Override
        public final Builder childPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
            return this;
        }

        @Override
        public final Builder childPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
            return this;
        }

        public final void setChildPolicy(String childPolicy) {
            this.childPolicy = childPolicy;
        }

        public final void setChildPolicy(ChildPolicy childPolicy) {
            this.childPolicy(childPolicy.toString());
        }

        @Override
        public WorkflowExecutionTimedOutEventAttributes build() {
            return new WorkflowExecutionTimedOutEventAttributes(this);
        }
    }
}
